/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.nms.legacy;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import us.ajg0702.leaderboards.libs.okhttp3.OkHttpClient;
import us.ajg0702.leaderboards.libs.okhttp3.Request;
import us.ajg0702.leaderboards.libs.okhttp3.Response;
import us.ajg0702.leaderboards.libs.okhttp3.ResponseBody;
import us.ajg0702.leaderboards.libs.snakeyaml.external.biz.base64Coder.Base64Coder;
import us.ajg0702.leaderboards.libs.utils.foliacompat.CompatScheduler;
import us.ajg0702.leaderboards.libs.utils.spigot.VersionSupport;
import us.ajg0702.leaderboards.nms.legacy.CachedData;
import us.ajg0702.leaderboards.nms.legacy.DebugWrapper;
import us.ajg0702.leaderboards.nms.legacy.VersionedHeadUtils;

public class HeadUtils {
    private VersionedHeadUtils versionedHeadUtils = null;
    private final Logger logger;
    private final DebugWrapper debug;
    private final CompatScheduler scheduler;
    Map<String, CachedData<String>> skinCache = new HashMap<String, CachedData<String>>();
    final long lastClear = System.currentTimeMillis();
    private final OkHttpClient httpClient = new OkHttpClient.Builder().cache(null).build();
    final HashMap<String, String> urlCache = new HashMap();
    final HashMap<String, Long> urlLastget = new HashMap();
    final HashMap<String, Long> lastFail = new HashMap();
    private final Random random = new Random();

    public HeadUtils(Logger logger, DebugWrapper debug, CompatScheduler scheduler) {
        this.logger = logger;
        this.debug = debug;
        this.scheduler = scheduler;
        int minorVersion = VersionSupport.getMinorVersion();
        debug.infoW("Detected minor minecraft version: " + minorVersion);
        if (minorVersion >= 19) {
            try {
                this.versionedHeadUtils = (VersionedHeadUtils)Class.forName("us.ajg0702.leaderboards.nms.nms19.HeadUtils19").getDeclaredConstructor(DebugWrapper.class, CompatScheduler.class, Logger.class).newInstance(debug, scheduler, logger);
                debug.infoW("Using versioned head utils for >19 (" + minorVersion + ")");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                logger.warning("Unable to find 1.19 nms class: " + e.getMessage());
            }
        }
    }

    public VersionedHeadUtils getVersionedHeadUtils() {
        return this.versionedHeadUtils;
    }

    public ItemStack getHeadItem(UUID uuid, String name) {
        ItemStack skull = null;
        if (VersionSupport.getMinorVersion() <= 12) {
            skull = new ItemStack(Material.valueOf((String)"SKULL_ITEM"), 1, 3);
        } else if (VersionSupport.getMinorVersion() > 12) {
            skull = new ItemStack(Material.PLAYER_HEAD, 1);
        }
        String value = uuid != null && Bukkit.getOnlineMode() ? this.getHeadValue(uuid) : this.getHeadValue(name);
        if (value.equals("")) {
            return skull;
        }
        UUID hashAsId = new UUID(value.hashCode(), value.hashCode());
        return Bukkit.getUnsafe().modifyItemStack(skull, "{SkullOwner:{Id:\"" + hashAsId + "\",Properties:{textures:[{Value:\"" + value + "\"}]}}}");
    }

    public String getHeadValue(String nameOrUUID) {
        if ((double)(System.currentTimeMillis() - this.lastClear) > 5400000.0) {
            this.skinCache = new HashMap<String, CachedData<String>>();
        }
        if (this.skinCache.containsKey(nameOrUUID) && (double)this.skinCache.get(nameOrUUID).getTimeSince() < 300000.0) {
            return this.skinCache.get(nameOrUUID).getData();
        }
        String profile = this.getURLContent("https://api.ashcon.app/mojang/v2/user/" + nameOrUUID);
        if (profile.isEmpty()) {
            return "";
        }
        Gson g = new Gson();
        JsonObject jObj = (JsonObject)g.fromJson(profile, JsonObject.class);
        if (jObj == null || jObj.get("textures") == null) {
            return "";
        }
        String url = jObj.getAsJsonObject("textures").getAsJsonObject("skin").get("url").getAsString();
        byte[] skinByte = ("{\"textures\":{\"SKIN\":{\"url\":\"" + url + "\"}}}").getBytes();
        String finalSkin = new String(Base64.getEncoder().encode(skinByte));
        this.skinCache.put(nameOrUUID, new CachedData<String>(finalSkin));
        return finalSkin;
    }

    public String getHeadValue(UUID uuid) {
        return this.getHeadValue(uuid.toString());
    }

    public static GameProfile getNonPlayerProfile(String skinURL) {
        GameProfile newSkinProfile = new GameProfile(UUID.randomUUID(), null);
        newSkinProfile.getProperties().put((Object)"textures", (Object)new Property("textures", Base64Coder.encodeString("{textures:{SKIN:{url:\"" + skinURL + "\"}}}")));
        return newSkinProfile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getURLContent(String urlStr) {
        if (this.urlLastget.containsKey(urlStr) && (double)(System.currentTimeMillis() - this.urlLastget.get(urlStr)) < 300000.0) {
            return this.urlCache.get(urlStr);
        }
        if (this.lastFail.containsKey(urlStr) && (double)(System.currentTimeMillis() - this.lastFail.get(urlStr)) < 30000.0) {
            return "";
        }
        Request request = new Request.Builder().get().url(urlStr).header("user-agent", "ajLeaderboards/0").build();
        try (Response response = this.httpClient.newCall(request).execute();){
            ResponseBody body = response.body();
            if (!response.isSuccessful() || body == null) {
                this.lastFail.put(urlStr, System.currentTimeMillis() + (long)(this.random.nextInt(4000) - 2000));
                String string2 = this.urlCache.getOrDefault(urlStr, "");
                return string2;
            }
            String r = body.string();
            this.urlCache.put(urlStr, r);
            this.urlLastget.put(urlStr, System.currentTimeMillis());
            this.lastFail.remove(urlStr);
            String string = r;
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while fetching " + urlStr + ":", e);
        }
    }
}

