/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import us.ajg0702.leaderboards.libs.utils.common.Messages;

public class TimeUtils {
    private static String w = "w ";
    private static String d = "d ";
    private static String h = "h ";
    private static String m = "m ";
    private static String s = "s";
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;

    public static void setStrings(String w, String d, String h, String m, String s) {
        TimeUtils.w = w;
        TimeUtils.d = d;
        TimeUtils.h = h;
        TimeUtils.m = m;
        TimeUtils.s = s;
    }

    public static String formatTimeSeconds(long timeSeconds) {
        return TimeUtils.formatTimeMs(timeSeconds * 1000L, true, true);
    }

    public static String formatTimeSeconds(long timeSeconds, boolean withSeconds, boolean withWeeks) {
        return TimeUtils.formatTimeMs(timeSeconds * 1000L, withSeconds, withWeeks);
    }

    public static String formatTimeMs(long timeMs, boolean withSeconds, boolean withWeeks) {
        int weeks = withWeeks ? (int)(timeMs / 604800000L) : 0;
        int days = withWeeks ? (int)(timeMs % 604800000L / 86400000L) : (int)(timeMs / 86400000L);
        int hours = (int)(timeMs % 86400000L / 3600000L);
        int minutes = (int)(timeMs % 3600000L / 60000L);
        int seconds = (int)(timeMs % 60000L / 1000L);
        String weekss = weeks != 0 ? weeks + w : "";
        String dayss = days != 0 ? days + d : "";
        String hourss = hours != 0 ? hours + h : "";
        String minutess = minutes != 0 ? minutes + m : "";
        String secondss = withSeconds ? seconds + s : "";
        return weekss + dayss + hourss + minutess + secondss;
    }

    public static ZoneOffset getDefaultZoneOffset() {
        return TimeUtils.convertToZoneOffset(ZoneOffset.systemDefault());
    }

    public static ZoneOffset convertToZoneOffset(ZoneId zoneId) {
        return zoneId.getRules().getOffset(Instant.now());
    }

    public static void setStrings(Messages messages) {
        TimeUtils.setStrings(messages.getRawString("time.w", new String[0]), messages.getRawString("time.d", new String[0]), messages.getRawString("time.h", new String[0]), messages.getRawString("time.m", new String[0]), messages.getRawString("time.s", new String[0]));
    }
}

