/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.cache;

import java.util.Locale;
import org.bukkit.Bukkit;
import us.ajg0702.leaderboards.LeaderboardPlugin;

public enum BlockingFetch {
    TRUE,
    FALSE,
    AUTO;


    public static boolean shouldBlock(LeaderboardPlugin plugin) {
        BlockingFetch blockingFetch;
        String raw = plugin.getAConfig().getString("blocking-fetch");
        try {
            blockingFetch = BlockingFetch.valueOf(raw.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            plugin.getLogger().warning("Invalid option for blocking-fetch. Defaulting to auto.");
            blockingFetch = AUTO;
        }
        if (blockingFetch.isBoolean()) {
            return blockingFetch.getBoolean();
        }
        return !Bukkit.isPrimaryThread();
    }

    private boolean isBoolean() {
        return this.equals((Object)TRUE) || this.equals((Object)FALSE);
    }

    private boolean getBoolean() {
        if (this.equals((Object)TRUE)) {
            return true;
        }
        if (this.equals((Object)FALSE)) {
            return false;
        }
        throw new IllegalStateException("Not a boolean!");
    }
}

