/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.kyori.adventure.text.minimessage.internal;

import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import us.ajg0702.leaderboards.libs.jetbrains.annotations.ApiStatus;
import us.ajg0702.leaderboards.libs.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class TagInternals {
    private static final Pattern TAG_NAME_PATTERN = Pattern.compile("[!?#]?[a-z0-9_-]*");

    private TagInternals() {
    }

    public static void assertValidTagName(@NotNull String tagName) {
        if (!TAG_NAME_PATTERN.matcher(Objects.requireNonNull(tagName)).matches()) {
            throw new IllegalArgumentException("Tag name must match pattern " + TAG_NAME_PATTERN.pattern() + ", was " + tagName);
        }
    }

    public static boolean sanitizeAndCheckValidTagName(@NotNull String tagName) {
        return TAG_NAME_PATTERN.matcher(Objects.requireNonNull(tagName).toLowerCase(Locale.ROOT)).matches();
    }

    public static void sanitizeAndAssertValidTagName(@NotNull String tagName) {
        TagInternals.assertValidTagName(Objects.requireNonNull(tagName).toLowerCase(Locale.ROOT));
    }
}

