/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.slimjar.app.builder;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Map;
import us.ajg0702.leaderboards.libs.slimjar.app.Application;
import us.ajg0702.leaderboards.libs.slimjar.app.builder.ApplicationBuilder;
import us.ajg0702.leaderboards.libs.slimjar.app.builder.IsolationConfiguration;
import us.ajg0702.leaderboards.libs.slimjar.injector.DependencyInjector;
import us.ajg0702.leaderboards.libs.slimjar.injector.loader.IsolatedInjectableClassLoader;
import us.ajg0702.leaderboards.libs.slimjar.resolver.ResolutionResult;
import us.ajg0702.leaderboards.libs.slimjar.resolver.data.DependencyData;
import us.ajg0702.leaderboards.libs.slimjar.resolver.reader.dependency.DependencyDataProvider;
import us.ajg0702.leaderboards.libs.slimjar.resolver.reader.resolution.PreResolutionDataProvider;
import us.ajg0702.leaderboards.libs.slimjar.util.Modules;
import us.ajg0702.leaderboards.libs.slimjar.util.Parameters;

public final class IsolatedApplicationBuilder
extends ApplicationBuilder {
    private final IsolationConfiguration isolationConfiguration;
    private final Object[] arguments;

    public IsolatedApplicationBuilder(String applicationName, IsolationConfiguration isolationConfiguration, Object[] arguments) {
        super(applicationName);
        this.isolationConfiguration = isolationConfiguration;
        this.arguments = (Object[])arguments.clone();
    }

    @Override
    public Application buildApplication() throws IOException, ReflectiveOperationException, URISyntaxException, NoSuchAlgorithmException {
        DependencyInjector injector = this.createInjector();
        URL[] moduleUrls = Modules.extract(this.isolationConfiguration.getModuleExtractor(), this.isolationConfiguration.getModules());
        IsolatedInjectableClassLoader classLoader = new IsolatedInjectableClassLoader(moduleUrls, this.isolationConfiguration.getParentClassloader(), Collections.singleton(Application.class));
        DependencyDataProvider dataProvider = this.getDataProviderFactory().create(this.getDependencyFileUrl());
        DependencyData selfDependencyData = dataProvider.get();
        PreResolutionDataProvider preResolutionDataProvider = this.getPreResolutionDataProviderFactory().create(this.getPreResolutionFileUrl());
        Map<String, ResolutionResult> preResolutionResultMap = preResolutionDataProvider.get();
        injector.inject(classLoader, selfDependencyData, preResolutionResultMap);
        for (URL module : moduleUrls) {
            DependencyDataProvider moduleDataProvider = this.getModuleDataProviderFactory().create(module);
            DependencyData dependencyData = moduleDataProvider.get();
            injector.inject(classLoader, dependencyData, preResolutionResultMap);
        }
        Class<?> applicationClass = Class.forName(this.isolationConfiguration.getApplicationClass(), true, classLoader);
        return (Application)applicationClass.getConstructor(Parameters.typesFrom(this.arguments)).newInstance(this.arguments);
    }
}

