/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.slimjar.downloader.output;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.ajg0702.leaderboards.libs.slimjar.downloader.output.ChanneledFileOutputWriter;
import us.ajg0702.leaderboards.libs.slimjar.downloader.output.OutputWriter;
import us.ajg0702.leaderboards.libs.slimjar.downloader.output.OutputWriterFactory;
import us.ajg0702.leaderboards.libs.slimjar.downloader.strategy.FilePathStrategy;
import us.ajg0702.leaderboards.libs.slimjar.resolver.data.Dependency;

public final class DependencyOutputWriterFactory
implements OutputWriterFactory {
    private static final Logger LOGGER = Logger.getLogger(DependencyOutputWriterFactory.class.getName());
    private final FilePathStrategy outputFilePathStrategy;

    public DependencyOutputWriterFactory(FilePathStrategy filePathStrategy) {
        this.outputFilePathStrategy = filePathStrategy;
    }

    @Override
    public OutputWriter create(Dependency dependency) {
        LOGGER.log(Level.FINEST, "Creating OutputWriter for {0}", dependency.getArtifactId());
        File outputFile = this.outputFilePathStrategy.selectFileFor(dependency);
        outputFile.getParentFile().mkdirs();
        return new ChanneledFileOutputWriter(outputFile);
    }

    @Override
    public FilePathStrategy getStrategy() {
        return this.outputFilePathStrategy;
    }
}

