/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.slimjar.injector.loader.manifest;

import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import us.ajg0702.leaderboards.libs.slimjar.injector.loader.manifest.ManifestGenerator;

public final class JarManifestGenerator
implements ManifestGenerator {
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final URI jarURI;

    public JarManifestGenerator(URI jarURI) {
        this.jarURI = jarURI;
    }

    @Override
    public ManifestGenerator attribute(String key, String value) {
        this.attributes.put(key, value);
        return this;
    }

    @Override
    public void generate() throws IOException {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        URI uri = URI.create(String.format("jar:%s", this.jarURI));
        try (FileSystem fs = FileSystems.newFileSystem(uri, env);){
            Path nf = fs.getPath("META-INF/MANIFEST.MF", new String[0]);
            Files.createDirectories(nf.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(nf, StandardCharsets.UTF_8, StandardOpenOption.CREATE);){
                for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                    writer.write(String.format("%s: %s%n", entry.getKey(), entry.getValue()));
                }
            }
        }
    }

    public static ManifestGenerator with(URI uri) {
        return new JarManifestGenerator(uri);
    }
}

