/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.slimjar.resolver;

import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import us.ajg0702.leaderboards.libs.slimjar.logging.LogDispatcher;
import us.ajg0702.leaderboards.libs.slimjar.logging.ProcessLogger;
import us.ajg0702.leaderboards.libs.slimjar.resolver.DependencyResolver;
import us.ajg0702.leaderboards.libs.slimjar.resolver.ResolutionResult;
import us.ajg0702.leaderboards.libs.slimjar.resolver.data.Dependency;
import us.ajg0702.leaderboards.libs.slimjar.resolver.data.Repository;
import us.ajg0702.leaderboards.libs.slimjar.resolver.enquirer.RepositoryEnquirer;
import us.ajg0702.leaderboards.libs.slimjar.resolver.enquirer.RepositoryEnquirerFactory;
import us.ajg0702.leaderboards.libs.slimjar.resolver.pinger.URLPinger;

public final class CachingDependencyResolver
implements DependencyResolver {
    private static final String FAILED_RESOLUTION_MESSAGE = "[FAILED TO RESOLVE]";
    private static final ProcessLogger LOGGER = LogDispatcher.getMediatingLogger();
    private final URLPinger urlPinger;
    private final Collection<RepositoryEnquirer> repositories;
    private final Map<Dependency, ResolutionResult> cachedResults = new ConcurrentHashMap<Dependency, ResolutionResult>();
    private final Map<String, ResolutionResult> preResolvedResults;

    public CachingDependencyResolver(URLPinger urlPinger, Collection<Repository> repositories, RepositoryEnquirerFactory enquirerFactory, Map<String, ResolutionResult> preResolvedResults) {
        this.urlPinger = urlPinger;
        this.preResolvedResults = new ConcurrentHashMap<String, ResolutionResult>(preResolvedResults);
        this.repositories = repositories.stream().map(enquirerFactory::create).collect(Collectors.toSet());
    }

    @Override
    public Optional<ResolutionResult> resolve(Dependency dependency) {
        return Optional.ofNullable(this.cachedResults.computeIfAbsent(dependency, this::attemptResolve));
    }

    private ResolutionResult attemptResolve(Dependency dependency) {
        ResolutionResult preResolvedResult = this.preResolvedResults.get(dependency.toString());
        if (preResolvedResult != null) {
            boolean isChecksumURLValid;
            if (preResolvedResult.isAggregator()) {
                return preResolvedResult;
            }
            boolean isDependencyURLValid = this.urlPinger.ping(preResolvedResult.getDependencyURL());
            URL checksumURL = preResolvedResult.getChecksumURL();
            boolean bl = isChecksumURLValid = checksumURL == null || this.urlPinger.ping(checksumURL);
            if (isDependencyURLValid && isChecksumURLValid) {
                return preResolvedResult;
            }
        }
        Optional<ResolutionResult> result = ((Stream)this.repositories.stream().parallel()).map(enquirer -> enquirer.enquire(dependency)).filter(Objects::nonNull).findFirst();
        String resolvedResult = result.map(ResolutionResult::getDependencyURL).map(Objects::toString).orElse(FAILED_RESOLUTION_MESSAGE);
        LOGGER.log("Resolved {0} @ {1}", dependency.getArtifactId(), resolvedResult);
        return result.orElse(null);
    }
}

