/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.utils.spigot;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import us.ajg0702.leaderboards.libs.jetbrains.annotations.Nullable;

public class LocUtils {
    public static String locToString(@Nullable Location l) {
        if (l == null) {
            return null;
        }
        if (l.getWorld() == null) {
            throw new IllegalArgumentException("World cannot be null");
        }
        return l.getWorld().getName() + "," + l.getX() + "," + l.getY() + "," + l.getZ() + "," + l.getYaw() + "," + l.getPitch() + ",";
    }

    public static Location stringToLoc(@Nullable String s) {
        if (s == null) {
            return null;
        }
        String[] parts = s.split(",");
        return new Location(Bukkit.getWorld((String)parts[0]), LocUtils.dv(parts[1]), LocUtils.dv(parts[2]), LocUtils.dv(parts[3]), LocUtils.fv(parts[4]), LocUtils.fv(parts[5]));
    }

    public static Location center(Location loc) {
        Location location = loc.clone();
        location.setX((double)location.getBlockX() + 0.5);
        location.setY((double)location.getBlockY() + 0.5);
        location.setZ((double)location.getBlockZ() + 0.5);
        return location;
    }

    private static double dv(String s) {
        return Double.valueOf(s);
    }

    private static float fv(String s) {
        return Float.valueOf(s).floatValue();
    }

    public static class NoWorld {
        public static String locToString(@Nullable Location l) {
            if (l == null) {
                return null;
            }
            return l.getX() + "," + l.getY() + "," + l.getZ() + "," + l.getYaw() + "," + l.getPitch() + ",";
        }

        public static Location stringToLoc(World world, @Nullable String s) {
            if (s == null) {
                return null;
            }
            String[] parts = s.split(",");
            return new Location(world, LocUtils.dv(parts[0]), LocUtils.dv(parts[1]), LocUtils.dv(parts[2]), LocUtils.fv(parts[3]), LocUtils.fv(parts[4]));
        }
    }
}

