/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.utils;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import us.ajg0702.leaderboards.Debug;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.boards.StatEntry;
import us.ajg0702.leaderboards.boards.TimedType;
import us.ajg0702.leaderboards.utils.EasyJsonObject;

public class ResetSaver {
    private final LeaderboardPlugin plugin;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private final SimpleDateFormat timeDateFormat = new SimpleDateFormat("yyyy-MM-dd_'h'HH'm'mm");
    private final List<String> illegalFileNameChars = Arrays.asList(":", ",", File.separator, "<", ">", "\"", "|", "?", "*");

    public ResetSaver(LeaderboardPlugin plugin) {
        this.plugin = plugin;
    }

    public void save(String board, TimedType type) {
        int count = this.plugin.getAConfig().getInt("reset-save-positions");
        if (count <= 0) {
            return;
        }
        ArrayList<StatEntry> entries = new ArrayList<StatEntry>();
        for (int i = 1; i <= count; ++i) {
            entries.add(this.plugin.getCache().getStat(i, board, type));
        }
        JsonObject obj = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        for (StatEntry entry : entries) {
            jsonArray.add((JsonElement)entry.toJsonObject());
        }
        obj.add("entries", (JsonElement)jsonArray);
        String date = null;
        switch (type) {
            case ALLTIME: 
            case HOURLY: 
            case DAILY: {
                date = this.timeDateFormat.format(new Date());
                break;
            }
            case WEEKLY: 
            case MONTHLY: 
            case YEARLY: {
                date = this.dateFormat.format(new Date());
            }
        }
        File folder = new File(this.plugin.getDataFolder().getAbsolutePath() + File.separator + "past-resets" + File.separator + type.lowerName() + File.separator);
        File file = new File(folder, board.replaceAll("(" + this.illegalFileNameChars.stream().map(Pattern::quote).collect(Collectors.joining("|")) + ")", "_") + "_" + type.lowerName() + "_" + date + ".json");
        if (folder.mkdirs()) {
            Debug.info("past-resets/" + type.lowerName() + " folder created");
        }
        obj.add("meta", (JsonElement)new EasyJsonObject().add("time", System.currentTimeMillis()).add("type", type.toString()).add("board", board).getHandle());
        try {
            FileWriter writer = new FileWriter(file);
            new Gson().toJson((JsonElement)obj, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "An error occurred while writing reset save to '" + file.getPath() + "':", e);
        }
    }
}

