/*
 * Decompiled with CFR 0.152.
 */
package ru.imaginaerum.wd.client;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class ClientLayerRegistry {
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void addLayers(EntityRenderersEvent.AddLayers event) {
        ImmutableList entityTypes = ImmutableList.copyOf((Collection)ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(DefaultAttributes::m_22301_).map(entityType -> entityType).collect(Collectors.toList()));
        entityTypes.forEach(entityType -> ClientLayerRegistry.addLayerIfApplicable((EntityType<? extends LivingEntity>)entityType, event));
    }

    private static void addLayerIfApplicable(EntityType<? extends LivingEntity> entityType, EntityRenderersEvent.AddLayers event) {
        LivingEntityRenderer renderer = null;
        if (entityType != EntityType.f_20565_) {
            try {
                renderer = event.getRenderer(entityType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

