/*
 * Decompiled with CFR 0.152.
 */
package ru.imaginaerum.wd.client.gui.ars_melima;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import ru.imaginaerum.wd.client.gui.ars_melima.ArsMelimaMenu;
import ru.imaginaerum.wd.client.gui.ars_melima.ArsMelimaScreen;
import ru.imaginaerum.wd.client.gui.ars_melima.Chapter;
import ru.imaginaerum.wd.client.gui.ars_melima.ChapterElement;
import ru.imaginaerum.wd.client.gui.ars_melima.screens.ArsMelimaDraws;

public class ArsMelimaRenderer {
    public static void renderChapterList(GuiGraphics graphics, int mouseX, int mouseY, int contentLeft, int contentTop, int contentWidth, int contentHeight, Font font, ArsMelimaMenu menu, float textScale) {
        int x = contentLeft + 4;
        int y = contentTop + 4;
        int lineHeight = 12;
        List<Chapter> chapters = menu.getChapters();
        if (chapters.isEmpty()) {
            ArsMelimaDraws.drawScaledText(graphics, font, (Component)Component.m_237115_((String)"screen.wd.ars_melima.no_chapters"), x, y, -14540254, textScale);
            return;
        }
        for (int i = 0; i < chapters.size(); ++i) {
            Chapter c = chapters.get(i);
            int ty = y + i * lineHeight;
            boolean hover = ArsMelimaRenderer.isPointInRect(contentLeft + 2, ty - 2, contentWidth - 4, lineHeight + 2, mouseX, mouseY);
            int color = hover ? -2837504 : -14540254;
            ArsMelimaDraws.drawScaledText(graphics, font, c.getTitle(), x, ty, color, textScale);
        }
    }

    public static void renderChapterPage(GuiGraphics graphics, int mouseX, int mouseY, Chapter chapter, int page, int contentLeft, int contentTop, int contentWidth, int contentHeight, int rightContentLeft, int rightContentTop, int rightContentWidth, int rightContentHeight, Font font, float scale, ResourceLocation TEXTURE) {
        if (chapter == null) {
            return;
        }
        int padding = 4;
        ArsMelimaScreen.Column[] cols = new ArsMelimaScreen.Column[]{new ArsMelimaScreen.Column(contentLeft + padding, contentTop + padding, contentWidth - padding * 2, contentHeight - padding * 2), new ArsMelimaScreen.Column(rightContentLeft + padding, rightContentTop + padding, rightContentWidth - padding * 2, rightContentHeight - padding * 2)};
        List<ArsMelimaScreen.RenderUnit> units = ArsMelimaRenderer.buildRenderUnits(chapter, font, scale, cols[0].width, cols[0].height);
        List<Integer> pageStarts = ArsMelimaRenderer.computePageStartsFromUnits(units, cols[0].width, cols[0].height, scale);
        if (page < 0) {
            page = 0;
        }
        if (page >= pageStarts.size()) {
            page = pageStarts.size() - 1;
        }
        int unitIdx = pageStarts.get(page);
        int linePix = Math.max(1, (int)(10.0f * scale));
        block2: for (int col = 0; col < cols.length; ++col) {
            int cx = cols[col].left;
            int cy = cols[col].top;
            int availableHeight = cols[col].height;
            int cap = Math.max(0, availableHeight / linePix);
            int used = 0;
            while (used < cap && unitIdx < units.size()) {
                ArsMelimaScreen.RenderUnit u = units.get(unitIdx);
                if (u.type == ArsMelimaScreen.RenderUnit.Type.TEXT) {
                    ArsMelimaDraws.drawScaledText(graphics, font, u.line, cx, cy, -16777216, scale);
                    cy += linePix;
                    ++used;
                    ++unitIdx;
                    continue;
                }
                int imgW = Math.min(110, cols[col].width);
                int desiredImgH = Math.min(70, cols[col].height / 2);
                int imgH = Math.max(1, desiredImgH);
                int dx = cx + (cols[col].width - imgW) / 2;
                int rowsNeeded = Math.max(1, (int)Math.ceil((double)imgH / (double)linePix));
                if (rowsNeeded > cap - used) continue block2;
                graphics.m_280509_(dx, cy, dx + imgW, cy + imgH, -2236963);
                try {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation(u.imageResource));
                    graphics.m_280163_(new ResourceLocation(u.imageResource), dx, cy, 0.0f, 0.0f, imgW, imgH, imgW, imgH);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
                }
                catch (Exception e) {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
                }
                cy += rowsNeeded * linePix;
                used += rowsNeeded;
                ++unitIdx;
            }
        }
    }

    public static List<ArsMelimaScreen.RenderUnit> buildRenderUnits(Chapter chapter, Font font, float scale, int colWidth, int colHeight) {
        ArrayList<ArsMelimaScreen.RenderUnit> units = new ArrayList<ArsMelimaScreen.RenderUnit>();
        if (chapter == null) {
            return units;
        }
        int linePix = Math.max(1, (int)(10.0f * scale));
        int normalCap = Math.max(1, colHeight / linePix);
        for (ChapterElement el : chapter.getElements()) {
            if (el == null) continue;
            if (el.getType() == ChapterElement.Type.TEXT) {
                String txt = el.getData() == null ? "" : el.getData();
                List lines = font.m_92923_((FormattedText)Component.m_237113_((String)txt), (int)((float)colWidth / scale));
                for (FormattedCharSequence l : lines) {
                    ArsMelimaScreen.RenderUnit ru = new ArsMelimaScreen.RenderUnit();
                    ru.type = ArsMelimaScreen.RenderUnit.Type.TEXT;
                    ru.line = l;
                    ru.rows = 1;
                    units.add(ru);
                }
                continue;
            }
            if (el.getType() != ChapterElement.Type.IMAGE) continue;
            String res = el.getData();
            int imgH = Math.min(60, colHeight / 2);
            int rows = Math.max(1, (int)Math.ceil((double)imgH / (double)linePix));
            rows = Math.min(rows, normalCap);
            ArsMelimaScreen.RenderUnit ru = new ArsMelimaScreen.RenderUnit();
            ru.type = ArsMelimaScreen.RenderUnit.Type.IMAGE;
            ru.imageResource = res == null ? "" : res;
            ru.rows = rows;
            units.add(ru);
        }
        if (units.isEmpty()) {
            ArsMelimaScreen.RenderUnit ru = new ArsMelimaScreen.RenderUnit();
            ru.type = ArsMelimaScreen.RenderUnit.Type.TEXT;
            ru.line = Component.m_237113_((String)"").m_7532_();
            ru.rows = 1;
            units.add(ru);
        }
        return units;
    }

    public static List<Integer> computePageStartsFromUnits(List<ArsMelimaScreen.RenderUnit> units, int colWidth, int colHeight, float scale) {
        ArrayList<Integer> starts = new ArrayList<Integer>();
        if (units == null || units.isEmpty()) {
            starts.add(0);
            return starts;
        }
        int linePix = Math.max(1, (int)(10.0f * scale));
        int normalCap = Math.max(1, colHeight / linePix);
        int idx = 0;
        block0: while (idx < units.size()) {
            int need;
            ArsMelimaScreen.RenderUnit u;
            starts.add(idx);
            int remaining = normalCap;
            while (remaining > 0 && idx < units.size()) {
                u = units.get(idx);
                if (u.type == ArsMelimaScreen.RenderUnit.Type.TEXT) {
                    --remaining;
                    ++idx;
                    continue;
                }
                need = Math.max(1, u.rows);
                if (need > remaining) break;
                remaining -= need;
                ++idx;
            }
            remaining = normalCap;
            while (remaining > 0 && idx < units.size()) {
                u = units.get(idx);
                if (u.type == ArsMelimaScreen.RenderUnit.Type.TEXT) {
                    --remaining;
                    ++idx;
                    continue;
                }
                need = Math.max(1, u.rows);
                if (need > remaining) continue block0;
                remaining -= need;
                ++idx;
            }
        }
        return starts;
    }

    public static List<Integer> computePageStarts(Chapter chapter, Font font, float scale, int colWidth, int colHeight) {
        List<ArsMelimaScreen.RenderUnit> units = ArsMelimaRenderer.buildRenderUnits(chapter, font, scale, colWidth, colHeight);
        return ArsMelimaRenderer.computePageStartsFromUnits(units, colWidth, colHeight, scale);
    }

    private static boolean isPointInRect(int rx, int ry, int rw, int rh, int px, int py) {
        return px >= rx && py >= ry && px < rx + rw && py < ry + rh;
    }
}

