/*
 * Decompiled with CFR 0.152.
 */
package ru.imaginaerum.wd.client.gui.ars_melima;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Items;
import ru.imaginaerum.wd.client.gui.ars_melima.ArsMelimaMenu;
import ru.imaginaerum.wd.client.gui.ars_melima.ArsMelimaRenderer;
import ru.imaginaerum.wd.client.gui.ars_melima.Chapter;
import ru.imaginaerum.wd.client.gui.ars_melima.ChapterLoader;
import ru.imaginaerum.wd.client.gui.ars_melima.screens.ArsMelimaDraws;

public class ArsMelimaScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("wd", "textures/gui/ars_melima/ars_melima.png");
    static final int xSize = 512;
    static final int ySize = 512;
    private static final int BG_U = 4;
    private static final int BG_V = 273;
    private static final int BG_W = 305;
    private static final int BG_H = 184;
    private static final int FG_U = 8;
    private static final int FG_V = 12;
    private static final int FG_W = 297;
    private static final int FG_H = 185;
    private static final int BOOKMARK_U = 208;
    private static final int BOOKMARK_V = 227;
    private static final int BOOKMARK_W = 49;
    private static final int BOOKMARK_H = 20;
    private static final int BOOKMARK_ANCHOR_X = 49;
    private static final int BOOKMARK_ANCHOR_Y = 0;
    private static final int FG_ANCHOR_X = 0;
    private static final int FG_ANCHOR_Y = 25;
    private final ArsMelimaMenu menu = new ArsMelimaMenu();
    private static final int CONTENT_X1 = 8;
    private static final int CONTENT_Y1 = 20;
    private static final int CONTENT_X2 = 137;
    private static final int CONTENT_Y2 = 160;
    private int contentLeft;
    private int contentTop;
    private int contentWidth;
    private int contentHeight;
    private int rightContentLeft;
    private int rightContentTop;
    private int rightContentWidth;
    private int rightContentHeight;
    private static final int BACK_ARROW_W = 32;
    private static final int BACK_ARROW_H = 18;
    private static final int BACK_ARROW_REL_X = 132;
    private static final int BACK_ARROW_REL_Y = 174;
    private static final int BACK_ARROW_PADDING = 2;
    private static final int NAV_ARROW_W = 12;
    private static final int NAV_ARROW_H = 7;
    private static final int NAV_LEFT_REL_X = 10;
    private static final int NAV_RIGHT_REL_X = 276;
    private static final int NAV_REL_Y = 184;
    private int guiLeft = 0;
    private int guiTop = 0;
    private int currentPage = 0;
    private static final float TEXT_SCALE = 0.85f;
    static final int CONTENT_PADDING = 4;

    public ArsMelimaScreen() {
        super((Component)Component.m_237115_((String)"screen.wd.ars_melima"));
    }

    protected void m_7856_() {
        super.m_7856_();
        List<Chapter> chapters = ChapterLoader.loadChapters();
        this.menu.setChapters(chapters);
        this.menu.setCurrentIndex(-1);
        this.currentPage = 0;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        this.guiLeft = (this.f_96543_ - 297) / 2;
        this.guiTop = (this.f_96544_ - 185) / 2;
        this.contentLeft = this.guiLeft + 8;
        this.contentTop = this.guiTop + 20;
        this.contentWidth = 129;
        this.contentHeight = 140;
        this.rightContentLeft = this.guiLeft + 159;
        this.rightContentTop = this.guiTop + 20;
        this.rightContentWidth = 128;
        this.rightContentHeight = 140;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int bgLeft = this.guiLeft + -4;
        int bgTop = this.guiTop + 0;
        graphics.m_280163_(TEXTURE, bgLeft, bgTop, 4.0f, 273.0f, 305, 184, 512, 512);
        graphics.m_280163_(TEXTURE, this.guiLeft, this.guiTop, 8.0f, 12.0f, 297, 185, 512, 512);
        int bookmarkLeft = this.guiLeft + 0 - 49;
        int bookmarkTop = this.guiTop + 25 - 0;
        RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        graphics.m_280163_(TEXTURE, bookmarkLeft, bookmarkTop, 208.0f, 227.0f, 49, 20, 512, 512);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ArsMelimaDraws.renderItem(graphics, Items.f_42410_.m_7968_(), bookmarkLeft + 4, bookmarkTop);
        ArsMelimaDraws.drawAreaBackground(graphics, this.contentLeft, this.contentTop, this.contentWidth, this.contentHeight);
        ArsMelimaDraws.drawAreaBackground(graphics, this.rightContentLeft, this.rightContentTop, this.rightContentWidth, this.rightContentHeight);
        if (this.menu.getCurrentIndex() != -1) {
            boolean hover = this.isPointInRectInclusive(this.guiLeft + 142 - 2, this.guiTop + 186 - 2, 15, 15, mouseX, mouseY);
            if (hover) {
                ArsMelimaDraws.drawBackArrow(graphics, TEXTURE, this.guiLeft, this.guiTop, 177, 233, 11, 11, 512, 512, true, 142, 186);
            } else {
                ArsMelimaDraws.drawDimBackArrow(graphics, TEXTURE, this.guiLeft, this.guiTop, 177, 221, 11, 11, 512, 512, 142, 186);
            }
        }
        Chapter current = this.menu.getCurrentChapter();
        int pageCount = 0;
        if (current != null) {
            int colHeight;
            int colWidth = Math.max(1, this.contentWidth - 8);
            List<Integer> starts = this.computePageStarts(current, this.f_96547_, 0.85f, colWidth, colHeight = Math.max(1, this.contentHeight - 8));
            pageCount = Math.max(1, starts.size());
            if (this.currentPage >= pageCount) {
                this.currentPage = pageCount - 1;
            }
        } else {
            this.currentPage = 0;
        }
        if (this.menu.getCurrentIndex() != -1 && pageCount > 1) {
            int leftNavX = this.guiLeft + 10;
            int rightNavX = this.guiLeft + 276;
            int navY = this.guiTop + 184;
            boolean hoverLeft = this.isPointInRectInclusive(leftNavX, navY, 12, 7, mouseX, mouseY);
            boolean hoverRight = this.isPointInRectInclusive(rightNavX, navY, 12, 7, mouseX, mouseY);
            if (this.currentPage > 0) {
                ArsMelimaDraws.drawDimBackArrow(graphics, TEXTURE, this.guiLeft, this.guiTop, 151, 229, 12, 7, 512, 512, 10, 184);
                if (hoverLeft) {
                    ArsMelimaDraws.drawBackArrow(graphics, TEXTURE, this.guiLeft, this.guiTop, 151, 237, 12, 7, 512, 512, true, 10, 184);
                }
            }
            if (this.currentPage < pageCount - 1) {
                ArsMelimaDraws.drawDimForwardArrow(graphics, TEXTURE, this.guiLeft, this.guiTop, 164, 229, 12, 7, 512, 512, 276, 184);
                if (hoverRight) {
                    ArsMelimaDraws.drawForwardArrow(graphics, TEXTURE, this.guiLeft, this.guiTop, 164, 237, 12, 7, 512, 512, true, 276, 184);
                }
            }
        }
        if (this.menu.getCurrentIndex() == -1) {
            this.renderChapterList(graphics, mouseX, mouseY);
        } else {
            this.renderChapterPage(graphics, mouseX, mouseY, current, this.currentPage);
        }
        RenderSystem.disableBlend();
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    private void renderChapterList(GuiGraphics graphics, int mouseX, int mouseY) {
        ArsMelimaRenderer.renderChapterList(graphics, mouseX, mouseY, this.contentLeft, this.contentTop, this.contentWidth, this.contentHeight, this.f_96547_, this.menu, 0.85f);
    }

    private void renderChapterPage(GuiGraphics graphics, int mouseX, int mouseY, Chapter chapter, int page) {
        ArsMelimaRenderer.renderChapterPage(graphics, mouseX, mouseY, chapter, page, this.contentLeft, this.contentTop, this.contentWidth, this.contentHeight, this.rightContentLeft, this.rightContentTop, this.rightContentWidth, this.rightContentHeight, this.f_96547_, 0.85f, TEXTURE);
    }

    private List<RenderUnit> buildRenderUnits(Chapter chapter, Font font, float scale, int colWidth, int colHeight) {
        return ArsMelimaRenderer.buildRenderUnits(chapter, font, scale, colWidth, colHeight);
    }

    private List<Integer> computePageStartsFromUnits(List<RenderUnit> units, int colWidth, int colHeight, float scale) {
        return ArsMelimaRenderer.computePageStartsFromUnits(units, colWidth, colHeight, scale);
    }

    private List<Integer> computePageStarts(Chapter chapter, Font font, float scale, int colWidth, int colHeight) {
        return ArsMelimaRenderer.computePageStarts(chapter, font, scale, colWidth, colHeight);
    }

    private boolean isPointInRect(int rx, int ry, int rw, int rh, int px, int py) {
        return px >= rx && py >= ry && px < rx + rw && py < ry + rh;
    }

    private boolean isPointInRectInclusive(int rx, int ry, int rw, int rh, int px, int py) {
        return px >= rx && py >= ry && px <= rx + rw - 1 && py <= ry + rh - 1;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int idx;
        int mx = (int)Math.floor(mouseX);
        int my = (int)Math.floor(mouseY);
        if (this.menu.getCurrentIndex() != -1) {
            int bx = this.guiLeft + 132 - 2;
            int by = this.guiTop + 174 - 2;
            int bw = 36;
            int bh = 22;
            if (this.isPointInRectInclusive(bx, by, bw, bh, mx, my) && button == 0) {
                this.menu.closeChapter();
                this.currentPage = 0;
                if (Minecraft.m_91087_().f_91074_ != null) {
                    Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_11713_, 1.0f, 1.0f);
                }
                return true;
            }
            Chapter current = this.menu.getCurrentChapter();
            int colWidth = Math.max(1, this.contentWidth - 8);
            int colHeight = Math.max(1, this.contentHeight - 8);
            int pageCount = this.computePageStarts(current, this.f_96547_, 0.85f, colWidth, colHeight).size();
            int leftNavX = this.guiLeft + 10;
            int rightNavX = this.guiLeft + 276;
            int navY = this.guiTop + 184;
            int arrowWidth = 12;
            int arrowHeight = 7;
            if (this.isPointInRectInclusive(leftNavX, navY, arrowWidth, arrowHeight, mx, my) && button == 0 && this.currentPage > 0) {
                --this.currentPage;
                if (Minecraft.m_91087_().f_91074_ != null) {
                    Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_11713_, 1.0f, 1.0f);
                }
                return true;
            }
            if (this.isPointInRectInclusive(rightNavX, navY, arrowWidth, arrowHeight, mx, my) && button == 0 && this.currentPage < pageCount - 1) {
                ++this.currentPage;
                if (Minecraft.m_91087_().f_91074_ != null) {
                    Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_11713_, 1.0f, 1.0f);
                }
                return true;
            }
        }
        if (this.menu.getCurrentIndex() == -1 && this.isPointInRect(this.contentLeft, this.contentTop, this.contentWidth, this.contentHeight, mx, my) && (idx = (my - (this.contentTop + 4)) / 12) >= 0 && idx < this.menu.getChapters().size()) {
            this.menu.openChapter(idx);
            this.currentPage = 0;
            if (Minecraft.m_91087_().f_91074_ != null) {
                Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_11713_, 1.0f, 1.0f);
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7043_() {
        return false;
    }

    static class RenderUnit {
        Type type;
        FormattedCharSequence line;
        String imageResource;
        int rows;

        RenderUnit() {
        }

        static enum Type {
            TEXT,
            IMAGE;

        }
    }

    static class Column {
        final int left;
        final int top;
        final int width;
        final int height;

        Column(int left, int top, int width, int height) {
            this.left = left;
            this.top = top;
            this.width = width;
            this.height = height;
        }
    }
}

