/*
 * Decompiled with CFR 0.152.
 */
package ru.imaginaerum.wd.client.gui.ars_melima;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import ru.imaginaerum.wd.client.gui.ars_melima.Chapter;
import ru.imaginaerum.wd.client.gui.ars_melima.ChapterElement;

public class ChapterLoader {
    private static final Gson GSON = new Gson();
    private static final String BASE = "lang";
    private static final String SUBDIR = "ars_melima";

    public static List<Chapter> loadChapters() {
        ArrayList<Chapter> out = new ArrayList<Chapter>();
        ResourceManager manager = Minecraft.m_91087_().m_91098_();
        List<String> langs = ChapterLoader.getLanguageCandidates();
        HashSet<String> seen = new HashSet<String>();
        for (String lang : langs) {
            Object basePath = "__BASE__".equals(lang) ? "lang/ars_melima" : "lang/" + lang + "/ars_melima";
            try {
                Map found = manager.m_214159_((String)basePath, rl -> rl.m_135815_().endsWith(".json"));
                if (found == null || found.isEmpty()) continue;
                for (Map.Entry entry : found.entrySet()) {
                    ResourceLocation rl2 = (ResourceLocation)entry.getKey();
                    String uniqueKey = rl2.toString();
                    if (seen.contains(uniqueKey)) continue;
                    seen.add(uniqueKey);
                    Resource resource = (Resource)entry.getValue();
                    try {
                        InputStream is = resource.m_215507_();
                        try (InputStreamReader reader = new InputStreamReader(is);){
                            JsonObject jo = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                            String title = jo.has("title") ? jo.get("title").getAsString() : rl2.m_135815_();
                            ArrayList<ChapterElement> elements = new ArrayList<ChapterElement>();
                            if (jo.has("elements") && jo.get("elements").isJsonArray()) {
                                JsonArray arr = jo.getAsJsonArray("elements");
                                for (JsonElement el : arr) {
                                    ChapterElement.Type type;
                                    JsonObject obj = el.getAsJsonObject();
                                    if (!obj.has("type") || !obj.has("data")) continue;
                                    try {
                                        type = ChapterElement.Type.valueOf(obj.get("type").getAsString().toUpperCase(Locale.ROOT));
                                    }
                                    catch (IllegalArgumentException e) {
                                        continue;
                                    }
                                    elements.add(new ChapterElement(type, obj.get("data").getAsString()));
                                }
                            }
                            if (elements.isEmpty()) {
                                if (jo.has("content")) {
                                    elements.add(new ChapterElement(ChapterElement.Type.TEXT, jo.get("content").getAsString()));
                                }
                                if (jo.has("image")) {
                                    elements.add(new ChapterElement(ChapterElement.Type.IMAGE, jo.get("image").getAsString()));
                                }
                            }
                            String path = rl2.m_135815_();
                            String id = path.substring(path.lastIndexOf(47) + 1);
                            out.add(new Chapter(id, title, elements));
                        }
                        finally {
                            if (is == null) continue;
                            is.close();
                        }
                    }
                    catch (Exception e) {
                        System.err.println("[ArsMelima] Failed to load chapter resource " + String.valueOf(rl2) + " : " + e.getMessage());
                        e.printStackTrace();
                    }
                }
                if (out.isEmpty()) continue;
                return out;
            }
            catch (Exception e) {
                System.err.println("[ArsMelima] Error listing/loading chapter resources in " + (String)basePath + " : " + e.getMessage());
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getLanguageCandidates() {
        ArrayList<String> langs = new ArrayList<String>();
        try {
            Locale locale;
            String sel = null;
            try {
                sel = Minecraft.m_91087_().m_91102_().m_264236_();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (sel != null) {
                String code;
                if (sel instanceof String && !(code = sel).isEmpty()) {
                    langs.add(ChapterLoader.normalizeLangCode(code));
                } else {
                    try {
                        String code2;
                        Method m = sel.getClass().getMethod("getCode", new Class[0]);
                        Object codeObj = m.invoke((Object)sel, new Object[0]);
                        if (codeObj instanceof String && !(code2 = (String)codeObj).isEmpty()) {
                            langs.add(ChapterLoader.normalizeLangCode(code2));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if ((locale = Locale.getDefault()) != null) {
                langs.add(ChapterLoader.normalizeLangCode(locale.toString()));
                langs.add(ChapterLoader.normalizeLangCode(locale.getLanguage()));
                langs.add(ChapterLoader.normalizeLangCode(locale.getLanguage() + "_" + locale.getCountry()));
            }
        }
        finally {
            langs.add("en_us");
            langs.add("ru_ru");
            langs.add("__BASE__");
        }
        return new ArrayList<String>(new LinkedHashSet(langs));
    }

    private static String normalizeLangCode(String raw) {
        if (raw == null) {
            return "";
        }
        return raw.trim().toLowerCase(Locale.ROOT).replace('-', '_');
    }
}

