/*
 * Decompiled with CFR 0.152.
 */
package ru.imaginaerum.wd.common.blocks.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;

public class CoastalSteepBlock
extends Block {
    public static final BooleanProperty WATERLOGGED = BooleanProperty.m_61465_((String)"waterlogged");

    public CoastalSteepBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (!level.f_46443_ && heldItem.m_150930_(Items.f_42590_) && ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            if (!player.m_150110_().f_35937_) {
                heldItem.m_41774_(1);
                ItemStack waterBottle = new ItemStack((ItemLike)Items.f_42589_);
                PotionUtils.m_43549_((ItemStack)waterBottle, (Potion)Potions.f_43599_);
                if (!player.m_36356_(waterBottle)) {
                    level.m_7967_((Entity)new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), waterBottle));
                }
            }
            level.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_46961_(pos, true);
            return;
        }
        if (!((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            boolean isRainy = level.m_46758_(pos.m_7494_());
            boolean hasWaterBelow = level.m_8055_(pos.m_7495_()).m_60819_().m_192917_((Fluid)Fluids.f_76193_);
            boolean hasWaterNearby = this.isWaterWithinDistance(level, pos, 3);
            if (hasWaterNearby && hasWaterBelow && random.m_188501_() < 0.3f || isRainy && level.m_46467_() % 3600L == 0L) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
            }
        }
    }

    public BlockState m_7417_(BlockState currentBlockState, Direction direction, BlockState neighborBlockState, LevelAccessor world, BlockPos currentPos, BlockPos neighborPos) {
        if (!currentBlockState.m_60710_((LevelReader)world, currentPos)) {
            world.m_186460_(currentPos, (Block)this, 1);
        }
        return super.m_7417_(currentBlockState, direction, neighborBlockState, world, currentPos, neighborPos);
    }

    public boolean m_7898_(BlockState state, LevelReader levelReader, BlockPos blockPos) {
        BlockState belowBlockState = levelReader.m_8055_(blockPos.m_7495_());
        return belowBlockState.m_60713_(Blocks.f_49992_) || belowBlockState.m_60713_(Blocks.f_49993_);
    }

    private boolean isWaterWithinDistance(ServerLevel level, BlockPos pos, int distance) {
        for (int dx = -distance; dx <= distance; ++dx) {
            for (int dz = -distance; dz <= distance; ++dz) {
                BlockPos checkPos = pos.m_7918_(dx, -1, dz);
                if (!level.m_8055_(checkPos).m_60819_().m_192917_((Fluid)Fluids.f_76193_)) continue;
                return true;
            }
        }
        return false;
    }
}

