/*
 * Decompiled with CFR 0.152.
 */
package ru.imaginaerum.wd.common.blocks.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import ru.imaginaerum.wd.common.particles.ModParticles;
import ru.imaginaerum.wd.common.sounds.CustomSoundEvents;

public class RottenPie
extends Block {
    public static final IntegerProperty STAGE = IntegerProperty.m_61631_((String)"stage", (int)0, (int)3);
    private static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    private static final VoxelShape SHAPE_1 = Shapes.m_83110_((VoxelShape)RottenPie.m_49796_((double)1.0, (double)0.0, (double)6.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)RottenPie.m_49796_((double)8.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)6.0));
    private static final VoxelShape SHAPE_2 = Block.m_49796_((double)1.0, (double)0.0, (double)6.0, (double)15.0, (double)8.0, (double)15.0);
    private static final VoxelShape SHAPE_3 = Block.m_49796_((double)1.0, (double)0.0, (double)6.0, (double)7.0, (double)8.0, (double)15.0);

    public RottenPie(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        ItemStack itemstack = player.m_21120_(hand);
        ItemStack stackHand = player.m_21120_(hand);
        Item item = stackHand.m_41720_();
        if (level.f_46443_) {
            if (RottenPie.eat((LevelAccessor)level, pos, state, player).m_19077_()) {
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41619_()) {
                return InteractionResult.CONSUME;
            }
        }
        return RottenPie.eat((LevelAccessor)level, pos, state, player);
    }

    protected static InteractionResult eat(LevelAccessor world, BlockPos blockPos, BlockState blockState, Player player) {
        if (!player.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 0));
        player.m_36220_(Stats.f_12942_);
        player.m_36324_().m_38707_(6, 0.8f);
        world.m_5594_((Player)null, blockPos, SoundEvents.f_11912_, SoundSource.BLOCKS, 1.0f, 1.0f);
        int i = (Integer)blockState.m_61143_((Property)STAGE);
        world.m_142346_((Entity)player, GameEvent.f_157806_, blockPos);
        if (i < 3) {
            world.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            world.m_7471_(blockPos, false);
            world.m_142346_((Entity)player, GameEvent.f_157794_, blockPos);
        }
        return InteractionResult.SUCCESS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STAGE});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int stage = (Integer)state.m_61143_((Property)STAGE);
        return switch (stage) {
            case 1 -> SHAPE_1;
            case 2 -> SHAPE_2;
            case 3 -> SHAPE_3;
            default -> SHAPE;
        };
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource source) {
        super.m_214162_(state, level, pos, source);
        VoxelShape voxelshape = this.m_5940_(state, (BlockGetter)level, pos, CollisionContext.m_82749_());
        level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)CustomSoundEvents.FLIES.get(), SoundSource.BLOCKS, 0.5f, source.m_188501_() * 0.4f + 0.8f, false);
        Vec3 vec3 = voxelshape.m_83215_().m_82399_();
        double d0 = (double)pos.m_123341_() + vec3.f_82479_;
        double d1 = (double)pos.m_123343_() + vec3.f_82481_;
        for (int i = 0; i < 3; ++i) {
            if (!source.m_188499_()) continue;
            level.m_7106_((ParticleOptions)ModParticles.FLIES.get(), d0 + source.m_188500_() / 10.0, (double)pos.m_123342_() + (1.0 - source.m_188500_()), d1 + source.m_188500_() / 10.0, 0.0, 0.0, 0.0);
        }
    }
}

