/*
 * Decompiled with CFR 0.152.
 */
package ru.imaginaerum.wd.common.items.custom;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import ru.imaginaerum.wd.common.blocks.BlocksWD;
import ru.imaginaerum.wd.common.blocks.custom.MagicSoilFarmland;

public class IronWateringCan
extends Item {
    private static final int MAX_CAPACITY = 1000;
    private static final int WATER_USAGE = 50;

    public IronWateringCan(Item.Properties properties) {
        super(properties);
    }

    public static boolean isFull(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128471_("water_full");
    }

    public static void setFull(ItemStack stack, boolean full) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_("water_full", full);
    }

    public static int getWaterAmount(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128451_("water_amount");
    }

    public static void setWaterAmount(ItemStack stack, int amount) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("water_amount", Math.min(amount, 1000));
        IronWateringCan.setFull(stack, amount > 0);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        int waterAmount = IronWateringCan.getWaterAmount(stack);
        tooltip.add((Component)Component.m_237113_((String)(waterAmount + "/1000 mb")));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        BlockHitResult hitResult = IronWateringCan.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hitResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            int currentWater;
            BlockPos pos = hitResult.m_82425_();
            if (!level.m_7966_(player, pos)) {
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            if (level.m_6425_(pos).m_205070_(FluidTags.f_13131_) && (currentWater = IronWateringCan.getWaterAmount(stack)) < 1000) {
                IronWateringCan.setWaterAmount(stack, 1000);
                level.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11770_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                level.m_142346_((Entity)player, GameEvent.f_157816_, pos);
                return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockState state;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (level.m_8055_(pos).m_60713_((Block)BlocksWD.MAGIC_SOIL_FARMLAND.get()) && IronWateringCan.getWaterAmount(stack) >= 50 && (state = level.m_8055_(pos)).m_61138_((Property)MagicSoilFarmland.MOIST) && !((Boolean)state.m_61143_((Property)MagicSoilFarmland.MOIST)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)MagicSoilFarmland.MOIST, (Comparable)Boolean.valueOf(true)), 3);
            int currentWater = IronWateringCan.getWaterAmount(stack);
            IronWateringCan.setWaterAmount(stack, currentWater - 50);
            level.m_5594_(player, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
            for (int i = 0; i < 10; ++i) {
                double offsetX = 0.5 + (level.f_46441_.m_188500_() - 0.5);
                double offsetY = 1.0;
                double offsetZ = 0.5 + (level.f_46441_.m_188500_() - 0.5);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123769_, (double)pos.m_123341_() + offsetX, (double)pos.m_123342_() + offsetY, (double)pos.m_123343_() + offsetZ, 0.0, 0.1, 0.0);
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public void m_7836_(ItemStack stack, Level level, Player player) {
        super.m_7836_(stack, level, player);
        if (!stack.m_41782_()) {
            IronWateringCan.setWaterAmount(stack, 0);
        }
    }

    public boolean m_142522_(ItemStack stack) {
        int waterAmount = IronWateringCan.getWaterAmount(stack);
        return waterAmount > 0 && waterAmount < 1000;
    }

    public int m_142158_(ItemStack stack) {
        int waterAmount = IronWateringCan.getWaterAmount(stack);
        return Math.round((float)waterAmount / 1000.0f * 13.0f);
    }

    public int m_142159_(ItemStack stack) {
        return 0x3366CC;
    }
}

