/*
 * Decompiled with CFR 0.152.
 */
package ru.imaginaerum.wd.server.events;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ru.imaginaerum.wd.common.items.ItemsWD;

@Mod.EventBusSubscriber
public class RobinStickRepair {
    @SubscribeEvent
    public static void onPlayerRightClick(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        ItemStack mainHandItem = player.m_21205_();
        ItemStack offHandItem = player.m_21206_();
        if (RobinStickRepair.isSoulStoneCustomModelData(mainHandItem) && RobinStickRepair.isRobinStick(offHandItem)) {
            RobinStickRepair.setSoulStoneCustomModelData(mainHandItem, 0);
            RobinStickRepair.removeSoulStoneNBT(mainHandItem);
            RobinStickRepair.repairRobinStick(offHandItem);
            event.setCanceled(true);
        } else if (RobinStickRepair.isSoulStoneCustomModelData(offHandItem) && RobinStickRepair.isRobinStick(mainHandItem)) {
            RobinStickRepair.setSoulStoneCustomModelData(offHandItem, 0);
            RobinStickRepair.removeSoulStoneNBT(offHandItem);
            RobinStickRepair.repairRobinStick(mainHandItem);
            event.setCanceled(true);
        }
    }

    private static boolean isSoulStoneCustomModelData(ItemStack itemStack) {
        return itemStack.m_41720_() == ItemsWD.SOUL_STONE.get() && RobinStickRepair.getCustomModelData(itemStack) == 1;
    }

    private static boolean isRobinStick(ItemStack itemStack) {
        return itemStack.m_41720_() == ItemsWD.ROBIN_STICK.get();
    }

    private static int getCustomModelData(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null && tag.m_128425_("CustomModelData", 99)) {
            return tag.m_128451_("CustomModelData");
        }
        return 0;
    }

    private static void setSoulStoneCustomModelData(ItemStack itemStack, int customModelData) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128405_("CustomModelData", customModelData);
    }

    private static void repairRobinStick(ItemStack itemStack) {
        itemStack.m_41721_(0);
    }

    private static void removeSoulStoneNBT(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null) {
            tag.m_128473_("entity_type");
            tag.m_128473_("entity_name");
        }
    }
}

