/*
 * Decompiled with CFR 0.152.
 */
package ru.imaginaerum.wd.client;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import ru.imaginaerum.wd.client.ClientLayerRegistry;
import ru.imaginaerum.wd.common.items.armor.item_render.WDArmorRenderProperties;
import ru.imaginaerum.wd.server.CommonProxy;

public class ClientProxy
extends CommonProxy {
    public static final RandomSource random = RandomSource.m_216327_();
    public static int lastTremorTick = -1;
    public static float[] randomTremorOffsets = new float[3];
    public static List<UUID> blockedEntityRenders = new ArrayList<UUID>();
    public static Map<ClientLevel, List<BlockPos>> blockedParticleLocations = new HashMap<ClientLevel, List<BlockPos>>();
    public static Map<LivingEntity, Vec3[]> darknessTrailPosMap = new HashMap<LivingEntity, Vec3[]>();
    public static Map<LivingEntity, Integer> darknessTrailPointerMap = new HashMap<LivingEntity, Integer>();
    public static int muteNonNukeSoundsFor = 0;
    public static int renderNukeFlashFor = 0;
    public static boolean primordialBossActive = false;
    public static float prevPrimordialBossActiveAmount = 0.0f;
    public static float primordialBossActiveAmount = 0.0f;
    public static ClientLevel lastBossLevel;
    public static float prevNukeFlashAmount;
    public static float nukeFlashAmount;
    public static float prevPossessionStrengthAmount;
    public static float possessionStrengthAmount;
    public static int renderNukeSkyDarkFor;
    public static float masterVolumeNukeModifier;
    public static final Int2ObjectMap<AbstractTickableSoundInstance> ENTITY_SOUND_INSTANCE_MAP;
    public static final Map<BlockEntity, AbstractTickableSoundInstance> BLOCK_ENTITY_SOUND_INSTANCE_MAP;
    private final WDArmorRenderProperties armorProperties = new WDArmorRenderProperties();
    public static boolean spelunkeryTutorialComplete;
    public static boolean hasACSplashText;
    public static CameraType lastPOV;
    public static int shaderLoadAttemptCooldown;
    public static Vec3 lastBiomeLightColor;
    public static float lastBiomeAmbientLightAmount;
    public static Vec3 lastBiomeLightColorPrev;
    public static float lastBiomeAmbientLightAmountPrev;
    public static Map<UUID, Integer> bossBarRenderTypes;
    private static Entity lastCameraEntity;
    public static float acSkyOverrideAmount;
    public static Vec3 acSkyOverrideColor;
    public static boolean disabledBiomeAmbientLightByOtherMod;

    @Override
    public void commonInit() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
    }

    @Override
    public void clientInit() {
        MinecraftForge.EVENT_BUS.register((Object)new ForgeHooksClient.ClientEvents());
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(ClientLayerRegistry::addLayers);
    }

    @Override
    public Player getClientSidePlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    @Override
    public void blockRenderingEntity(UUID id) {
        blockedEntityRenders.add(id);
    }

    @Override
    public void releaseRenderingEntity(UUID id) {
        blockedEntityRenders.remove(id);
    }

    @Override
    public void setVisualFlag(int flag) {
    }

    public float getNukeFlashAmount(float partialTicks) {
        return prevNukeFlashAmount + (nukeFlashAmount - prevNukeFlashAmount) * partialTicks;
    }

    @Override
    public float getPrimordialBossActiveAmount(float partialTicks) {
        return prevPrimordialBossActiveAmount + (primordialBossActiveAmount - prevPrimordialBossActiveAmount) * partialTicks;
    }

    @Override
    public float getPossessionStrengthAmount(float partialTicks) {
        return prevPossessionStrengthAmount + (possessionStrengthAmount - prevPossessionStrengthAmount) * partialTicks;
    }

    @Override
    public boolean checkIfParticleAt(SimpleParticleType simpleParticleType, BlockPos at) {
        List<BlockPos> blocked;
        if (!blockedParticleLocations.containsKey(Minecraft.m_91087_().f_91073_)) {
            blockedParticleLocations.clear();
            blockedParticleLocations.put(Minecraft.m_91087_().f_91073_, new ArrayList());
        }
        if ((blocked = blockedParticleLocations.get(Minecraft.m_91087_().f_91073_)).contains(at)) {
            return false;
        }
        blocked.add(new BlockPos((Vec3i)at));
        return true;
    }

    public void removeParticleAt(BlockPos at) {
        if (!blockedParticleLocations.containsKey(Minecraft.m_91087_().f_91073_)) {
            blockedParticleLocations.clear();
            blockedParticleLocations.put(Minecraft.m_91087_().f_91073_, new ArrayList());
        }
        blockedParticleLocations.get(Minecraft.m_91087_().f_91073_).remove(at);
    }

    @Override
    public boolean isKeyDown(int keyType) {
        if (keyType == -1) {
            return Minecraft.m_91087_().f_91066_.f_92086_.m_90857_() || Minecraft.m_91087_().f_91066_.f_92088_.m_90857_() || Minecraft.m_91087_().f_91066_.f_92085_.m_90857_() || Minecraft.m_91087_().f_91066_.f_92087_.m_90857_() || Minecraft.m_91087_().f_91066_.f_92089_.m_90857_();
        }
        if (keyType == 0) {
            return Minecraft.m_91087_().f_91066_.f_92089_.m_90857_();
        }
        if (keyType == 1) {
            return Minecraft.m_91087_().f_91066_.f_92091_.m_90857_();
        }
        if (keyType == 3) {
            return Minecraft.m_91087_().f_91066_.f_92096_.m_90857_();
        }
        if (keyType == 4) {
            return Minecraft.m_91087_().f_91066_.f_92090_.m_90857_();
        }
        return false;
    }

    @Override
    public Object getArmorProperties() {
        return this.armorProperties;
    }

    @Override
    public float getPartialTicks() {
        return Minecraft.m_91087_().getPartialTick();
    }

    @Override
    public void setSpelunkeryTutorialComplete(boolean completedTutorial) {
        spelunkeryTutorialComplete = completedTutorial;
    }

    @Override
    public boolean isSpelunkeryTutorialComplete() {
        return spelunkeryTutorialComplete;
    }

    @Override
    public void setRenderViewEntity(Player player, Entity entity) {
        if (player == Minecraft.m_91087_().f_91074_ && Minecraft.m_91087_().m_91288_() == Minecraft.m_91087_().f_91074_) {
            lastPOV = Minecraft.m_91087_().f_91066_.m_92176_();
            Minecraft.m_91087_().m_91118_(entity);
            Minecraft.m_91087_().f_91066_.m_92157_(CameraType.FIRST_PERSON);
        }
        if (lastCameraEntity != Minecraft.m_91087_().m_91288_()) {
            Minecraft.m_91087_().f_91060_.m_109818_();
            lastCameraEntity = Minecraft.m_91087_().m_91288_();
        }
    }

    @Override
    public void resetRenderViewEntity(Player player) {
        if (player == Minecraft.m_91087_().f_91074_) {
            Minecraft.m_91087_().f_91073_ = (ClientLevel)Minecraft.m_91087_().f_91074_.m_9236_();
            Minecraft.m_91087_().m_91118_((Entity)Minecraft.m_91087_().f_91074_);
            Minecraft.m_91087_().f_91066_.m_92157_(lastPOV);
        }
        if (lastCameraEntity != Minecraft.m_91087_().m_91288_()) {
            Minecraft.m_91087_().f_91060_.m_109818_();
            lastCameraEntity = Minecraft.m_91087_().m_91288_();
        }
    }

    @Override
    public void clearSoundCacheFor(Entity entity) {
        ENTITY_SOUND_INSTANCE_MAP.remove(entity.m_19879_());
    }

    @Override
    public void clearSoundCacheFor(BlockEntity entity) {
        BLOCK_ENTITY_SOUND_INSTANCE_MAP.remove(entity);
    }

    @Override
    public Vec3 getDarknessTrailPosFor(LivingEntity living, int pointer, float partialTick) {
        Vec3[] trailPositions;
        if (living.m_213877_()) {
            partialTick = 1.0f;
        }
        if ((trailPositions = darknessTrailPosMap.get(living)) == null || !darknessTrailPointerMap.containsKey(living)) {
            return living.m_20182_();
        }
        int trailPointer = darknessTrailPointerMap.get(living);
        int i = trailPointer - pointer & 0x3F;
        int j = trailPointer - pointer - 1 & 0x3F;
        Vec3 d0 = trailPositions[j];
        Vec3 d1 = trailPositions[i].m_82546_(d0);
        return d0.m_82549_(d1.m_82490_((double)partialTick));
    }

    @Override
    public int getPlayerTime() {
        return Minecraft.m_91087_().f_91074_ == null ? 0 : Minecraft.m_91087_().f_91074_.f_19797_;
    }

    @Override
    public boolean isFirstPersonPlayer(Entity entity) {
        return entity.equals((Object)Minecraft.m_91087_().f_91075_) && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_();
    }

    @Override
    public Vec3 getCameraRotation() {
        return Vec3.f_82478_;
    }

    @Override
    public boolean isFarFromCamera(double x, double y, double z) {
        return Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_82531_(x, y, z) >= 256.0;
    }

    static {
        prevNukeFlashAmount = 0.0f;
        nukeFlashAmount = 0.0f;
        prevPossessionStrengthAmount = 0.0f;
        possessionStrengthAmount = 0.0f;
        renderNukeSkyDarkFor = 0;
        masterVolumeNukeModifier = 0.0f;
        ENTITY_SOUND_INSTANCE_MAP = new Int2ObjectOpenHashMap();
        BLOCK_ENTITY_SOUND_INSTANCE_MAP = new HashMap<BlockEntity, AbstractTickableSoundInstance>();
        hasACSplashText = false;
        lastPOV = CameraType.FIRST_PERSON;
        shaderLoadAttemptCooldown = 0;
        lastBiomeLightColor = Vec3.f_82478_;
        lastBiomeAmbientLightAmount = 0.0f;
        lastBiomeLightColorPrev = Vec3.f_82478_;
        lastBiomeAmbientLightAmountPrev = 0.0f;
        bossBarRenderTypes = new HashMap<UUID, Integer>();
        acSkyOverrideColor = Vec3.f_82478_;
        disabledBiomeAmbientLightByOtherMod = false;
    }
}

