/*
 * Decompiled with CFR 0.152.
 */
package ru.imaginaerum.wd.common.blocks.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import ru.imaginaerum.wd.common.blocks.entity.DragoliteCageBlockEntity;
import ru.imaginaerum.wd.common.items.ItemsWD;
import ru.imaginaerum.wd.common.items.custom.SoulStone;
import ru.imaginaerum.wd.common.particles.ModParticles;

public class DragoliteCage
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final IntegerProperty SPARKING = IntegerProperty.m_61631_((String)"sparking", (int)0, (int)5);
    public static final IntegerProperty SOULS = IntegerProperty.m_61631_((String)"souls", (int)0, (int)2);

    public DragoliteCage(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SPARKING, (Comparable)Integer.valueOf(0))).m_61124_((Property)SOULS, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SPARKING, SOULS});
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        LivingEntity livingEntity;
        super.m_141947_(world, pos, state, entity);
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6336_() == MobType.f_21641_) {
            entity.m_6469_(new DamageSource((Holder)world.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268433_)), 8.0f);
        }
    }

    public static void onEntityDeath(LivingEntity entity, DamageSource source) {
        if (source.m_19385_().equals("generic") && entity.m_6336_() == MobType.f_21641_) {
            Level world = entity.m_9236_();
            if (!world.f_46443_ && world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                int xp = 7 + world.f_46441_.m_188503_(4);
                ExperienceOrb.m_147082_((ServerLevel)serverWorld, (Vec3)entity.m_20182_(), (int)xp);
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.m_213897_(state, level, pos, random);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity != null) {
            CompoundTag blockTag = blockEntity.getPersistentData();
            String soulFirst = blockTag.m_128461_("soul_first");
            String soulSecond = blockTag.m_128461_("soul_second");
            if (!soulFirst.isEmpty() && soulFirst.equals(soulSecond) && (Integer)state.m_61143_((Property)SPARKING) > 0) {
                for (int i = 0; i < 1; ++i) {
                    Entity entity;
                    double x = (double)pos.m_123341_() + (random.m_188500_() * 10.0 - 5.0);
                    double y = pos.m_123342_() + (random.m_188503_(11) - 5);
                    double z = (double)pos.m_123343_() + (random.m_188500_() * 10.0 - 5.0);
                    BlockPos spawnPos = new BlockPos((int)x, (int)y, (int)z);
                    EntityType entityType = EntityType.m_20632_((String)soulFirst).orElse(null);
                    if (entityType == null || (entity = entityType.m_20615_((Level)level)) == null) continue;
                    boolean isWaterAnimal = entity instanceof WaterAnimal;
                    if (isWaterAnimal) {
                        if (!level.m_8055_(spawnPos).m_60819_().m_76170_()) continue;
                        this.spawnEntityInWater(level, spawnPos, entity, state, pos, random);
                        continue;
                    }
                    if (!level.m_8055_(spawnPos.m_7495_()).m_280296_()) continue;
                    this.spawnEntityOnLand(level, spawnPos, entity, state, pos, random);
                }
            }
        }
    }

    private void spawnEntityOnLand(ServerLevel level, BlockPos spawnPos, Entity entity, BlockState state, BlockPos blockPos, RandomSource random) {
        int highestY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, spawnPos.m_123341_(), spawnPos.m_123343_());
        BlockPos topPos = new BlockPos(spawnPos.m_123341_(), highestY, spawnPos.m_123343_());
        entity.m_7678_((double)topPos.m_123341_(), (double)topPos.m_123342_(), (double)topPos.m_123343_(), 0.0f, 0.0f);
        if (level.m_8055_(topPos).m_60795_() && level.m_8055_(topPos.m_7495_()).m_280296_()) {
            int currentSparking;
            level.m_7967_(entity);
            if (random.m_188503_(100) < 45 && (currentSparking = ((Integer)state.m_61143_((Property)SPARKING)).intValue()) > 0) {
                level.m_7731_(blockPos, (BlockState)state.m_61124_((Property)SPARKING, (Comparable)Integer.valueOf(currentSparking - 1)), 3);
                level.m_5594_(null, blockPos, SoundEvents.f_12331_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    private void spawnEntityInWater(ServerLevel level, BlockPos spawnPos, Entity entity, BlockState state, BlockPos blockPos, RandomSource random) {
        int currentSparking;
        entity.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, 0.0f, 0.0f);
        level.m_7967_(entity);
        if (random.m_188503_(100) < 45 && (currentSparking = ((Integer)state.m_61143_((Property)SPARKING)).intValue()) > 0) {
            level.m_7731_(blockPos, (BlockState)state.m_61124_((Property)SPARKING, (Comparable)Integer.valueOf(currentSparking - 1)), 3);
            level.m_5594_(null, blockPos, SoundEvents.f_12331_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource source) {
        super.m_214162_(state, level, pos, source);
        int souls = (Integer)state.m_61143_((Property)SOULS);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (state.m_60734_() instanceof DragoliteCage && blockEntity != null) {
            CompoundTag blockTag = blockEntity.m_5995_();
            String soulFirst = blockTag.m_128461_("soul_first");
            String soulSecond = blockTag.m_128461_("soul_second");
            if (souls == 2 && !soulFirst.isEmpty() && !soulSecond.isEmpty() && soulFirst.equals(soulSecond)) {
                if (source.m_188503_(100) == 0) {
                    level.m_6263_((Player)null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12375_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                double d0 = (double)pos.m_123341_() + 0.5 + (0.5 - source.m_188500_());
                double d1 = (double)pos.m_123342_() + 0.3;
                double d2 = (double)pos.m_123343_() + 0.5 + (0.5 - source.m_188500_());
                double d3 = (double)source.m_188501_() * 0.04;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, d0, d1, d2, 0.0, d3, 0.0);
            }
        }
        if ((Integer)state.m_61143_((Property)SPARKING) > 0) {
            if (source.m_188503_(100) == 0) {
                level.m_6263_((Player)null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12375_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            double d0 = (double)pos.m_123341_() + 0.5 + (0.5 - source.m_188500_());
            double d1 = (double)pos.m_123342_() + 1.0;
            double d2 = (double)pos.m_123343_() + 0.5 + (0.5 - source.m_188500_());
            double d3 = (double)source.m_188501_() * 0.04;
            level.m_7106_((ParticleOptions)ModParticles.ROBIN_STAR_PARTICLES_PROJECTILE.get(), d0, d1, d2, 0.0, d3, 0.0);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (player.m_21120_(hand).m_150930_((Item)ItemsWD.SPARKLING_POLLEN.get())) {
            this.handleSparklingPollen(state, level, pos, player, hand);
        }
        if (player.m_21120_(hand).m_41720_() instanceof SoulStone) {
            this.handleSoulStone(state, level, pos, player, hand);
        }
        if (player.m_21120_(hand).m_150930_((Item)ItemsWD.ROBIN_STICK.get())) {
            this.handleRobinStick(state, level, pos, player, hand);
            player.m_6674_(hand);
        }
        level.m_7260_(pos, state, state, 3);
        level.m_6550_(pos, state, state);
        return super.m_6227_(state, level, pos, player, hand, blockHitResult);
    }

    private void handleRobinStick(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) != null) {
            CompoundTag blockTag = blockEntity.getPersistentData();
            String soulFirst = blockTag.m_128461_("soul_first");
            String soulSecond = blockTag.m_128461_("soul_second");
            int currentSouls = (Integer)state.m_61143_((Property)SOULS);
            if (currentSouls == 2) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)SOULS, (Comparable)Integer.valueOf(1)), 3);
                ItemStack soulStoneStack = new ItemStack((ItemLike)ItemsWD.SOUL_STONE.get());
                CompoundTag nbt = soulStoneStack.m_41784_();
                nbt.m_128359_("entity_type", soulSecond);
                String entityName = this.getEntityName(level, soulSecond);
                nbt.m_128359_("entity_name", entityName);
                DragoliteCage.chargeSoulStone(soulStoneStack);
                soulStoneStack.m_41751_(nbt);
                player.m_150109_().m_36054_(soulStoneStack);
                blockTag.m_128473_("soul_second");
                if (blockEntity instanceof DragoliteCageBlockEntity) {
                    DragoliteCageBlockEntity dragoliteCageBlockEntity = (DragoliteCageBlockEntity)blockEntity;
                    dragoliteCageBlockEntity.setSoulSecond("");
                }
                level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else if (currentSouls == 1) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)SOULS, (Comparable)Integer.valueOf(0)), 3);
                ItemStack soulStoneStack = new ItemStack((ItemLike)ItemsWD.SOUL_STONE.get());
                CompoundTag nbt = soulStoneStack.m_41784_();
                nbt.m_128359_("entity_type", soulFirst);
                String entityName = this.getEntityName(level, soulFirst);
                nbt.m_128359_("entity_name", entityName);
                DragoliteCage.chargeSoulStone(soulStoneStack);
                soulStoneStack.m_41751_(nbt);
                player.m_150109_().m_36054_(soulStoneStack);
                blockTag.m_128473_("soul_first");
                if (blockEntity instanceof DragoliteCageBlockEntity) {
                    DragoliteCageBlockEntity dragoliteCageBlockEntity = (DragoliteCageBlockEntity)blockEntity;
                    dragoliteCageBlockEntity.setSoulFirst("");
                }
                level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) != null) {
            CompoundTag blockTag = blockEntity.getPersistentData();
            String soulFirst = blockTag.m_128461_("soul_first");
            String soulSecond = blockTag.m_128461_("soul_second");
            int currentSouls = (Integer)state.m_61143_((Property)SOULS);
            if (currentSouls == 2) {
                DragoliteCageBlockEntity dragoliteCageBlockEntity;
                if (!soulFirst.isEmpty()) {
                    ItemStack soulStoneStackFirst = new ItemStack((ItemLike)ItemsWD.SOUL_STONE.get());
                    CompoundTag nbtFirst = soulStoneStackFirst.m_41784_();
                    nbtFirst.m_128359_("entity_type", soulFirst);
                    String entityNameFirst = this.getEntityName(level, soulFirst);
                    nbtFirst.m_128359_("entity_name", entityNameFirst);
                    DragoliteCage.chargeSoulStone(soulStoneStackFirst);
                    soulStoneStackFirst.m_41751_(nbtFirst);
                    ItemEntity itemEntityFirst = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, soulStoneStackFirst);
                    level.m_7967_((Entity)itemEntityFirst);
                    blockTag.m_128473_("soul_first");
                    if (blockEntity instanceof DragoliteCageBlockEntity) {
                        dragoliteCageBlockEntity = (DragoliteCageBlockEntity)blockEntity;
                        dragoliteCageBlockEntity.setSoulFirst("");
                    }
                }
                if (!soulSecond.isEmpty()) {
                    ItemStack soulStoneStackSecond = new ItemStack((ItemLike)ItemsWD.SOUL_STONE.get());
                    CompoundTag nbtSecond = soulStoneStackSecond.m_41784_();
                    nbtSecond.m_128359_("entity_type", soulSecond);
                    String entityNameSecond = this.getEntityName(level, soulSecond);
                    nbtSecond.m_128359_("entity_name", entityNameSecond);
                    DragoliteCage.chargeSoulStone(soulStoneStackSecond);
                    soulStoneStackSecond.m_41751_(nbtSecond);
                    ItemEntity itemEntitySecond = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, soulStoneStackSecond);
                    level.m_7967_((Entity)itemEntitySecond);
                    blockTag.m_128473_("soul_second");
                    if (blockEntity instanceof DragoliteCageBlockEntity) {
                        dragoliteCageBlockEntity = (DragoliteCageBlockEntity)blockEntity;
                        dragoliteCageBlockEntity.setSoulSecond("");
                    }
                }
                level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else if (currentSouls == 1) {
                if (!soulFirst.isEmpty()) {
                    ItemStack soulStoneStackFirst = new ItemStack((ItemLike)ItemsWD.SOUL_STONE.get());
                    CompoundTag nbtFirst = soulStoneStackFirst.m_41784_();
                    nbtFirst.m_128359_("entity_type", soulFirst);
                    String entityNameFirst = this.getEntityName(level, soulFirst);
                    nbtFirst.m_128359_("entity_name", entityNameFirst);
                    DragoliteCage.chargeSoulStone(soulStoneStackFirst);
                    soulStoneStackFirst.m_41751_(nbtFirst);
                    ItemEntity itemEntityFirst = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, soulStoneStackFirst);
                    level.m_7967_((Entity)itemEntityFirst);
                    blockTag.m_128473_("soul_first");
                    if (blockEntity instanceof DragoliteCageBlockEntity) {
                        DragoliteCageBlockEntity dragoliteCageBlockEntity = (DragoliteCageBlockEntity)blockEntity;
                        dragoliteCageBlockEntity.setSoulFirst("");
                    }
                }
                level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public static void chargeSoulStone(ItemStack stack) {
        stack.m_41784_().m_128379_("Charged", true);
        stack.m_41784_().m_128405_("CustomModelData", 1);
    }

    private String getEntityName(Level level, String entityType) {
        Entity entity;
        EntityType entityTypeObj = EntityType.m_20632_((String)entityType).orElse(null);
        if (entityTypeObj != null && (entity = entityTypeObj.m_20615_(level)) != null) {
            return entity.m_7755_().getString();
        }
        return "Unknown Entity";
    }

    private void handleSparklingPollen(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        int currentSparking;
        if (!level.f_46443_ && (currentSparking = ((Integer)state.m_61143_((Property)SPARKING)).intValue()) < 5) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SPARKING, (Comparable)Integer.valueOf(currentSparking + 1)), 3);
            if (!player.m_7500_()) {
                player.m_21120_(hand).m_41774_(1);
            }
            level.m_5594_(null, pos, SoundEvents.f_12334_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void handleSoulStone(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        int currentSoul;
        SoulStone soulStone = (SoulStone)player.m_21120_(hand).m_41720_();
        if (soulStone.isCharged(player.m_21120_(hand)) && !level.f_46443_ && (currentSoul = ((Integer)state.m_61143_((Property)SOULS)).intValue()) < 2) {
            CompoundTag tag = player.m_21120_(hand).m_41784_();
            String entityType = tag.m_128461_("entity_type");
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SOULS, (Comparable)Integer.valueOf(currentSoul + 1)), 3);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity != null) {
                this.handleSoulStorage(blockEntity, currentSoul, entityType);
            }
            if (!player.m_7500_()) {
                player.m_21120_(hand).m_41774_(1);
            }
            level.m_5594_(null, pos, SoundEvents.f_11859_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void handleSoulStorage(BlockEntity blockEntity, int currentSoul, String entityType) {
        CompoundTag blockTag = blockEntity.getPersistentData();
        if (currentSoul == 0) {
            blockTag.m_128359_("soul_first", entityType);
            if (blockEntity instanceof DragoliteCageBlockEntity) {
                DragoliteCageBlockEntity dragoliteCageBlockEntity = (DragoliteCageBlockEntity)blockEntity;
                dragoliteCageBlockEntity.setSoulFirst(entityType);
            }
        } else if (currentSoul == 1) {
            blockTag.m_128359_("soul_second", entityType);
            if (blockEntity instanceof DragoliteCageBlockEntity) {
                DragoliteCageBlockEntity dragoliteCageBlockEntity = (DragoliteCageBlockEntity)blockEntity;
                dragoliteCageBlockEntity.setSoulSecond(entityType);
            }
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)SPARKING, (Comparable)Integer.valueOf(0))).m_61124_((Property)SOULS, (Comparable)Integer.valueOf(0));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new DragoliteCageBlockEntity(pPos, pState);
    }
}

