/*
 * Decompiled with CFR 0.152.
 */
package ru.imaginaerum.wd.common.blocks.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;
import ru.imaginaerum.wd.common.blocks.custom.BerriesWaffles;

public class InvisibilityJamBlock
extends Block {
    public static final IntegerProperty JAM_NUMBER = IntegerProperty.m_61631_((String)"jam_number", (int)0, (int)7);
    private static final VoxelShape SHAPES_1 = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0);
    private static final VoxelShape SHAPES_SMALL_UP = Block.m_49796_((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape SHAPES_2 = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    private static final VoxelShape SHAPES_3_4 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape SHAPES_5 = Shapes.m_83110_((VoxelShape)SHAPES_SMALL_UP, (VoxelShape)SHAPES_3_4);
    private static final VoxelShape SHAPES_6 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private final RegistryObject<Item> jamItem;

    public InvisibilityJamBlock(BlockBehaviour.Properties pProperties, RegistryObject<Item> jamItem) {
        super(pProperties);
        this.jamItem = jamItem;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)JAM_NUMBER, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{JAM_NUMBER});
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            this.destroyAbove(world, pos);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    private void destroyAbove(Level world, BlockPos pos) {
        BlockPos abovePos = pos.m_7494_();
        BlockState aboveState = world.m_8055_(abovePos);
        if (aboveState.m_60734_() instanceof BerriesWaffles) {
            world.m_46961_(abovePos, true);
            this.destroyAbove(world, abovePos);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    public BlockState m_7417_(BlockState currentState, Direction direction, BlockState adjacentState, LevelAccessor world, BlockPos currentPos, BlockPos adjacentPos) {
        if (!currentState.m_60710_((LevelReader)world, currentPos)) {
            world.m_186460_(currentPos, (Block)this, 1);
        }
        return super.m_7417_(currentState, direction, adjacentState, world, currentPos, adjacentPos);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos position) {
        BlockState blockBelow = world.m_8055_(position.m_7495_());
        if (blockBelow.m_60713_((Block)this)) {
            return (Integer)blockBelow.m_61143_((Property)JAM_NUMBER) == 7;
        }
        return blockBelow.m_60783_((BlockGetter)world, position.m_7495_(), Direction.UP);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemInHand = player.m_21120_(hand);
        int currentStage = (Integer)state.m_61143_((Property)JAM_NUMBER);
        if (player.m_6144_()) {
            if (currentStage > 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)JAM_NUMBER, (Comparable)Integer.valueOf(currentStage - 1)), 3);
                ItemStack itemToGive = new ItemStack((ItemLike)this.jamItem.get());
                if (!player.m_36356_(itemToGive)) {
                    player.m_36176_(itemToGive, false);
                }
                level.m_5594_(player, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 1.0f);
                player.m_6674_(hand);
                return InteractionResult.SUCCESS;
            }
            level.m_7471_(pos, false);
            level.m_5594_(player, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 1.0f);
            ItemStack itemToGive = new ItemStack((ItemLike)this.jamItem.get());
            if (!player.m_36356_(itemToGive)) {
                player.m_36176_(itemToGive, false);
            }
            return InteractionResult.SUCCESS;
        }
        if (!itemInHand.m_41619_() && itemInHand.m_150930_((Item)this.jamItem.get())) {
            if (currentStage < 7) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)JAM_NUMBER, (Comparable)Integer.valueOf(currentStage + 1)), 3);
                level.m_5594_(player, pos, SoundEvents.f_11986_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_7500_()) {
                    itemInHand.m_41774_(1);
                }
                player.m_6674_(hand);
                return InteractionResult.SUCCESS;
            }
        } else if (itemInHand.m_41619_() && player.m_36324_().m_38721_()) {
            if (currentStage > 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)JAM_NUMBER, (Comparable)Integer.valueOf(currentStage - 1)), 3);
            } else if (currentStage == 0) {
                level.m_7471_(pos, false);
            }
            player.m_36324_().m_38707_(12, 0.55f);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 4800, 0));
            level.m_5594_(player, pos, SoundEvents.f_11970_, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_6674_(hand);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collisionContext) {
        int jamNumber = (Integer)state.m_61143_((Property)JAM_NUMBER);
        switch (jamNumber) {
            case 0: {
                return SHAPES_1;
            }
            case 1: {
                return SHAPES_2;
            }
            case 2: 
            case 3: {
                return SHAPES_3_4;
            }
            case 4: {
                return SHAPES_5;
            }
            case 5: 
            case 6: 
            case 7: {
                return SHAPES_6;
            }
        }
        return SHAPES_1;
    }
}

