/*
 * Decompiled with CFR 0.152.
 */
package ru.imaginaerum.wd.common.blocks.custom;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SpatialOrchid
extends Block {
    private static final int TELEPORT_RADIUS = 300;

    public SpatialOrchid(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!level.m_183326_().m_183582_(pos, (Object)this)) {
                level.m_186460_(pos, (Block)this, 6);
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        AABB searchArea = new AABB(pos).m_82400_(1.0);
        List entities = level.m_45976_(Entity.class, searchArea);
        if (!entities.isEmpty()) {
            for (Entity entity : entities) {
                this.teleportEntityRandomly(level, entity);
            }
        }
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    private void teleportEntityRandomly(ServerLevel level, Entity entity) {
        RandomSource random = level.m_213780_();
        int x = entity.m_20183_().m_123341_() + random.m_188503_(600) - 300;
        int z = entity.m_20183_().m_123343_() + random.m_188503_(600) - 300;
        int y = level.m_141928_() - 1;
        BlockPos candidatePos = new BlockPos(x, y, z);
        while (candidatePos.m_123342_() > level.m_141937_()) {
            if (this.isValidTeleportLocation((Level)level, candidatePos)) {
                entity.m_6021_((double)candidatePos.m_123341_() + 0.5, (double)(candidatePos.m_123342_() + 1), (double)candidatePos.m_123343_() + 0.5);
                return;
            }
            candidatePos = candidatePos.m_7495_();
        }
    }

    private boolean isValidTeleportLocation(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_280296_() && level.m_8055_(pos.m_7494_()).m_60795_() && level.m_8055_(pos.m_6630_(2)).m_60795_();
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource source) {
        VoxelShape voxelshape = this.m_5940_(state, (BlockGetter)level, pos, CollisionContext.m_82749_());
        Vec3 vec3 = voxelshape.m_83215_().m_82399_();
        double d0 = (double)pos.m_123341_() + vec3.f_82479_;
        double d1 = (double)pos.m_123343_() + vec3.f_82481_;
        for (int i = 0; i < 3; ++i) {
            if (!source.m_188499_()) continue;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d0 + source.m_188500_() / 5.0, (double)pos.m_123342_() + (0.5 - source.m_188500_()), d1 + source.m_188500_() / 5.0, 0.0, 0.0, 0.0);
        }
    }

    public BlockState m_7417_(BlockState currentBlockState, Direction direction, BlockState neighborBlockState, LevelAccessor world, BlockPos currentPos, BlockPos neighborPos) {
        if (!currentBlockState.m_60710_((LevelReader)world, currentPos)) {
            world.m_186460_(currentPos, (Block)this, 1);
        }
        return super.m_7417_(currentBlockState, direction, neighborBlockState, world, currentPos, neighborPos);
    }

    public boolean m_7898_(BlockState state, LevelReader levelReader, BlockPos blockPos) {
        BlockState belowBlockState = levelReader.m_8055_(blockPos.m_7495_());
        return belowBlockState.m_60713_(Blocks.f_50259_) || belowBlockState.m_60713_(Blocks.f_50443_);
    }
}

