/*
 * Decompiled with CFR 0.152.
 */
package ru.imaginaerum.wd.common.blocks.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;
import ru.imaginaerum.wd.common.blocks.custom.EchotronBlock;
import ru.imaginaerum.wd.common.blocks.entity.EchotronBlockEntity;
import ru.imaginaerum.wd.common.blocks.entity.model.EchotronModel;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public class EchotronRenderer
extends GeoBlockRenderer<EchotronBlockEntity> {
    public EchotronRenderer(BlockEntityRendererProvider.Context context) {
        super((GeoModel)new EchotronModel());
    }

    public void actuallyRender(PoseStack poseStack, EchotronBlockEntity animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        int stage;
        float time;
        super.actuallyRender(poseStack, (BlockEntity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 1.6, -0.01);
        poseStack.m_85841_(0.75f, 0.75f, 0.75f);
        if (animatable.m_58904_() != null) {
            time = (float)animatable.m_58904_().m_46467_() + partialTick;
            stage = (Integer)animatable.m_58900_().m_61143_((Property)EchotronBlock.STAGE);
            float spinZ = time * (float)stage * 3.0f % 360.0f;
            poseStack.m_252781_(Axis.f_252393_.m_252977_(spinZ));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(45.0f));
            poseStack.m_85837_(0.0, -0.1, 0.0);
            Minecraft.m_91087_().m_91291_().m_269128_(Items.f_220224_.m_7968_(), ItemDisplayContext.GROUND, packedLight, packedOverlay, poseStack, bufferSource, animatable.m_58904_(), 0);
        }
        poseStack.m_85849_();
        if (animatable.m_58904_() != null) {
            time = (float)animatable.m_58904_().m_46467_() + partialTick;
            stage = (Integer)animatable.m_58900_().m_61143_((Property)EchotronBlock.STAGE);
            float raysF = Math.max(1.0f, (float)stage * 3.0f / 2.0f);
            int maxRays = (int)Math.ceil(raysF);
            float partialRay = raysF - (float)(maxRays - 1);
            float sphereBase = 0.45f;
            float sphereJitter = 0.25f;
            float pulsationSpeed = 15.0f;
            VertexConsumer vc = bufferSource.m_6299_(RenderType.m_110502_());
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 1.6f, 0.0f);
            Matrix4f matrix = poseStack.m_85850_().m_252922_();
            long baseSeed = animatable.m_58899_().m_121878_();
            for (int i = 0; i < maxRays; ++i) {
                Random rnd = new Random(baseSeed ^ (long)i * -7046029254386353131L);
                double u = rnd.nextDouble();
                double v = rnd.nextDouble();
                double theta = Math.PI * 2 * v + (double)time * 0.02;
                double z = 2.0 * u - 1.0;
                double r = Math.sqrt(Math.max(0.0, 1.0 - z * z));
                float dirX = (float)(r * Math.cos(theta));
                float dirZ = (float)(r * Math.sin(theta));
                float dirY = (float)z;
                float length = sphereBase + sphereJitter * rnd.nextFloat() + 0.08f * (float)Math.sin(time / pulsationSpeed + (float)i);
                float lengthInner = length * (0.45f + 0.2f * rnd.nextFloat());
                float alphaMultiplier = i == maxRays - 1 ? partialRay : 1.0f;
                float x = dirX * length;
                float y = dirY * length;
                float z2 = dirZ * length;
                float xInner = dirX * lengthInner;
                float yInner = dirY * lengthInner;
                float zInner = dirZ * lengthInner;
                int a1 = Math.min(255, (int)(180.0f * alphaMultiplier));
                int a2 = Math.min(255, (int)(90.0f * alphaMultiplier));
                int a3 = Math.min(255, (int)(35.0f * alphaMultiplier));
                vc.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(0, 255, 255, a1).m_5752_();
                vc.m_252986_(matrix, xInner, yInner, zInner).m_6122_(0, 200, 255, a2).m_5752_();
                vc.m_252986_(matrix, x, y, z2).m_6122_(0, 200, 255, a3).m_5752_();
                if (i % 3 != 0) continue;
                float branchLen = length * (0.6f + 0.2f * rnd.nextFloat());
                double branchTheta = theta + (rnd.nextDouble() - 0.5) * 0.6;
                double branchZ = Math.max(-1.0, Math.min(1.0, z + (rnd.nextDouble() - 0.5) * 0.2));
                double branchR = Math.sqrt(Math.max(0.0, 1.0 - branchZ * branchZ));
                float bdx = (float)(branchR * Math.cos(branchTheta));
                float bdz = (float)(branchR * Math.sin(branchTheta));
                float bdy = (float)branchZ;
                float bx = bdx * branchLen;
                float by = bdy * branchLen;
                float bz = bdz * branchLen;
                int ab1 = Math.min(255, (int)(120.0f * alphaMultiplier));
                int ab2 = Math.min(255, (int)(50.0f * alphaMultiplier));
                int ab3 = Math.min(255, (int)(15.0f * alphaMultiplier));
                vc.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(0, 255, 255, ab1).m_5752_();
                vc.m_252986_(matrix, bx * 0.55f, by * 0.55f, bz * 0.55f).m_6122_(0, 200, 255, ab2).m_5752_();
                vc.m_252986_(matrix, bx, by, bz).m_6122_(0, 200, 255, ab3).m_5752_();
            }
            poseStack.m_85849_();
        }
    }
}

