/*
 * Decompiled with CFR 0.152.
 */
package ru.imaginaerum.wd.common.entities.goals_entity_mixin;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import ru.imaginaerum.wd.common.blocks.BlocksWD;
import ru.imaginaerum.wd.common.blocks.custom.RottenPie;
import ru.imaginaerum.wd.common.blocks.custom.RottenPieCage;

public class ZombieEatPieGoal
extends MoveToBlockGoal {
    private final Zombie zombie;
    private int eatCooldown = 0;
    private int breakProgress = 0;
    private static final int BREAK_THRESHOLD = 320;

    public ZombieEatPieGoal(Zombie zombie, double speed, int searchRange) {
        super((PathfinderMob)zombie, speed, searchRange, 6);
        this.zombie = zombie;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!this.zombie.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            return false;
        }
        return this.m_25626_();
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.eatCooldown > 0) {
            --this.eatCooldown;
            return;
        }
        BlockPos pos = this.f_25602_;
        Level level = this.zombie.m_9236_();
        double dx = this.zombie.m_20185_() - ((double)pos.m_123341_() + 0.5);
        double dz = this.zombie.m_20189_() - ((double)pos.m_123343_() + 0.5);
        double distanceSqXZ = dx * dx + dz * dz;
        if (!this.m_25625_() && distanceSqXZ >= 2.0) {
            return;
        }
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof RottenPieCage) {
            ++this.breakProgress;
            if (this.breakProgress % 10 == 0) {
                level.m_5594_(null, pos, SoundEvents.f_12599_, SoundSource.HOSTILE, 0.5f, 0.8f + level.f_46441_.m_188501_() * 0.2f);
            }
            if (this.breakProgress >= 320) {
                level.m_7731_(pos, (BlockState)((Block)BlocksWD.ROTTEN_PIE.get()).m_49966_().m_61124_((Property)RottenPie.STAGE, (Comparable)Integer.valueOf(0)), 3);
                level.m_5594_(null, pos, SoundEvents.f_12601_, SoundSource.HOSTILE, 1.0f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
                this.zombie.m_21573_().m_26573_();
                this.eatCooldown = 25;
                this.breakProgress = 0;
                return;
            }
            return;
        }
        if (state.m_60734_() instanceof RottenPie) {
            int stage = (Integer)state.m_61143_((Property)RottenPie.STAGE);
            if (stage < 3) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)RottenPie.STAGE, (Comparable)Integer.valueOf(stage + 1)), 3);
            } else {
                level.m_7471_(pos, false);
            }
            level.m_5594_(null, pos, SoundEvents.f_11912_, SoundSource.HOSTILE, 0.7f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
            if (level.f_46441_.m_188501_() < 0.7f) {
                this.zombie.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 0));
            }
            this.zombie.m_21573_().m_26573_();
            this.eatCooldown = 60;
        }
    }

    protected boolean m_6465_(LevelReader levelReader, BlockPos blockPos) {
        BlockState state = levelReader.m_8055_(blockPos);
        if (!(state.m_60734_() instanceof RottenPie) && !(state.m_60734_() instanceof RottenPieCage)) {
            return false;
        }
        int zombieY = this.zombie.m_20183_().m_123342_();
        int targetY = blockPos.m_123342_();
        return targetY <= zombieY + 1;
    }
}

