/*
 * Decompiled with CFR 0.152.
 */
package ru.imaginaerum.wd.common.events;

import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ru.imaginaerum.wd.common.blocks.BlocksWD;
import ru.imaginaerum.wd.common.blocks.custom.BrightPepperSeeds;
import ru.imaginaerum.wd.common.blocks.custom.DragolitBlock;
import ru.imaginaerum.wd.common.blocks.custom.DragolitGrid;
import ru.imaginaerum.wd.common.blocks.custom.DragoliteCage;
import ru.imaginaerum.wd.common.blocks.custom.MagicSoilFarmland;
import ru.imaginaerum.wd.common.blocks.registry_blocks_plaints.MagicSoilFarmlandData;
import ru.imaginaerum.wd.common.blocks.registry_blocks_plaints.PepperRegistry;

@Mod.EventBusSubscriber(modid="wd", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventBusEvents {
    @SubscribeEvent
    public static void onLevelTickFarmland(TickEvent.LevelTickEvent event) {
        long timeOfDay;
        if (event.phase == TickEvent.Phase.END && !event.level.f_46443_ && (timeOfDay = event.level.m_46468_() % 24000L) == 0L) {
            ForgeEventBusEvents.dryAllSoil((ServerLevel)event.level);
            ForgeEventBusEvents.upgradeStagePepper((ServerLevel)event.level);
        }
    }

    private static void upgradeStagePepper(ServerLevel level) {
        PepperRegistry data = PepperRegistry.get(level);
        for (BlockPos pos : new HashSet<BlockPos>(data.getPepperBlocks())) {
            if (!level.m_46805_(pos)) continue;
            BlockState state = level.m_8055_(pos);
            if (state.m_60713_((Block)BlocksWD.BRIGHT_PEPPER_SEEDS.get())) {
                int currentStage = (Integer)state.m_61143_((Property)BrightPepperSeeds.STAGE);
                int MAX_STAGE = 12;
                if (currentStage >= 12) continue;
                int nextStage = currentStage + 1;
                BlockState newState = (BlockState)state.m_61124_((Property)BrightPepperSeeds.STAGE, (Comparable)Integer.valueOf(nextStage));
                level.m_7731_(pos, newState, 2);
                continue;
            }
            data.remove(pos);
        }
    }

    private static void dryAllSoil(ServerLevel level) {
        MagicSoilFarmlandData data = MagicSoilFarmlandData.get(level);
        for (BlockPos pos : new HashSet<BlockPos>(data.getFarmlands())) {
            if (!level.m_46805_(pos)) continue;
            BlockState state = level.m_8055_(pos);
            if (state.m_60713_((Block)BlocksWD.MAGIC_SOIL_FARMLAND.get())) {
                if (((Boolean)state.m_61143_((Property)MagicSoilFarmland.MOIST)).booleanValue()) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)MagicSoilFarmland.MOIST, (Comparable)Boolean.valueOf(false)), 3);
                    continue;
                }
                level.m_7731_(pos, ((Block)BlocksWD.MAGIC_SOIL.get()).m_49966_(), 3);
                data.remove(pos);
                continue;
            }
            data.remove(pos);
        }
    }

    @SubscribeEvent
    public static void tickMoistSoil(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (ServerLevel level : event.getServer().m_129785_()) {
            if (!level.m_46471_()) continue;
            MagicSoilFarmlandData data = MagicSoilFarmlandData.get(level);
            for (BlockPos pos : new HashSet<BlockPos>(data.getFarmlands())) {
                BlockState state;
                if (!level.m_46805_(pos) || !(state = level.m_8055_(pos)).m_60713_((Block)BlocksWD.MAGIC_SOIL_FARMLAND.get()) || ((Boolean)state.m_61143_((Property)MagicSoilFarmland.MOIST)).booleanValue()) continue;
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)MagicSoilFarmland.MOIST, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        DragolitBlock.onEntityDeath(event.getEntity(), event.getSource());
        DragolitGrid.onEntityDeath(event.getEntity(), event.getSource());
        DragoliteCage.onEntityDeath(event.getEntity(), event.getSource());
    }
}

