/*
 * Decompiled with CFR 0.152.
 */
package ru.imaginaerum.wd.common.items.custom;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;

public class ModElytra
extends ElytraItem {
    protected final ArmorItem.Type type;
    private final int defense;
    private final float toughness;
    protected final float knockbackResistance;
    protected final ArmorMaterial material;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    private static final UUID[] ARMOR_MODIFIER_UUID_PER_TYPE = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    public static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior(){

        protected ItemStack m_7498_(BlockSource p_40408_, ItemStack p_40409_) {
            return ArmorItem.m_40398_((BlockSource)p_40408_, (ItemStack)p_40409_) ? p_40409_ : super.m_7498_(p_40408_, p_40409_);
        }
    };

    public ModElytra(ArmorMaterial p_40386_, ArmorItem.Type p_266831_, Item.Properties p_40388_) {
        super(p_40388_.m_41499_(p_40386_.m_266425_(p_266831_)));
        this.material = p_40386_;
        this.type = p_266831_;
        this.defense = p_40386_.m_7366_(p_266831_);
        this.toughness = p_40386_.m_6651_();
        this.knockbackResistance = p_40386_.m_6649_();
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)DISPENSE_ITEM_BEHAVIOR);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = ARMOR_MODIFIER_UUID_PER_TYPE[p_266831_.ordinal()];
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)this.defense, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor toughness", (double)this.toughness, AttributeModifier.Operation.ADDITION));
        if (this.knockbackResistance > 0.0f) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", (double)this.knockbackResistance, AttributeModifier.Operation.ADDITION));
        }
        this.defaultModifiers = builder.build();
    }

    public int m_6473_() {
        return this.material.m_6646_();
    }

    public ArmorMaterial getMaterial() {
        return this.material;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot p_40390_) {
        return p_40390_ == this.type.m_266308_() ? this.defaultModifiers : super.m_7167_(p_40390_);
    }

    public boolean m_6832_(ItemStack p_40392_, ItemStack p_40393_) {
        return this.material.m_6230_().test(p_40393_) || super.m_6832_(p_40392_, p_40393_);
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_40395_, Player p_40396_, InteractionHand p_40397_) {
        ItemStack itemstack = p_40396_.m_21120_(p_40397_);
        EquipmentSlot equipmentslot = Mob.m_147233_((ItemStack)itemstack);
        ItemStack itemstack1 = p_40396_.m_6844_(equipmentslot);
        if (itemstack1.m_41619_()) {
            p_40396_.m_8061_(equipmentslot, itemstack.m_41777_());
            if (!p_40395_.m_5776_()) {
                p_40396_.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
            itemstack.m_41764_(0);
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)p_40395_.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return ModElytra.isUseable(stack);
    }

    public static boolean isUseable(ItemStack stack) {
        return stack.m_41773_() < stack.m_41776_() - 1;
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        if (!entity.m_9236_().f_46443_ && (flightTicks + 1) % 25 == 0) {
            stack.m_41622_(1, entity, e -> e.m_21166_(EquipmentSlot.CHEST));
        }
        return true;
    }

    @Nullable
    public SoundEvent m_150681_() {
        return this.getMaterial().m_7344_();
    }

    public EquipmentSlot m_40402_() {
        return EquipmentSlot.CHEST;
    }
}

