/*
 * Decompiled with CFR 0.152.
 */
package ru.imaginaerum.wd.common.items.custom;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import ru.imaginaerum.wd.common.blocks.BlocksWD;
import ru.imaginaerum.wd.common.blocks.custom.RoseMurderer;
import ru.imaginaerum.wd.common.items.ItemsWD;

public class SoulStone
extends Item {
    private static final String ENTITY_TYPE_TAG = "entity_type";
    private static final String ENTITY_NAME_TAG = "entity_name";

    public SoulStone(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            components.add((Component)Component.m_237115_((String)"wd.press_shift2").m_130940_(ChatFormatting.DARK_GRAY));
            components.add((Component)Component.m_237115_((String)"wd.soul_stone_deactive").m_130940_(ChatFormatting.DARK_PURPLE));
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128441_(ENTITY_TYPE_TAG)) {
                String entityType = tag.m_128461_(ENTITY_TYPE_TAG);
                components.add((Component)Component.m_237110_((String)"wd.entity_type", (Object[])new Object[]{entityType}).m_130940_(ChatFormatting.GOLD));
            } else {
                components.add((Component)Component.m_237115_((String)"wd.entity_type_not_set").m_130940_(ChatFormatting.RED));
            }
            if (tag.m_128441_(ENTITY_NAME_TAG)) {
                String entityName = tag.m_128461_(ENTITY_NAME_TAG);
                components.add((Component)Component.m_237110_((String)"wd.entity_name", (Object[])new Object[]{entityName}).m_130940_(ChatFormatting.GREEN));
            } else {
                components.add((Component)Component.m_237115_((String)"wd.entity_name_not_set").m_130940_(ChatFormatting.RED));
            }
        } else {
            components.add((Component)Component.m_237115_((String)"wd.press_shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
        super.m_7373_(stack, level, components, flag);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        ItemStack stack = context.m_43722_();
        Player entity = context.m_43723_();
        Player player = context.m_43723_();
        if (SoulStone.chargeSoulStone((LevelAccessor)level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), (Entity)entity, stack)) {
            return InteractionResult.SUCCESS;
        }
        if (SoulStone.releaseSoulStone(level, pos, stack, player)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean isCharged(ItemStack stack) {
        return stack.m_41784_().m_128471_("Charged");
    }

    public static void charged(ItemStack stack) {
        stack.m_41784_().m_128379_("Charged", true);
        stack.m_41784_().m_128405_("CustomModelData", 1);
    }

    public static void discharged(ItemStack stack, Player player) {
        stack.m_41784_().m_128379_("Charged", false);
        stack.m_41784_().m_128405_("CustomModelData", 0);
    }

    public static boolean chargeSoulStone(LevelAccessor world, int x, int y, int z, Entity entity, ItemStack stack) {
        if (entity == null || !(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity _livEnt = (LivingEntity)entity;
        ItemStack mainHandItem = _livEnt.m_21205_();
        BlockState blockState = world.m_8055_(new BlockPos(x, y, z));
        if (blockState.m_60734_() == BlocksWD.ROSE_OF_THE_MURDERER.get() && ((Boolean)blockState.m_61143_((Property)RoseMurderer.IS_SOUL)).booleanValue() && mainHandItem.m_41720_() == ItemsWD.SOUL_STONE.get()) {
            SoulStone.charged(stack);
            String entityType = SoulStone.getEntityTag(world, new BlockPos(x, y, z), ENTITY_TYPE_TAG);
            String entityName = SoulStone.getEntityTag(world, new BlockPos(x, y, z), ENTITY_NAME_TAG);
            CompoundTag tag = mainHandItem.m_41784_();
            tag.m_128359_(ENTITY_TYPE_TAG, entityType);
            tag.m_128359_(ENTITY_NAME_TAG, entityName);
            BlockPos _bp = new BlockPos(x, y, z);
            BlockState _bs = world.m_8055_(_bp);
            if (((Boolean)_bs.m_61143_((Property)RoseMurderer.IS_SOUL)).booleanValue()) {
                _bs = (BlockState)_bs.m_61124_((Property)RoseMurderer.IS_SOUL, (Comparable)Boolean.valueOf(false));
                world.m_7731_(_bp, _bs, 3);
            }
            if (_livEnt instanceof Player) {
                Player _player = (Player)_livEnt;
                _player.m_21008_(InteractionHand.MAIN_HAND, mainHandItem);
                _player.m_150109_().m_6596_();
            }
            return true;
        }
        return false;
    }

    public static boolean releaseSoulStone(Level world, BlockPos pos, ItemStack stack, Player player) {
        Entity entityToSpawn;
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(ENTITY_TYPE_TAG) || !tag.m_128441_(ENTITY_NAME_TAG)) {
            return false;
        }
        String entityType = tag.m_128461_(ENTITY_TYPE_TAG);
        String entityName = tag.m_128461_(ENTITY_NAME_TAG);
        EntityType entityTypeObj = EntityType.m_20632_((String)entityType).orElse(null);
        if (entityTypeObj != null && (entityToSpawn = entityTypeObj.m_20615_(world)) != null) {
            BlockPos spawnPos = SoulStone.getSpawnPositionForBlock(world, pos, player);
            entityToSpawn.m_6034_((double)spawnPos.m_123341_(), (double)(spawnPos.m_123342_() + 1), (double)spawnPos.m_123343_());
            world.m_7967_(entityToSpawn);
        }
        tag.m_128473_(ENTITY_TYPE_TAG);
        tag.m_128473_(ENTITY_NAME_TAG);
        SoulStone.discharged(stack, null);
        return true;
    }

    private static BlockPos getSpawnPositionForBlock(Level world, BlockPos pos, Player player) {
        BlockPos clickedPos = player.m_20183_();
        BlockPos spawnPos = pos;
        if (clickedPos.m_123341_() > pos.m_123341_()) {
            spawnPos = pos.m_7918_(1, 0, 0);
        } else if (clickedPos.m_123341_() < pos.m_123341_()) {
            spawnPos = pos.m_7918_(-1, 0, 0);
        } else if (clickedPos.m_123343_() > pos.m_123343_()) {
            spawnPos = pos.m_7918_(0, 0, 1);
        } else if (clickedPos.m_123343_() < pos.m_123343_()) {
            spawnPos = pos.m_7918_(0, 0, -1);
        } else if (clickedPos.m_123342_() > pos.m_123342_()) {
            spawnPos = pos.m_7918_(0, 1, 0);
        } else if (clickedPos.m_123342_() < pos.m_123342_()) {
            spawnPos = pos.m_7918_(0, -1, 0);
        }
        while (!world.m_46859_(spawnPos)) {
            spawnPos = spawnPos.m_7494_();
        }
        return spawnPos;
    }

    private static String getEntityTag(LevelAccessor world, BlockPos pos, String tag) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity != null) {
            CompoundTag persistentData = blockEntity.getPersistentData();
            if (persistentData.m_128441_(tag)) {
                return persistentData.m_128461_(tag);
            }
            System.out.println("Tag not found: " + tag);
            return "";
        }
        System.out.println("BlockEntity not found at " + String.valueOf(pos));
        return "";
    }
}

