/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationFactory;
import io.github.Memoires.trbeyond.ability.battlewill.utility.TRBeyondSkills;
import io.github.Memoires.trbeyond.commands.ClearDungeonCommand;
import io.github.Memoires.trbeyond.commands.DungeonStatsCommand;
import io.github.Memoires.trbeyond.commands.SummonEliteCommand;
import io.github.Memoires.trbeyond.config.ServerConfig;
import io.github.Memoires.trbeyond.data.BeyondBlockStateProvider;
import io.github.Memoires.trbeyond.data.BeyondBlockTagProvider;
import io.github.Memoires.trbeyond.data.BeyondEntityEPProvider;
import io.github.Memoires.trbeyond.data.BeyondEntityTypeTagProvider;
import io.github.Memoires.trbeyond.data.BeyondGearEPProvider;
import io.github.Memoires.trbeyond.data.BeyondItemModelProvider;
import io.github.Memoires.trbeyond.data.BeyondLanguageProvider;
import io.github.Memoires.trbeyond.handlers.CapabilityHandler;
import io.github.Memoires.trbeyond.network.BeyondNetwork;
import io.github.Memoires.trbeyond.registry.BeyondRegistry;
import io.github.Memoires.trbeyond.util.BeyondItemProperties;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;
import software.bernie.geckolib3.GeckoLib;

@Mod(value="trbeyond")
public class TRBeyond {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String MODID = "trbeyond";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("trbeyond", "trbeyond"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public TRBeyond() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        TRBeyondSkills.register(modEventBus);
        BeyondRegistry.register(modEventBus);
        BeyondNetwork.register();
        modEventBus.addListener(CapabilityHandler::registerCapabilities);
        modEventBus.addListener(BeyondItemProperties::addItemProperties);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::generateData);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::onRegisterCommands);
        GeckoLib.initialize();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SPEC, "tensura-dungeon+-server-config.toml");
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        ClearDungeonCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        DungeonStatsCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        SummonEliteCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        LOGGER.info("DIRT BLOCK >> {}", (Object)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50493_));
    }

    private void generateData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper efh = event.getExistingFileHelper();
        gen.m_236039_(event.includeClient(), (DataProvider)new BeyondEntityEPProvider(event));
        gen.m_236039_(event.includeClient(), (DataProvider)new BeyondEntityTypeTagProvider(event));
        gen.m_236039_(event.includeClient(), (DataProvider)new BeyondBlockTagProvider(event));
        gen.m_236039_(event.includeServer(), (DataProvider)new BeyondBlockStateProvider(gen, efh));
        gen.m_236039_(event.includeClient(), (DataProvider)new BeyondLanguageProvider(event));
        gen.m_236039_(event.includeClient(), (DataProvider)new BeyondItemModelProvider(event));
        gen.m_236039_(event.includeClient(), (DataProvider)new BeyondGearEPProvider(event));
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO FROM SERVER STARTING");
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    @Mod.EventBusSubscriber(modid="trbeyond", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class playerAnimationsHandler {
        @SubscribeEvent
        public static void registerPlayerAnimationStuff(FMLClientSetupEvent event) {
            PlayerAnimationFactory.ANIMATION_DATA_FACTORY.registerFactory(new ResourceLocation(TRBeyond.MODID, "animation"), 42, playerAnimationsHandler::registerPlayerAnimation);
        }

        private static IAnimation registerPlayerAnimation(AbstractClientPlayer player) {
            return new ModifierLayer();
        }
    }
}

