/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.ability.battlewill.utility;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.battlewill.Battewill;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.Nullable;

public class SkyWalkingArt
extends Battewill {
    private static final Set<UUID> TOGGLED_PLAYERS = new HashSet<UUID>();
    private static final Map<UUID, Double> SKY_WALKING_HEIGHT = new HashMap<UUID, Double>();
    private static final Map<UUID, Boolean> LAST_SNEAK_STATE = new HashMap<UUID, Boolean>();

    public double learningCost() {
        return 150.0;
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        return SkillUtils.isSkillMastered((LivingEntity)entity, (ManasSkill)((ManasSkill)ExtraSkills.WIND_DOMINATION.get()));
    }

    @Nullable
    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trbeyond", "textures/battlewill/sky_walk.png");
    }

    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 100.0;
    }

    public double auraCost(LivingEntity entity, ManasSkillInstance instance) {
        return 5.0;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (entity.m_21023_((MobEffect)TensuraMobEffects.MAGIC_INTERFERENCE.get())) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.magic_interference").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
        } else {
            UUID entityId = entity.m_20148_();
            if (TOGGLED_PLAYERS.contains(entityId)) {
                this.disableSkyWalking(entityId, entity);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237113_((String)"Sky Walking: OFF").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                }
            } else {
                this.enableSkyWalking(entityId, entity);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237113_((String)"Sky Walking: ON").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                }
            }
        }
    }

    private void enableSkyWalking(UUID entityId, LivingEntity entity) {
        TOGGLED_PLAYERS.add(entityId);
        SKY_WALKING_HEIGHT.put(entityId, entity.m_20186_());
        if (entity instanceof Player) {
            Player player = (Player)entity;
            LAST_SNEAK_STATE.put(entityId, player.m_6144_());
        }
    }

    private void disableSkyWalking(UUID entityId, LivingEntity entity) {
        TOGGLED_PLAYERS.remove(entityId);
        SKY_WALKING_HEIGHT.remove(entityId);
        LAST_SNEAK_STATE.remove(entityId);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<UUID> toggledIterator = TOGGLED_PLAYERS.iterator();
        while (toggledIterator.hasNext()) {
            Double currentHeight;
            ServerLevel level;
            UUID playerId = toggledIterator.next();
            Player player = null;
            Iterator iterator = event.getServer().m_129785_().iterator();
            while (iterator.hasNext() && (player = (level = (ServerLevel)iterator.next()).m_46003_(playerId)) == null) {
            }
            if (player == null) {
                SKY_WALKING_HEIGHT.remove(playerId);
                LAST_SNEAK_STATE.remove(playerId);
                toggledIterator.remove();
                continue;
            }
            boolean currentlySneak = player.m_6144_();
            Boolean lastSneak = LAST_SNEAK_STATE.get(playerId);
            if (currentlySneak && (lastSneak == null || !lastSneak.booleanValue()) && (currentHeight = SKY_WALKING_HEIGHT.get(playerId)) != null) {
                SKY_WALKING_HEIGHT.put(playerId, currentHeight - 2.0);
                player.m_5661_((Component)Component.m_237113_((String)"Platform lowered!").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), true);
            }
            LAST_SNEAK_STATE.put(playerId, currentlySneak);
        }
    }

    public static boolean isSkyWalkingActive(UUID playerId) {
        return TOGGLED_PLAYERS.contains(playerId);
    }

    public static double getSkyWalkingHeight(UUID playerId) {
        return SKY_WALKING_HEIGHT.getOrDefault(playerId, 0.0);
    }

    public static void updateSkyWalkingHeight(UUID playerId, double newHeight) {
        if (TOGGLED_PLAYERS.contains(playerId)) {
            SKY_WALKING_HEIGHT.put(playerId, newHeight);
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register(SkyWalkingArt.class);
    }
}

