/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.block;

import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import io.github.Memoires.trbeyond.block.ShrineBlock;
import io.github.Memoires.trbeyond.block.entity.DungeonChestBlockEntity;
import io.github.Memoires.trbeyond.block.entity.GoldChestBlockEntity;
import io.github.Memoires.trbeyond.block.entity.SilverChestBlockEntity;
import io.github.Memoires.trbeyond.config.ServerConfig;
import io.github.Memoires.trbeyond.entity.misc.MimicChestEntity;
import io.github.Memoires.trbeyond.entity.misc.PrimedDungeonChestEntity;
import io.github.Memoires.trbeyond.network.worldgen.DungeonSaveData;
import io.github.Memoires.trbeyond.registry.entities.BeyondEntities;
import io.github.Memoires.trbeyond.util.BeyondDamageSources;
import io.github.Memoires.trbeyond.util.TaskScheduler;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class DungeonChestBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
Fallable {
    public static final EnumProperty<ChestType> TYPE = BlockStateProperties.f_61392_;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected final Supplier<BlockEntityType<? extends DungeonChestBlockEntity>> blockEntityType;
    private final DungeonChestType type;

    public DungeonChestBlock(BlockBehaviour.Properties properties, Supplier<BlockEntityType<? extends DungeonChestBlockEntity>> blockEntityType, DungeonChestType type) {
        super(properties);
        this.blockEntityType = blockEntityType;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)ChestType.LEFT)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
        this.type = type;
    }

    public static DoubleBlockCombiner.BlockType getBlockType(BlockState blockState) {
        ChestType chesttype = (ChestType)blockState.m_61143_(TYPE);
        return chesttype == ChestType.RIGHT ? DoubleBlockCombiner.BlockType.FIRST : DoubleBlockCombiner.BlockType.SECOND;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Deprecated
    public BlockState m_7417_(BlockState state, Direction direction, BlockState facingState, LevelAccessor levelAccessor, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        if (facingState.m_60713_((Block)this) && direction.m_122434_().m_122479_()) {
            ChestType chesttype = (ChestType)facingState.m_61143_(TYPE);
            if (state.m_61143_(TYPE) == ChestType.SINGLE && chesttype != ChestType.SINGLE && state.m_61143_((Property)FACING) == facingState.m_61143_((Property)FACING) && DungeonChestBlock.getConnectedDirection(facingState) == direction.m_122424_()) {
                return (BlockState)state.m_61124_(TYPE, (Comparable)chesttype.m_61486_());
            }
        } else if (DungeonChestBlock.getConnectedDirection(state) == direction) {
            return (BlockState)state.m_61124_(TYPE, (Comparable)ChestType.SINGLE);
        }
        return super.m_7417_(state, direction, facingState, levelAccessor, currentPos, facingPos);
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext context) {
        return switch (DungeonChestBlock.getConnectedDirection(blockState)) {
            default -> Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)15.0);
            case Direction.SOUTH -> Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)16.0);
            case Direction.WEST -> Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
            case Direction.EAST -> Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);
        };
    }

    public static Direction getConnectedDirection(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return state.m_61143_(TYPE) == ChestType.LEFT ? direction.m_122427_() : direction.m_122428_();
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        Level level = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        Direction direction = pContext.m_8125_().m_122424_();
        BlockPos other = blockpos.m_121945_(direction.m_122427_());
        if (!level.m_6857_().m_61937_(other) || !level.m_8055_(other).m_60629_(pContext)) {
            return null;
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_(TYPE, (Comparable)ChestType.LEFT)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(pContext.m_43725_().m_6425_(blockpos).m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof DungeonChestBlockEntity) {
            DungeonChestBlockEntity entity = (DungeonChestBlockEntity)blockEntity;
            entity.wasPlaced(livingEntity, itemStack);
            if (itemStack.m_41788_()) {
                entity.m_58638_(itemStack.m_41786_());
            }
        }
        if (pLevel.m_5776_()) {
            return;
        }
        BlockPos blockpos = pPos.m_121945_(DungeonChestBlock.getConnectedDirection(pState));
        pLevel.m_7731_(blockpos, (BlockState)((BlockState)pState.m_61124_(TYPE, (Comparable)((ChestType)pState.m_61143_(TYPE)).m_61486_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(pLevel.m_6425_(blockpos).m_192917_((Fluid)Fluids.f_76193_))), 3);
        pLevel.m_6289_(pPos, Blocks.f_50016_);
        pState.m_60701_((LevelAccessor)pLevel, pPos, 3);
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (!blockState.m_60713_(newState.m_60734_())) {
            BlockEntity blockentity = level.m_7702_(blockPos);
            if (blockentity instanceof Container) {
                Containers.m_19002_((Level)level, (BlockPos)blockPos, (Container)((Container)blockentity));
                level.m_46717_(blockPos, (Block)this);
            }
            super.m_6810_(blockState, level, blockPos, newState, isMoving);
        }
    }

    public void m_48792_(Level pLevel, BlockPos pPos, BlockState pState, BlockState pReplaceableState, FallingBlockEntity pFallingBlock) {
        if (pLevel.m_5776_()) {
            return;
        }
        BlockPos blockpos = pPos.m_121945_(DungeonChestBlock.getConnectedDirection(pState));
        pLevel.m_7731_(blockpos, (BlockState)((BlockState)pState.m_61124_(TYPE, (Comparable)((ChestType)pState.m_61143_(TYPE)).m_61486_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(pLevel.m_6425_(blockpos).m_192917_((Fluid)Fluids.f_76193_))), 3);
        pLevel.m_6289_(pPos, Blocks.f_50016_);
        pState.m_60701_((LevelAccessor)pLevel, pPos, 3);
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        super.m_5707_(pLevel, pPos, pState, pPlayer);
        if (!pLevel.m_5776_()) {
            BlockPos blockpos = pPos.m_121945_(DungeonChestBlock.getConnectedDirection(pState));
            pLevel.m_46953_(blockpos, false, (Entity)pPlayer);
        }
    }

    public InteractionResult m_6227_(BlockState blockState, Level pLevel, BlockPos pPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        switch (this.getType()) {
            case DEFAULT: {
                ServerPlayer serverPlayer;
                MinecraftServer server;
                boolean noLock;
                BlockPos shrinePos;
                Block block;
                DungeonChestBlockEntity challengeChest;
                BlockEntity blockEntity;
                long packedTime = System.currentTimeMillis() / 1000L / 60L;
                MenuProvider menuProvider = this.m_7246_(blockState, pLevel, pPos);
                if (menuProvider == null || !((blockEntity = pLevel.m_7702_(pPos)) instanceof DungeonChestBlockEntity)) break;
                DungeonChestBlockEntity chest = (DungeonChestBlockEntity)blockEntity;
                BlockEntity blockEntity2 = pLevel.m_7702_(pPos.m_121945_(DungeonChestBlock.getConnectedDirection(blockState)));
                DungeonChestBlockEntity dungeonChestBlockEntity = chest.getPersistentData().m_128441_("challengeChest") ? chest : (challengeChest = blockEntity2 != null && blockEntity2.getPersistentData().m_128441_("challengeChest") ? blockEntity2 : null);
                if (challengeChest != null && challengeChest.getPersistentData().m_128441_("shrinePos") && (block = pLevel.m_8055_(shrinePos = BlockPos.m_122022_((long)challengeChest.getPersistentData().m_128454_("shrinePos"))).m_60734_()) instanceof ShrineBlock) {
                    ShrineBlock shrine = (ShrineBlock)block;
                    challengeChest.getPersistentData().m_128473_("challengeChest");
                    if (challengeChest.getPersistentData().m_128441_("incorrectChest")) {
                        shrine.pickChestsWrongChest(pLevel, shrinePos);
                    } else {
                        shrine.pickChestsCorrectChest();
                    }
                }
                if (blockEntity2 == null) {
                    return InteractionResult.CONSUME;
                }
                boolean bl = noLock = chest.getPersistentData().m_128441_("noLock") || blockEntity2.getPersistentData().m_128441_("noLock");
                if (((Boolean)ServerConfig.INSTANCE.dungeonConfig.chestLock.get()).booleanValue() && (!DungeonSaveData.getOverworld(pLevel).canOpenChest(player, pPos, packedTime) || !DungeonSaveData.getOverworld(pLevel).canOpenChest(player, pPos.m_121945_(DungeonChestBlock.getConnectedDirection(blockState)), packedTime) && !noLock)) {
                    return InteractionResult.CONSUME;
                }
                if (!noLock) {
                    BlockEntity i2;
                    DungeonSaveData.getOverworld(pLevel).setChestCooldown(player, pPos, packedTime);
                    CompoundTag tag = chest.getPersistentData();
                    int openedTime = tag.m_128441_("openedTime") ? tag.m_128451_("openedTime") : -((Integer)ServerConfig.INSTANCE.dungeonConfig.chestLootTime.get()).intValue();
                    if (packedTime >= (long)(openedTime + (Integer)ServerConfig.INSTANCE.dungeonConfig.chestLootTime.get())) {
                        tag.m_128405_("openedTime", (int)packedTime);
                        ResourceLocation lootTable = chest instanceof GoldChestBlockEntity ? ResourceLocation.m_135822_((String)((String)ServerConfig.INSTANCE.dungeonConfig.goldChestLoot.get()), (char)':') : (chest instanceof SilverChestBlockEntity ? ResourceLocation.m_135822_((String)((String)ServerConfig.INSTANCE.dungeonConfig.silverChestLoot.get()), (char)':') : ResourceLocation.m_135822_((String)((String)ServerConfig.INSTANCE.dungeonConfig.bronzeChestLoot.get()), (char)':'));
                        if (((Boolean)ServerConfig.INSTANCE.dungeonConfig.perPlayerLoot.get()).booleanValue()) {
                            chest.playersWithGeneratedLoot.clear();
                        }
                        for (int i2 = 0; i2 < chest.m_6643_(); ++i2) {
                            chest.m_6836_(i2, ItemStack.f_41583_);
                            BlockEntity blockEntity3 = pLevel.m_7702_(pPos.m_121945_(DungeonChestBlock.getConnectedDirection(blockState)));
                            if (!(blockEntity3 instanceof DungeonChestBlockEntity)) continue;
                            DungeonChestBlockEntity connected = (DungeonChestBlockEntity)blockEntity3;
                            connected.m_6836_(i2, ItemStack.f_41583_);
                        }
                        if (((Boolean)ServerConfig.INSTANCE.dungeonConfig.perPlayerLoot.get()).booleanValue()) {
                            chest.setLootTable(lootTable);
                        } else {
                            chest.m_59626_(lootTable, pLevel.m_213780_().m_188505_());
                        }
                        chest.m_59640_(player);
                    }
                    if ((i2 = pLevel.m_7702_(pPos.m_121945_(DungeonChestBlock.getConnectedDirection(blockState)))) instanceof DungeonChestBlockEntity) {
                        DungeonChestBlockEntity connected = (DungeonChestBlockEntity)i2;
                        CompoundTag otherTag = connected.getPersistentData();
                        otherTag.m_128405_("openedTime", (int)packedTime);
                    }
                }
                player.m_5893_(menuProvider);
                player.m_36246_(this.getOpenChestStat());
                BlockState state = pLevel.m_8055_(pPos);
                ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
                if (blockId == null || !blockId.equals((Object)new ResourceLocation("trbeyond", "gold_chest")) || !(player instanceof ServerPlayer) || (server = (serverPlayer = (ServerPlayer)player).m_20194_()) == null) break;
                ResourceLocation advId = new ResourceLocation("trbeyond", "loot");
                Advancement advancement = server.m_129889_().m_136041_(advId);
                if (advancement == null) break;
                AdvancementProgress progress = serverPlayer.m_8960_().m_135996_(advancement);
                for (String criterion : progress.m_8219_()) {
                    serverPlayer.m_8960_().m_135988_(advancement, criterion);
                }
                break;
            }
            case TNT: {
                PrimedDungeonChestEntity chest = new PrimedDungeonChestEntity(pLevel, (double)pPos.m_123341_() + 0.5, pPos.m_123342_(), (double)pPos.m_123343_() + 0.5);
                chest.setSourceItem(this.m_5456_().m_7968_());
                chest.setSpawnDirection((Direction)blockState.m_61143_((Property)FACING));
                pLevel.m_7967_((Entity)chest);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)chest, (ParticleOptions)ParticleTypes.f_123755_);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)chest, (ParticleOptions)ParticleTypes.f_123762_);
                pLevel.m_6263_(null, chest.m_20185_(), chest.m_20186_(), chest.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
                BlockPos relative = pPos.m_121945_(DungeonChestBlock.getConnectedDirection(blockState));
                pLevel.m_7471_(pPos, false);
                pLevel.m_7471_(pPos.m_121945_(DungeonChestBlock.getConnectedDirection(blockState)), false);
                TaskScheduler.scheduleTask(new TaskScheduler.ScheduledTask(6000, () -> {
                    pLevel.m_7731_(pPos, blockState, 3);
                    pLevel.m_7731_(relative, (BlockState)((BlockState)blockState.m_61124_(TYPE, (Comparable)((ChestType)blockState.m_61143_(TYPE)).m_61486_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(pLevel.m_6425_(relative).m_192917_((Fluid)Fluids.f_76193_))), 3);
                }));
                break;
            }
            case PARALYSIS: {
                BlockPos relative = pPos.m_121945_(DungeonChestBlock.getConnectedDirection(blockState));
                Vec3 center = new Vec3((double)(relative.m_123341_() + pPos.m_123341_()) / 2.0 + 0.5, (double)pPos.m_123342_() + 1.25, (double)(relative.m_123343_() + pPos.m_123343_()) / 2.0 + 0.5);
                AABB box = new AABB(center.m_82520_(-0.5, -0.5, -0.5), center.m_82520_(0.5, 0.5, 0.5));
                List list = pLevel.m_45976_(LivingEntity.class, box.m_82400_(9.0));
                if (!list.isEmpty()) {
                    for (LivingEntity target : list) {
                        if (target instanceof Player) {
                            Player pPlayer = (Player)target;
                            if (pPlayer.m_150110_().f_35934_) continue;
                        }
                        target.m_6469_(BeyondDamageSources.PARALYSIS, 4.0f);
                        target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PARALYSIS.get(), 200, 4));
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)((ParticleOptions)TensuraParticles.YELLOW_LIGHTNING_SPARK.get()), (double)2.0);
                    }
                }
                TensuraParticleHelper.addServerParticlesAroundPos((RandomSource)pLevel.m_213780_(), (Level)pLevel, (Vec3)center, (ParticleOptions)((ParticleOptions)TensuraParticles.SOLAR_FLASH.get()), (double)1.0);
                TensuraParticleHelper.spawnServerParticles((Level)player.f_19853_, (ParticleOptions)((ParticleOptions)TensuraParticles.YELLOW_LIGHTNING_SPARK.get()), (double)center.m_7096_(), (double)center.m_7098_(), (double)center.m_7094_(), (int)60, (double)0.08, (double)0.08, (double)0.08, (double)0.5, (boolean)true);
                player.m_9236_().m_6263_(null, center.m_7096_(), center.m_7098_(), center.m_7094_(), SoundEvents.f_12089_, SoundSource.PLAYERS, 3.0f, 1.0f);
                break;
            }
            case MIMIC: {
                DungeonChestBlock.spawnMimic(pLevel, pPos, player, blockState);
                for (Entity entity : pLevel.m_45933_((Entity)player, player.m_20191_().m_82400_(10.0))) {
                    if (!(entity instanceof MimicChestEntity)) continue;
                    MimicChestEntity mimic = (MimicChestEntity)entity;
                    mimic.m_6710_((LivingEntity)player);
                }
                for (int x = -10; x < 10; ++x) {
                    for (int y = -10; y < 10; ++y) {
                        for (int z = -10; z < 10; ++z) {
                            DungeonChestBlock chest;
                            Block block = pLevel.m_8055_(pPos.m_7918_(x, y, z)).m_60734_();
                            if (!(block instanceof DungeonChestBlock) || (chest = (DungeonChestBlock)block).getType() != DungeonChestType.MIMIC) continue;
                            DungeonChestBlock.spawnMimic(pLevel, pPos.m_7918_(x, y, z), player, pLevel.m_8055_(pPos.m_7918_(x, y, z)));
                        }
                    }
                }
                break;
            }
        }
        return InteractionResult.CONSUME;
    }

    public static void spawnMimic(Level level, BlockPos blockPos, Player player, BlockState blockState) {
        EntityType entityType = level.m_7702_(blockPos) instanceof GoldChestBlockEntity ? (EntityType)BeyondEntities.GOLD_MIMIC_CHEST.get() : (EntityType)BeyondEntities.SILVER_MIMIC_CHEST.get();
        MimicChestEntity mimic = new MimicChestEntity((EntityType<? extends MimicChestEntity>)entityType, level, true);
        BlockPos mimicPos = blockPos;
        if (blockState.m_61143_((Property)FACING) == Direction.NORTH) {
            mimic.m_6034_(mimicPos.m_123341_(), mimicPos.m_123342_(), (double)mimicPos.m_123343_() + 0.5);
            mimic.m_7890_(Rotation.CLOCKWISE_180);
        } else if (blockState.m_61143_((Property)FACING) == Direction.SOUTH) {
            mimic.m_6034_(mimicPos.m_123341_(), mimicPos.m_123342_(), (double)mimicPos.m_123343_() + 0.5);
        } else if (blockState.m_61143_((Property)FACING) == Direction.EAST) {
            mimic.m_6034_((double)mimicPos.m_123341_() + 0.5, mimicPos.m_123342_(), mimicPos.m_123343_());
            mimic.m_7890_(Rotation.COUNTERCLOCKWISE_90);
        } else if (blockState.m_61143_((Property)FACING) == Direction.WEST) {
            mimic.m_6034_((double)mimicPos.m_123341_() + 0.5, mimicPos.m_123342_(), mimicPos.m_123343_());
            mimic.m_7890_(Rotation.CLOCKWISE_90);
        }
        mimic.getPersistentData().m_128379_("respawn", false);
        level.m_7967_((Entity)mimic);
        mimic.m_6710_((LivingEntity)player);
        TaskScheduler.scheduleTask(new TaskScheduler.ScheduledTask(6000, () -> {
            level.m_7731_(blockPos, blockState, 3);
            level.m_7731_(blockPos.m_121945_(DungeonChestBlock.getConnectedDirection(blockState)), (BlockState)((BlockState)blockState.m_61124_(TYPE, (Comparable)((ChestType)blockState.m_61143_(TYPE)).m_61486_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(blockPos.m_121945_(DungeonChestBlock.getConnectedDirection(blockState))).m_192917_((Fluid)Fluids.f_76193_))), 3);
        }));
        level.m_7471_(blockPos.m_121945_(DungeonChestBlock.getConnectedDirection(blockState)), false);
        level.m_7471_(blockPos, false);
    }

    protected Stat<ResourceLocation> getOpenChestStat() {
        return Stats.f_12988_.m_12902_((Object)Stats.f_12968_);
    }

    public BlockEntityType<? extends DungeonChestBlockEntity> blockEntityType() {
        return this.blockEntityType.get();
    }

    @Nullable
    public static Container getContainer(DungeonChestBlock chestBlock, BlockState blockState, Level level, BlockPos blockPos, boolean ignoreBlockedChest) {
        return ((Optional)chestBlock.combine(blockState, level, blockPos, ignoreBlockedChest).m_5649_(DungeonChestBlock.chestCombiner())).orElse(null);
    }

    public DoubleBlockCombiner.NeighborCombineResult<? extends DungeonChestBlockEntity> combine(BlockState blockState, Level level, BlockPos blockPos, boolean ignoreBlockedChest) {
        BiPredicate<LevelAccessor, BlockPos> biPredicate = ignoreBlockedChest ? (levelAccessor, blockPos1) -> false : DungeonChestBlock::isChestBlockedAt;
        return DoubleBlockCombiner.m_52822_(this.blockEntityType.get(), DungeonChestBlock::getBlockType, DungeonChestBlock::getConnectedDirection, (DirectionProperty)FACING, (BlockState)blockState, (LevelAccessor)level, (BlockPos)blockPos, biPredicate);
    }

    @Nullable
    public MenuProvider m_7246_(BlockState blockState, Level level, BlockPos blockPos) {
        return ((Optional)this.combine(blockState, level, blockPos, false).m_5649_(DungeonChestBlock.menuCombiner())).orElse(null);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return DungeonChestBlock.m_152132_(blockEntityType, this.blockEntityType(), DungeonChestBlockEntity::tick);
    }

    public static boolean isChestBlockedAt(LevelAccessor levelAccessor, BlockPos blockPos) {
        return DungeonChestBlock.isBlockedChestByBlock((BlockGetter)levelAccessor, blockPos);
    }

    private static boolean isBlockedChestByBlock(BlockGetter blockGetter, BlockPos blockPos) {
        BlockPos above = blockPos.m_7494_();
        return blockGetter.m_8055_(above).m_60796_(blockGetter, above);
    }

    public boolean m_7278_(BlockState blockState) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos blockPos) {
        return AbstractContainerMenu.m_38938_((Container)DungeonChestBlock.getContainer(this, blockState, level, blockPos, false));
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockBlockStateBuilder) {
        blockBlockStateBuilder.m_61104_(new Property[]{FACING, WATERLOGGED, TYPE});
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return false;
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        BlockEntity blockEntity = serverLevel.m_7702_(blockPos);
        if (blockEntity instanceof DungeonChestBlockEntity) {
            DungeonChestBlockEntity entity = (DungeonChestBlockEntity)blockEntity;
            entity.recheckOpen();
        }
    }

    public static DoubleBlockCombiner.Combiner<DungeonChestBlockEntity, Float2FloatFunction> opennessCombiner(final LidBlockEntity lidBlockEntity) {
        return new DoubleBlockCombiner.Combiner<DungeonChestBlockEntity, Float2FloatFunction>(){

            public Float2FloatFunction acceptDouble(DungeonChestBlockEntity blockEntityOne, DungeonChestBlockEntity blockEntityTwo) {
                return lidBlockEntity -> Math.max(blockEntityOne.m_6683_(lidBlockEntity), blockEntityTwo.m_6683_(lidBlockEntity));
            }

            public Float2FloatFunction acceptSingle(DungeonChestBlockEntity blockEntity) {
                return blockEntity::m_6683_;
            }

            public Float2FloatFunction acceptNone() {
                return arg_0 -> ((LidBlockEntity)lidBlockEntity).m_6683_(arg_0);
            }
        };
    }

    public static DoubleBlockCombiner.Combiner<DungeonChestBlockEntity, Optional<Container>> chestCombiner() {
        return new DoubleBlockCombiner.Combiner<DungeonChestBlockEntity, Optional<Container>>(){

            public Optional<Container> acceptDouble(DungeonChestBlockEntity entity, DungeonChestBlockEntity entity2) {
                return Optional.of(new CompoundContainer((Container)entity, (Container)entity2));
            }

            public Optional<Container> acceptSingle(DungeonChestBlockEntity entity) {
                return Optional.of(entity);
            }

            public Optional<Container> acceptNone() {
                return Optional.empty();
            }
        };
    }

    public static DoubleBlockCombiner.Combiner<DungeonChestBlockEntity, Optional<MenuProvider>> menuCombiner() {
        return new DoubleBlockCombiner.Combiner<DungeonChestBlockEntity, Optional<MenuProvider>>(){

            public Optional<MenuProvider> acceptDouble(final DungeonChestBlockEntity entity, final DungeonChestBlockEntity entity2) {
                CompoundContainer container = new CompoundContainer((Container)entity, (Container)entity2);
                return Optional.of(new MenuProvider(){
                    final /* synthetic */ Container val$container;
                    {
                        this.val$container = container;
                    }

                    @Nullable
                    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
                        if (entity.m_7525_(player) && entity2.m_7525_(player)) {
                            entity.m_59640_(inventory.f_35978_);
                            entity2.m_59640_(inventory.f_35978_);
                            return ChestMenu.m_39246_((int)i, (Inventory)inventory, (Container)this.val$container);
                        }
                        return null;
                    }

                    public Component m_5446_() {
                        if (entity.m_8077_()) {
                            return entity.m_5446_();
                        }
                        return entity2.m_8077_() ? entity2.m_5446_() : entity.m_7755_();
                    }
                });
            }

            public Optional<MenuProvider> acceptSingle(DungeonChestBlockEntity entity) {
                return Optional.of(entity);
            }

            public Optional<MenuProvider> acceptNone() {
                return Optional.empty();
            }
        };
    }

    public DungeonChestType getType() {
        return this.type;
    }

    public static enum DungeonChestType {
        DEFAULT,
        TNT,
        PARALYSIS,
        MIMIC;

    }
}

