/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.block;

import com.github.manasmods.tensura.ability.SkillHelper;
import io.github.Memoires.trbeyond.capability.dungeon.DungeonCapability;
import io.github.Memoires.trbeyond.config.ServerConfig;
import io.github.Memoires.trbeyond.network.worldgen.DungeonSaveData;
import io.github.Memoires.trbeyond.network.worldgen.dimension.BeyondDungeon;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class DungeonGateTeleporterBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape COLLIDE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);

    public DungeonGateTeleporterBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return COLLIDE;
    }

    @NotNull
    public VoxelShape m_5909_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE;
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    @NotNull
    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_7892_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (level instanceof ServerLevel) {
                ServerLevel sLevel = (ServerLevel)level;
                if (level.f_46443_) return;
                if (!entity.m_6084_()) return;
                if (level.m_46472_() == BeyondDungeon.DUNGEON_LEVEL_KEY) {
                    level.m_7654_().execute(() -> DungeonCapability.getFrom((LivingEntity)player).ifPresent(cap -> {
                        BlockPos overworldCoords = cap.getOverworldCoords();
                        SkillHelper.moveAcrossDimensionTo((Entity)player, (double)overworldCoords.m_123341_(), (double)overworldCoords.m_123342_(), (double)overworldCoords.m_123343_(), (float)player.m_146908_(), (float)player.m_146909_(), (ServerLevel)sLevel.m_7654_().m_129783_());
                    }));
                    return;
                }
                BlockPos savePos = pos.m_7918_(2, 0, 2);
                if (state.m_61143_((Property)FACING) == Direction.NORTH) {
                    savePos = pos.m_7918_(0, 0, -2);
                } else if (state.m_61143_((Property)FACING) == Direction.SOUTH) {
                    savePos = pos.m_7918_(0, 0, 2);
                } else if (state.m_61143_((Property)FACING) == Direction.EAST) {
                    savePos = pos.m_7918_(2, 0, 0);
                } else if (state.m_61143_((Property)FACING) == Direction.WEST) {
                    savePos = pos.m_7918_(-2, 0, 0);
                }
                ServerLevel dungeonLevel = level.m_7654_().m_129880_(BeyondDungeon.DUNGEON_LEVEL_KEY);
                if (dungeonLevel != null && dungeonLevel.m_6907_().size() >= (Integer)ServerConfig.INSTANCE.dungeonConfig.playerLimit.get() && (Integer)ServerConfig.INSTANCE.dungeonConfig.playerLimit.get() != 0) {
                    player.m_5661_((Component)Component.m_237115_((String)"trbeyond.message.dungeon_full"), true);
                    player.m_6021_((double)savePos.m_123341_() + 0.5, (double)savePos.m_123342_(), (double)savePos.m_123343_() + 0.5);
                    return;
                }
                if ((Long)ServerConfig.INSTANCE.dungeonConfig.enterCooldown.get() > 0L) {
                    Long cooldown = (Long)ServerConfig.INSTANCE.dungeonConfig.enterCooldown.get();
                    if (player.getPersistentData().m_128454_("dungeonEnterCooldown") + cooldown >= System.currentTimeMillis() / 1000L) {
                        player.m_5661_((Component)Component.m_237110_((String)"trbeyond.message.dungeon_enter_cooldown", (Object[])new Object[]{cooldown}), true);
                        player.m_6021_((double)savePos.m_123341_() + 0.5, (double)savePos.m_123342_(), (double)savePos.m_123343_() + 0.5);
                        return;
                    }
                }
                DungeonCapability.setOverworldCoords((LivingEntity)player, savePos);
                DungeonCapability.sync((LivingEntity)player);
                DungeonSaveData.getOverworld((Level)sLevel).addTpToDungeonPlayer(player.m_20148_());
                return;
            }
        }
        if (!(entity instanceof LivingEntity)) return;
        LivingEntity livingEntity = (LivingEntity)entity;
        if (!(level instanceof ServerLevel)) return;
        ServerLevel sLevel = (ServerLevel)level;
        if (!(livingEntity instanceof TamableAnimal)) return;
        TamableAnimal tame = (TamableAnimal)livingEntity;
        if (tame.m_21826_() == null) {
            return;
        }
        if (level.f_46443_) return;
        if (!entity.m_6084_()) return;
        if (level.m_46472_() == BeyondDungeon.DUNGEON_LEVEL_KEY) {
            level.m_7654_().execute(() -> DungeonCapability.getFrom(tame.m_21826_()).ifPresent(cap -> {
                BlockPos overworldCoords = cap.getOverworldCoords();
                tame.getPersistentData().m_128356_("dungeonEnterCooldown", System.currentTimeMillis() / 1000L);
                SkillHelper.moveAcrossDimensionTo((Entity)tame, (double)overworldCoords.m_123341_(), (double)overworldCoords.m_123342_(), (double)overworldCoords.m_123343_(), (float)tame.m_146908_(), (float)tame.m_146909_(), (ServerLevel)sLevel.m_7654_().m_129783_());
            }));
            return;
        }
        ServerLevel dungeonLevel = tame.m_20194_().m_129880_(BeyondDungeon.DUNGEON_LEVEL_KEY);
        if (dungeonLevel == null) return;
        SkillHelper.moveAcrossDimensionTo((Entity)tame, (double)8.0, (double)116.0, (double)-7.0, (float)tame.m_146908_(), (float)tame.m_146909_(), (ServerLevel)dungeonLevel);
    }
}

