/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.block;

import io.github.Memoires.trbeyond.TRBeyond;
import io.github.Memoires.trbeyond.block.entity.AnimateDoorBlockEntity;
import io.github.Memoires.trbeyond.network.worldgen.DungeonSaveData;
import io.github.Memoires.trbeyond.network.worldgen.dimension.BeyondDungeon;
import io.github.Memoires.trbeyond.network.worldgen.portal.BeyondTeleporterUpdated;
import io.github.Memoires.trbeyond.registry.entities.BeyondEntities;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DungeonUnlockerBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty CAN_GENERATE = BooleanProperty.m_61465_((String)"can_generate");
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty ENABLED = BooleanProperty.m_61465_((String)"enabled");
    public static final IntegerProperty TYPE = IntegerProperty.m_61631_((String)"type", (int)0, (int)4);
    public static final IntegerProperty FLOOR = IntegerProperty.m_61631_((String)"floor", (int)0, (int)10);
    public static final IntegerProperty ANIM_STAGE = IntegerProperty.m_61631_((String)"anim_stage", (int)0, (int)14);
    public static final VoxelShape SHAPE_X = DungeonUnlockerBlock.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPE_Z = DungeonUnlockerBlock.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);

    public DungeonUnlockerBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(-1.0f, 3600000.0f).m_222994_().m_60922_((state, level, pos, type) -> false));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)CAN_GENERATE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ANIM_STAGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)TYPE, (Comparable)Integer.valueOf(0))).m_61124_((Property)FLOOR, (Comparable)Integer.valueOf(0)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (BeyondTeleporterUpdated.checkfloor95door(pos, level) || (Integer)state.m_61143_((Property)TYPE) == 1) {
            if (!level.m_5776_()) {
                player.getPersistentData().m_128356_("LastKnownLocation", player.m_20097_().m_7494_().m_121878_());
                level.m_7654_().execute(() -> {
                    player.getPersistentData().m_128379_("shouldSpawn", false);
                    BlockPos targetPos = DungeonSaveData.getOverworld(level).getFloor95ShopPos();
                    player.m_6021_((double)targetPos.m_123341_(), (double)targetPos.m_123342_(), (double)targetPos.m_123343_());
                });
            }
            return InteractionResult.SUCCESS;
        }
        int checkDoor = BeyondTeleporterUpdated.checkLobbyOrLastKnownLocationDoor(pos, level);
        if (checkDoor != 0 || (Integer)state.m_61143_((Property)TYPE) != 0 && (Integer)state.m_61143_((Property)TYPE) != 4) {
            if (!level.m_5776_()) {
                level.m_7654_().execute(() -> {
                    BlockPos destination = null;
                    if ((checkDoor == 1 || (Integer)state.m_61143_((Property)TYPE) == 3) && player.getPersistentData().m_128423_("LastKnownLocation") != null) {
                        destination = BlockPos.m_122022_((long)player.getPersistentData().m_128454_("LastKnownLocation"));
                    } else if (checkDoor == -1 || checkDoor == 1 || (Integer)state.m_61143_((Property)TYPE) == 2 || (Integer)state.m_61143_((Property)TYPE) == 3) {
                        destination = DungeonSaveData.getOverworld(level).getLobbyPos();
                    }
                    if (destination != null) {
                        player.getPersistentData().m_128379_("shouldSpawn", true);
                        player.m_6021_((double)destination.m_123341_(), (double)destination.m_123342_(), (double)destination.m_123343_());
                    }
                });
            }
            return InteractionResult.SUCCESS;
        }
        if (BeyondTeleporterUpdated.checkBossRushDoor(pos, level) || (Integer)state.m_61143_((Property)TYPE) == 4) {
            if (!level.m_5776_()) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                EntityType bossType = (EntityType)BeyondEntities.EVIL_CENTIPEDE_BOSS.get();
                if (serverPlayer.m_8951_().m_13015_(Stats.f_12986_.m_12902_((Object)bossType)) <= 0) {
                    serverPlayer.m_213846_((Component)Component.m_237110_((String)"trbeyond.message.boss_rush.no_permission", (Object[])new Object[]{player.m_5446_(), bossType.m_20676_()}));
                    return InteractionResult.SUCCESS;
                }
                level.m_7654_().execute(() -> {
                    TRBeyond.getLogger().info("trying to teleport to rush");
                    BlockPos destination = null;
                    destination = DungeonSaveData.getOverworld(level).getBossRushPos();
                    TRBeyond.getLogger().debug("Pos: " + String.valueOf(destination));
                    if (destination != null) {
                        player.getPersistentData().m_128379_("shouldSpawn", true);
                        player.m_6021_((double)destination.m_123341_(), (double)destination.m_123342_(), (double)destination.m_123343_());
                    }
                });
            }
            return InteractionResult.SUCCESS;
        }
        if (BeyondTeleporterUpdated.checkDontLetThisDoorOpen(pos)) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41720_() == Items.f_42751_) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)CAN_GENERATE, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)CAN_GENERATE) == false)));
        } else if (((Boolean)state.m_61143_((Property)CAN_GENERATE)).booleanValue()) {
            DungeonUnlockerBlock.generateNext(state, level, pos, player, hitResult);
        } else {
            DungeonUnlockerBlock.findGenerationBlock(state, level, pos, player, hitResult);
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int value;
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        Direction.m_235666_().filter(direction -> direction.m_122434_() != dir.m_122434_()).forEach(direction -> {
            BlockPos checkPos = pos.m_121955_(direction.m_122436_());
            BlockState checkState = level.m_8055_(checkPos);
            if (checkState.m_61138_((Property)CAN_GENERATE)) {
                level.m_186460_(checkPos, (Block)this, 1);
            }
        });
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
        if (((Boolean)state.m_61143_((Property)CAN_GENERATE)).booleanValue() && (value = ((Integer)state.m_61143_((Property)ANIM_STAGE)).intValue()) < 14) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)ANIM_STAGE, (Comparable)Integer.valueOf(++value)));
            level.m_186460_(pos, (Block)this, 1);
        }
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
        if (((Boolean)state.m_61143_((Property)CAN_GENERATE)).booleanValue() && (value = ((Integer)state.m_61143_((Property)ANIM_STAGE)).intValue()) < 14) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)ANIM_STAGE, (Comparable)Integer.valueOf(++value)));
            level.m_186460_(pos, (Block)this, 1);
            if (value == 1) {
                this.removeBarrierBlocks(level, pos, (Direction)state.m_61143_((Property)FACING));
            }
        }
    }

    private void removeBarrierBlocks(ServerLevel level, BlockPos doorPos, Direction facing) {
        level.m_7471_(doorPos.m_6630_(1), false);
        level.m_7471_(doorPos.m_6630_(2), false);
        level.m_7471_(doorPos.m_6630_(3), false);
    }

    private static void generateNext(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BeyondDungeon.generateNextPart(state, level, pos, player, hitResult);
    }

    private static void findGenerationBlock(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        GenBlockFinder.findGenBlock(state, level, pos, player, hitResult).ifPresent(genPos -> DungeonUnlockerBlock.generateNext(level.m_8055_(genPos), level, genPos, player, hitResult));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return ((Boolean)state.m_61143_((Property)ENABLED)).booleanValue() ? (((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X ? SHAPE_X : SHAPE_Z) : Shapes.m_83040_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CAN_GENERATE, ENABLED, FACING, ANIM_STAGE, TYPE, FLOOR});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new AnimateDoorBlockEntity(pos, state);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        Block block = pState.m_60734_();
        if (block instanceof DungeonUnlockerBlock) {
            DungeonUnlockerBlock block2 = (DungeonUnlockerBlock)block;
            if (((Boolean)pState.m_61143_((Property)CAN_GENERATE)).booleanValue()) {
                BlockState newBlockState = (BlockState)pState.m_61124_((Property)CAN_GENERATE, (Comparable)Boolean.valueOf(false));
                int floor = (Integer)pState.m_61143_((Property)FLOOR);
                if (floor == 0) {
                    pLevel.m_7731_(pPos.m_6625_(1), newBlockState, 3);
                    pLevel.m_7731_(pPos.m_6630_(1), newBlockState, 3);
                    pLevel.m_7731_(pPos.m_6630_(2), newBlockState, 3);
                    pLevel.m_7731_(pPos.m_6630_(3), newBlockState, 3);
                    if (pState.m_61143_((Property)FACING) == Direction.EAST || pState.m_61143_((Property)FACING) == Direction.WEST) {
                        pLevel.m_7731_(pPos.m_122012_(), newBlockState, 3);
                        pLevel.m_7731_(pPos.m_7494_().m_122012_(), newBlockState, 3);
                        pLevel.m_7731_(pPos.m_7495_().m_122012_(), newBlockState, 3);
                        pLevel.m_7731_(pPos.m_122019_(), newBlockState, 3);
                        pLevel.m_7731_(pPos.m_7494_().m_122019_(), newBlockState, 3);
                        pLevel.m_7731_(pPos.m_7495_().m_122019_(), newBlockState, 3);
                    }
                    if (pState.m_61143_((Property)FACING) == Direction.NORTH || pState.m_61143_((Property)FACING) == Direction.SOUTH) {
                        pLevel.m_7731_(pPos.m_122029_(), newBlockState, 3);
                        pLevel.m_7731_(pPos.m_6630_(1).m_122029_(), newBlockState, 3);
                        pLevel.m_7731_(pPos.m_6630_(2).m_122029_(), newBlockState, 3);
                        pLevel.m_7731_(pPos.m_7495_().m_122029_(), newBlockState, 3);
                        pLevel.m_7731_(pPos.m_122024_(), newBlockState, 3);
                        pLevel.m_7731_(pPos.m_6630_(1).m_122024_(), newBlockState, 3);
                        pLevel.m_7731_(pPos.m_6630_(2).m_122024_(), newBlockState, 3);
                        pLevel.m_7731_(pPos.m_7495_().m_122024_(), newBlockState, 3);
                    }
                } else {
                    Direction dir = (Direction)pState.m_61143_((Property)FACING);
                    for (int x = -2; x < 3; ++x) {
                        for (int y = -1; y < 5; ++y) {
                            if (x == 0 && y == 0) continue;
                            pLevel.m_7731_(pPos.m_5484_(dir.m_122427_(), x).m_6630_(y), newBlockState, 3);
                        }
                    }
                }
            }
        }
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    private static class GenBlockFinder {
        private static final int MAX_LOOKUP_RADIUS = 5;

        private GenBlockFinder() {
        }

        public static Optional<BlockPos> findGenBlock(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
            Direction dir = (Direction)state.m_61143_((Property)FACING);
            for (int x = -5; x < 5; ++x) {
                for (int y = -5; y < 5; ++y) {
                    BlockPos checkPos = pos.m_7918_(dir.m_122431_() * x, y, dir.m_122429_() * x);
                    BlockState checkState = level.m_8055_(checkPos);
                    if (!checkState.m_61138_((Property)CAN_GENERATE) || !((Boolean)checkState.m_61143_((Property)CAN_GENERATE)).booleanValue()) continue;
                    return Optional.of(checkPos);
                }
            }
            return Optional.empty();
        }
    }
}

