/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.block;

import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.entity.BarghestEntity;
import com.github.manasmods.tensura.entity.DirewolfEntity;
import com.github.manasmods.tensura.entity.GiantAntEntity;
import com.github.manasmods.tensura.entity.GiantBatEntity;
import com.github.manasmods.tensura.entity.HoundDogEntity;
import com.github.manasmods.tensura.entity.LeechLizardEntity;
import com.github.manasmods.tensura.entity.MetalSlimeEntity;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.item.armor.SimpleArmorItem;
import com.github.manasmods.tensura.item.templates.SimpleBowItem;
import com.github.manasmods.tensura.item.templates.SimpleSwordItem;
import com.github.manasmods.tensura.item.templates.custom.TensuraSword;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraArmorItems;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import io.github.Memoires.trbeyond.block.DungeonChestBlock;
import io.github.Memoires.trbeyond.block.entity.DungeonChestBlockEntity;
import io.github.Memoires.trbeyond.block.entity.ShrineBlockEntity;
import io.github.Memoires.trbeyond.capability.dungeon.DungeonCapability;
import io.github.Memoires.trbeyond.capability.dungeon.IDungeonCapability;
import io.github.Memoires.trbeyond.capability.player.IBeyondPlayerCapability;
import io.github.Memoires.trbeyond.config.ServerConfig;
import io.github.Memoires.trbeyond.entity.custom.MinhSlimeEntity;
import io.github.Memoires.trbeyond.entity.custom.ShrineEntity;
import io.github.Memoires.trbeyond.handlers.ChallengeEventHandler;
import io.github.Memoires.trbeyond.network.worldgen.DungeonSaveData;
import io.github.Memoires.trbeyond.registry.blocks.BeyondBlockEntities;
import io.github.Memoires.trbeyond.registry.blocks.BeyondBlocks;
import io.github.Memoires.trbeyond.registry.entities.BeyondEntities;
import io.github.Memoires.trbeyond.util.ChallengeType;
import io.github.Memoires.trbeyond.util.TaskScheduler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.item.GeoArmorItem;

public class ShrineBlock
extends BaseEntityBlock {
    public final DungeonShrineTier tier;
    private final WeightedRandomList<WeightedEntry.Wrapper<String>> challengeRandomizer;
    protected final Supplier<BlockEntityType<? extends ShrineBlockEntity>> blockEntityType;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private DungeonShrineTier currentChestChallengeTier;
    private int chestsLeft;
    private int mobsLeft;
    private int currentWave;
    private int finalWave;
    private long timer = Long.MAX_VALUE;
    private boolean dontDecrementNextFailure = false;
    private boolean challengeCausesCooldown = true;

    public ShrineBlock(BlockBehaviour.Properties properties, Supplier<BlockEntityType<? extends ShrineBlockEntity>> blockEntityType, DungeonShrineTier tier) {
        super(properties);
        this.blockEntityType = blockEntityType;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        this.tier = tier;
        ArrayList<WeightedEntry.Wrapper> challenges = new ArrayList<WeightedEntry.Wrapper>();
        challenges.add(WeightedEntry.m_146290_((Object)"waves", (int)10));
        challenges.add(WeightedEntry.m_146290_((Object)"player_waves", (int)10));
        challenges.add(WeightedEntry.m_146290_((Object)"destroy_shrine", (int)10));
        challenges.add(WeightedEntry.m_146290_((Object)"pick_the_correct_chest", (int)2));
        if (tier == DungeonShrineTier.STELLAR || tier == DungeonShrineTier.GOLD) {
            challenges.add(WeightedEntry.m_146290_((Object)"defeat_boss", (int)5));
        }
        if (DungeonShrineTier.STELLAR == tier) {
            challenges.add(WeightedEntry.m_146290_((Object)"minh_slimes", (int)1));
        }
        this.challengeRandomizer = WeightedRandomList.m_146328_(challenges);
    }

    public void tick(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity shrineBlockEntity = pLevel.m_7702_(pPos);
        if (shrineBlockEntity == null) {
            return;
        }
        if (!shrineBlockEntity.getPersistentData().m_128461_("challengeState").equals("active")) {
            return;
        }
        String currentChallenge = shrineBlockEntity.getPersistentData().m_128461_("currentChallenge");
        Player player = null;
        try {
            player = pLevel.m_46003_(UUID.fromString(shrineBlockEntity.getPersistentData().m_128461_("currentPlayer")));
        }
        catch (IllegalArgumentException ignored) {
            for (String key : shrineBlockEntity.getPersistentData().m_128431_()) {
                shrineBlockEntity.getPersistentData().m_128473_(key);
            }
        }
        if (player == null) {
            return;
        }
        switch (currentChallenge) {
            case "pick_the_correct_chest": {
                if (this.currentChestChallengeTier == null) {
                    shrineBlockEntity.getPersistentData().m_128359_("challengeState", "completed");
                    return;
                }
                if (this.timer < pLevel.m_46467_()) {
                    this.pickChestsWrongChest(pLevel, pPos);
                }
                if (this.chestsLeft != 0) break;
                if (this.currentChestChallengeTier.ordinal() < this.tier.ordinal()) {
                    if (player.getPersistentData().m_128441_("challenge_time")) {
                        player.getPersistentData().m_128405_("challenge_time", 0);
                    }
                    this.pickChestsCleanupChests(pLevel, pPos);
                    this.pickChestsChallengeHelper(pState, pLevel, pPos, player);
                    break;
                }
                this.completeChallenge(pState, pLevel, pPos, player, false, false);
                break;
            }
            case "player_waves": {
                int secondsRemaining = (int)(this.timer - pLevel.m_46467_()) / 20;
                if (this.mobsLeft == 0 && secondsRemaining >= 10) {
                    this.mobsLeft = -1;
                    if (player.getPersistentData().m_128441_("challenge_time")) {
                        int currentPlayerChallengeTime = player.getPersistentData().m_128451_("challenge_time");
                        player.getPersistentData().m_128405_("challenge_time", currentPlayerChallengeTime + (secondsRemaining - 5));
                        player.m_213846_((Component)Component.m_237115_((String)"trbeyond.challenge.wave.early_completion"));
                    }
                    this.timer -= (long)(secondsRemaining - 5) * 20L;
                }
                if (this.timer >= pLevel.m_46467_()) break;
                this.playerWavesHelperSpawn(pState, pLevel, pPos, player);
                break;
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pBlockEntityType == BeyondBlockEntities.SHRINE.get() ? ShrineBlockEntity::tick : null;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            ShrineBlockEntity shrineBlockEntity = (ShrineBlockEntity)level.m_7702_(pos);
            if (shrineBlockEntity == null) {
                return InteractionResult.FAIL;
            }
            Optional<IBeyondPlayerCapability> capabilityOpt = ChallengeEventHandler.getPlayerCapability(player);
            if (capabilityOpt.isPresent() && capabilityOpt.get().getChallengeType() != null) {
                player.m_213846_((Component)Component.m_237115_((String)"trbeyond.message.shrine.already_possess_challenge"));
                return InteractionResult.SUCCESS;
            }
            if (shrineBlockEntity.getPersistentData().m_128441_("challengeState")) {
                String challengeState;
                switch (challengeState = shrineBlockEntity.getPersistentData().m_128461_("challengeState")) {
                    case "active": {
                        BlockEntity blockEntity = level.m_7702_(pos);
                        if (blockEntity != null) {
                            long lastActivatedTick = blockEntity.getPersistentData().m_128441_("lastActivatedTick") ? blockEntity.getPersistentData().m_128454_("lastActivatedTick") : 0L;
                            long currentTick = blockEntity.m_58904_().m_46467_();
                            if (currentTick - lastActivatedTick > 6000L) {
                                blockEntity.getPersistentData().m_128359_("challengeState", "failed");
                                if (blockEntity.getPersistentData().m_128441_("player")) {
                                    this.setCooldown(blockEntity.m_58904_(), pos, UUID.fromString(blockEntity.getPersistentData().m_128461_("player")));
                                }
                                player.m_213846_((Component)Component.m_237115_((String)"trbeyond.message.shrine.reset"));
                                return InteractionResult.SUCCESS;
                            }
                        }
                        player.m_213846_((Component)Component.m_237115_((String)"trbeyond.message.shrine.already_active"));
                        return InteractionResult.SUCCESS;
                    }
                    case "failed": {
                        this.activateShrine(state, level, pos, player);
                        break;
                    }
                    case "completed": {
                        this.activateShrine(state, level, pos, player);
                    }
                }
            } else {
                this.activateShrine(state, level, pos, player);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void activateShrine(BlockState state, Level level, BlockPos pos, Player player) {
        boolean warningIssued = false;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity != null) {
            ShrineBlockEntity shrineBlockEntity;
            boolean playerOnCooldown;
            if (blockEntity.getPersistentData().m_128441_("lastActivatedTick")) {
                long previouslyActivatedTick = blockEntity.getPersistentData().m_128454_("lastActivatedTick");
                long currentTick = blockEntity.m_58904_().m_46467_();
                if (currentTick < 80L + previouslyActivatedTick) {
                    warningIssued = true;
                }
            }
            boolean bl = playerOnCooldown = !DungeonSaveData.getOverworld(level).canUseShrine(player, pos, this.getPackedTime(), level);
            if (playerOnCooldown) {
                long cooldown = this.tier == DungeonShrineTier.STELLAR ? (long)((Integer)ServerConfig.INSTANCE.dungeonConfig.stellarShrineCooldown.get()).intValue() : (long)((Integer)ServerConfig.INSTANCE.dungeonConfig.shrineCooldown.get()).intValue();
                long lastUsed = DungeonSaveData.getOverworld(level).getShrineCooldown(player).get(pos);
                if (((Boolean)ServerConfig.INSTANCE.dungeonConfig.shrineCooldownPlaythroughs.get()).booleanValue()) {
                    if (!warningIssued) {
                        player.m_213846_((Component)Component.m_237110_((String)"trbeyond.message.shrine.cooldown.reward_warning", (Object[])new Object[]{cooldown + lastUsed - this.getPackedTime()}));
                        blockEntity.getPersistentData().m_128356_("lastActivatedTick", blockEntity.m_58904_().m_46467_());
                        return;
                    }
                } else {
                    player.m_213846_((Component)Component.m_237110_((String)"trbeyond.message.shrine.cooldown", (Object[])new Object[]{cooldown + lastUsed - this.getPackedTime()}));
                    return;
                }
            }
            if ((shrineBlockEntity = (ShrineBlockEntity)level.m_7702_(pos)) == null) {
                return;
            }
            shrineBlockEntity.getPersistentData().m_128359_("challengeState", "active");
            String challengeString = "";
            Optional challenge = this.challengeRandomizer.m_216829_(blockEntity.m_58904_().m_213780_());
            List<String> prohibitedCooldownChallenges = List.of("minh_slimes", "pick_the_correct_chest");
            while (playerOnCooldown && prohibitedCooldownChallenges.contains(((WeightedEntry.Wrapper)challenge.get()).m_146310_())) {
                challenge = this.challengeRandomizer.m_216829_(blockEntity.m_58904_().m_213780_());
            }
            if (!challenge.isPresent()) {
                return;
            }
            challengeString = (String)((WeightedEntry.Wrapper)challenge.get()).m_146310_();
            shrineBlockEntity.getPersistentData().m_128359_("currentPlayer", player.m_20149_());
            shrineBlockEntity.getPersistentData().m_128359_("currentChallenge", challengeString);
            player.getPersistentData().m_128359_("shrineTier", this.tier.name().toLowerCase());
            player.getPersistentData().m_128359_("shrineChallenge", challengeString);
            this.pickChestsCleanupChests(level, pos);
            level.m_5594_(null, pos, SoundEvents.f_12210_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (ChallengeEventHandler.shrineChallengesDisabled(player.m_9236_(), player)) {
                return;
            }
            switch (challengeString) {
                case "waves": {
                    this.waveSurvival(state, level, pos, player);
                    break;
                }
                case "player_waves": {
                    this.playerWaves(state, level, pos, player);
                    break;
                }
                case "destroy_shrine": {
                    ChallengeType shrine_challenge = new ChallengeType("destroy_shrine", "shrine", pos.toString(), 1, false, "minecraft:air", 0, 60, false);
                    ChallengeEventHandler.giveChallengeType(player, shrine_challenge, true);
                    this.destroyShrine(state, level, pos, player);
                    break;
                }
                case "defeat_boss": {
                    ChallengeType shrine_challenge = new ChallengeType("defeat_boss", "shrine", pos.toString(), 1, false, "minecraft:air", 0, 180, false);
                    ChallengeEventHandler.giveChallengeType(player, shrine_challenge, true);
                    this.defeatBoss(state, level, pos, player);
                    break;
                }
                case "minh_slimes": {
                    this.minhSlimeSlayerChallenge(state, level, pos, player);
                    break;
                }
                case "pick_the_correct_chest": {
                    this.pickChestsChallenge(state, level, pos, player);
                }
            }
        }
    }

    private void pickChestsChallenge(BlockState state, Level level, BlockPos pos, Player player) {
        this.currentChestChallengeTier = DungeonShrineTier.STELLAR;
        this.dontDecrementNextFailure = true;
        ChallengeType shrine_challenge = new ChallengeType("pick_the_correct_chest", "shrine", pos.toString(), 1, false, "minecraft:air", 0, 60, false, 60);
        ChallengeEventHandler.giveChallengeType(player, shrine_challenge, true);
        player.m_213846_((Component)Component.m_237115_((String)"trbeyond.challenge.pick_the_correct_chest.explanation"));
        this.pickChestsChallengeHelper(state, level, pos, player);
    }

    private void pickChestsChallengeHelper(BlockState state, Level level, BlockPos pos, Player player) {
        int trappedChest1;
        this.currentChestChallengeTier = switch (this.currentChestChallengeTier) {
            default -> throw new IncompatibleClassChangeError();
            case DungeonShrineTier.BRONZE -> DungeonShrineTier.SILVER;
            case DungeonShrineTier.SILVER -> DungeonShrineTier.GOLD;
            case DungeonShrineTier.GOLD -> DungeonShrineTier.STELLAR;
            case DungeonShrineTier.STELLAR -> DungeonShrineTier.BRONZE;
        };
        this.timer = level.m_46467_() + 1200L;
        int spawnedChests = 6 - this.currentChestChallengeTier.ordinal();
        int completedChallenges = 0;
        if (DungeonCapability.getFrom((LivingEntity)player).isPresent() && DungeonCapability.getFrom((LivingEntity)player).resolve().isPresent()) {
            IDungeonCapability cap = (IDungeonCapability)DungeonCapability.getFrom((LivingEntity)player).resolve().get();
            completedChallenges = cap.getChallengeCompletionCount(this.tier);
        }
        List<BlockPos> chestPositions = List.of(pos.m_5484_((Direction)state.m_61143_((Property)FACING), 2), pos.m_5484_((Direction)state.m_61143_((Property)FACING), 2).m_5484_(((Direction)state.m_61143_((Property)FACING)).m_122427_(), 3), pos.m_5484_((Direction)state.m_61143_((Property)FACING), 2).m_5484_(((Direction)state.m_61143_((Property)FACING)).m_122428_(), 3), pos.m_5484_((Direction)state.m_61143_((Property)FACING), -3), pos.m_5484_((Direction)state.m_61143_((Property)FACING), -3).m_5484_(((Direction)state.m_61143_((Property)FACING)).m_122428_(), 3), pos.m_5484_((Direction)state.m_61143_((Property)FACING), -3).m_5484_(((Direction)state.m_61143_((Property)FACING)).m_122427_(), 3));
        Block chestBlock = switch (this.currentChestChallengeTier) {
            default -> throw new IncompatibleClassChangeError();
            case DungeonShrineTier.BRONZE -> (Block)BeyondBlocks.BRONZE_CHEST.get();
            case DungeonShrineTier.SILVER -> (Block)BeyondBlocks.SILVER_CHEST.get();
            case DungeonShrineTier.GOLD -> (Block)BeyondBlocks.GOLD_CHEST.get();
            case DungeonShrineTier.STELLAR -> (Block)BeyondBlocks.STELLAR_CHEST.get();
        };
        float coinDoubleChance = switch (completedChallenges) {
            case 0 -> 0.0f;
            case 1 -> 0.05f;
            case 2 -> 0.1f;
            default -> 0.15f;
        };
        ArrayList<DungeonChestBlockEntity> chests = new ArrayList<DungeonChestBlockEntity>(spawnedChests);
        for (int i = 0; i < spawnedChests; ++i) {
            DungeonChestBlockEntity chest;
            BlockPos chestPos = chestPositions.get(i);
            level.m_7731_(chestPos, chestBlock.m_49966_(), 3);
            DungeonChestBlock dungeonChestBlock = (DungeonChestBlock)level.m_8055_(chestPos).m_60734_();
            BlockPos chestPos2 = chestPos.m_121945_(DungeonChestBlock.getConnectedDirection(level.m_8055_(chestPos)));
            level.m_7731_(chestPos2, (BlockState)dungeonChestBlock.m_49966_().m_61124_(DungeonChestBlock.TYPE, (Comparable)((ChestType)level.m_8055_(chestPos).m_61143_(DungeonChestBlock.TYPE)).m_61486_()), 3);
            level.m_8055_(chestPos).m_60701_((LevelAccessor)level, chestPos, 3);
            BlockEntity blockEntity = level.m_7702_(chestPos);
            if (blockEntity instanceof DungeonChestBlockEntity) {
                chest = (DungeonChestBlockEntity)blockEntity;
                chest.getPersistentData().m_128379_("noLock", true);
                chest.getPersistentData().m_128356_("placedTime", level.m_46467_());
            }
            DungeonSaveData.getOverworld(level).addBossChest(chestPos);
            blockEntity = level.m_7702_(chestPos2);
            if (!(blockEntity instanceof DungeonChestBlockEntity)) continue;
            chest = (DungeonChestBlockEntity)blockEntity;
            chests.add(chest);
            String lootTable = switch (this.currentChestChallengeTier) {
                default -> throw new IncompatibleClassChangeError();
                case DungeonShrineTier.BRONZE -> "shrines/shrine_bronze_1";
                case DungeonShrineTier.SILVER -> "shrines/shrine_silver_1";
                case DungeonShrineTier.GOLD -> "shrines/shrine_gold_1";
                case DungeonShrineTier.STELLAR -> "shrines/shrine_stellar_1";
            };
            chest.m_59626_(new ResourceLocation("trbeyond", lootTable), level.m_213780_().m_188505_());
            chest.m_59640_(player);
            chest.m_6596_();
            chest.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
                for (int j = 0; j < h.getSlots(); ++j) {
                    ItemStack stack = h.getStackInSlot(j);
                    if (!stack.m_41619_() && (stack.m_41720_() instanceof TensuraSword || stack.m_41720_() instanceof GeoArmorItem || stack.m_41720_() instanceof SimpleArmorItem || stack.m_41720_() instanceof SimpleSwordItem || stack.m_41720_() instanceof SimpleBowItem) && Math.random() < 0.5) {
                        stack = h.extractItem(j, 1, false);
                        EngravingEnchantment.randomEngraving((LivingEntity)player, (ItemStack)stack, (double)((Integer)TensuraConfig.INSTANCE.enchantmentsConfig.unique.get()).intValue());
                        h.insertItem(j, stack, false);
                    }
                    if (!(Math.random() < (double)coinDoubleChance) || !stack.m_150930_((Item)TensuraMaterialItems.BRONZE_COIN.get()) && !stack.m_150930_((Item)TensuraMaterialItems.SILVER_COIN.get()) && !stack.m_150930_((Item)TensuraMaterialItems.GOLD_COIN.get()) && !stack.m_150930_((Item)TensuraMaterialItems.STELLAR_GOLD_COIN.get())) continue;
                    stack.m_41764_(Math.min(64, stack.m_41613_() * 2));
                }
            });
        }
        int trappedChest2 = trappedChest1 = ShrineBlock.getRandomInRange(0, spawnedChests - 1);
        while (trappedChest2 == trappedChest1) {
            trappedChest2 = ShrineBlock.getRandomInRange(0, spawnedChests - 1);
        }
        ((DungeonChestBlockEntity)((Object)chests.get(trappedChest1))).m_6211_();
        ((DungeonChestBlockEntity)((Object)chests.get(trappedChest2))).m_6211_();
        ((DungeonChestBlockEntity)((Object)chests.get(trappedChest1))).getPersistentData().m_128379_("incorrectChest", true);
        ((DungeonChestBlockEntity)((Object)chests.get(trappedChest2))).getPersistentData().m_128379_("incorrectChest", true);
        for (BlockEntity blockEntity : chests) {
            blockEntity.getPersistentData().m_128379_("challengeChest", true);
            blockEntity.getPersistentData().m_128356_("shrinePos", pos.m_121878_());
        }
        this.chestsLeft = spawnedChests - 2;
    }

    public void pickChestsCorrectChest() {
        --this.chestsLeft;
    }

    public void pickChestsWrongChest(Level level, BlockPos pos) {
        BlockEntity shrineBlockEntity = level.m_7702_(pos);
        if (shrineBlockEntity == null) {
            return;
        }
        if (shrineBlockEntity.getPersistentData().m_128461_("challengeState").equals("active")) {
            UUID playerUUID = UUID.fromString(shrineBlockEntity.getPersistentData().m_128461_("currentPlayer"));
            if (this.currentChestChallengeTier != this.tier) {
                this.challengeCausesCooldown = false;
            }
            this.setCooldown(level, pos, playerUUID);
            this.failChallenge(level, pos, level.m_46003_(playerUUID));
            this.pickChestsCleanupChests(level, pos);
        }
    }

    private void pickChestsCleanupChests(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        List<BlockPos> chestPositions = List.of(pos.m_5484_((Direction)state.m_61143_((Property)FACING), 2), pos.m_5484_((Direction)state.m_61143_((Property)FACING), 2).m_5484_(((Direction)state.m_61143_((Property)FACING)).m_122427_(), 3), pos.m_5484_((Direction)state.m_61143_((Property)FACING), 2).m_5484_(((Direction)state.m_61143_((Property)FACING)).m_122428_(), 3), pos.m_5484_((Direction)state.m_61143_((Property)FACING), -3), pos.m_5484_((Direction)state.m_61143_((Property)FACING), -3).m_5484_(((Direction)state.m_61143_((Property)FACING)).m_122428_(), 3), pos.m_5484_((Direction)state.m_61143_((Property)FACING), -3).m_5484_(((Direction)state.m_61143_((Property)FACING)).m_122427_(), 3));
        for (BlockPos chestPos : chestPositions) {
            BlockEntity blockEntity = level.m_7702_(chestPos);
            if (!(blockEntity instanceof DungeonChestBlockEntity)) continue;
            DungeonChestBlockEntity chest1 = (DungeonChestBlockEntity)blockEntity;
            BlockPos chestPos2 = chestPos.m_121945_(DungeonChestBlock.getConnectedDirection(level.m_8055_(chestPos)));
            BlockEntity blockEntity2 = level.m_7702_(chestPos2);
            if (blockEntity2 instanceof DungeonChestBlockEntity) {
                DungeonChestBlockEntity chest2 = (DungeonChestBlockEntity)blockEntity2;
                if (chest1.getPersistentData().m_128441_("challengeChest") || chest2.getPersistentData().m_128441_("challengeChest")) {
                    chest1.m_6211_();
                    chest2.m_6211_();
                }
            }
            level.m_7471_(chestPos, false);
            level.m_7471_(chestPos2, false);
        }
    }

    private void minhSlimeSlayerChallenge(BlockState state, Level level, BlockPos pos, Player player) {
        ShrineBlockEntity shrineBlockEntity = (ShrineBlockEntity)level.m_7702_(pos);
        if (shrineBlockEntity == null) {
            return;
        }
        shrineBlockEntity.getPersistentData().m_128359_("challenge", "waves");
        shrineBlockEntity.getPersistentData().m_128359_("player", player.m_20148_().toString());
        shrineBlockEntity.getPersistentData().m_128356_("blockPos", pos.m_121878_());
        int spawnTime = 60;
        int waves = 15;
        ChallengeType shrine_challenge = new ChallengeType("minh_slimes", "shrine", pos.toString(), waves, false, "minecraft:air", 0, 60, false);
        ChallengeEventHandler.giveChallengeType(player, shrine_challenge, true);
        for (int j = 1; j < waves; ++j) {
            int waveCount = j;
            TaskScheduler.ScheduledTask task = new TaskScheduler.ScheduledTask(spawnTime * j, () -> {
                double dz;
                double dy;
                String challengeState;
                if (shrineBlockEntity.getPersistentData().m_128441_("challengeState") && ((challengeState = shrineBlockEntity.getPersistentData().m_128461_("challengeState")).equals("failed") || challengeState.equals("completed"))) {
                    return;
                }
                double dx = (double)pos.m_123341_() + 0.5 - player.m_20185_();
                double distance = Math.sqrt(dx * dx + (dy = (double)pos.m_123342_() + 0.5 - player.m_20186_()) * dy + (dz = (double)pos.m_123343_() + 0.5 - player.m_20189_()) * dz);
                if (distance > 25.0) {
                    this.failChallenge(level, pos, player);
                    return;
                }
                shrineBlockEntity.getPersistentData().m_128405_("wave", waveCount);
                ChallengeEventHandler.getPlayerCapability(player).ifPresent(capability -> {
                    if (capability.getChallengeType() == null) {
                        return;
                    }
                    capability.getChallengeType().setCountDone(waveCount);
                    MinhSlimeEntity challengeMob = new MinhSlimeEntity((EntityType<? extends MetalSlimeEntity>)((EntityType)BeyondEntities.MINH_SLIME.get()), level);
                    challengeMob.setSize(level.f_46441_.m_216332_(1, 3), false);
                    int xOffset = ShrineBlock.getRandomInRange(-6, 6);
                    int zOffset = ShrineBlock.getRandomInRange(-6, 6);
                    BlockPos mobPos = pos.m_7918_(xOffset, 0, zOffset);
                    challengeMob.m_6034_((double)mobPos.m_123341_() + 0.5, mobPos.m_123342_(), (double)mobPos.m_123343_() + 0.5);
                    challengeMob.m_146922_(((Direction)state.m_61143_((Property)FACING)).m_122435_());
                    challengeMob.getPersistentData().m_128359_("challengeMob", "Minh slime challenge");
                    level.m_7967_((Entity)challengeMob);
                    challengeMob.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 1200, 1, false, false));
                    challengeMob.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 1200, 2, false, false));
                });
            });
            TaskScheduler.scheduleTask(task);
        }
        TaskScheduler.scheduleTask(new TaskScheduler.ScheduledTask(1180, () -> {
            level.m_45976_(MinhSlimeEntity.class, new AABB(pos).m_82400_(20.0)).forEach(mob -> {
                if (mob.getPersistentData().m_128441_("challengeMob") && mob.getPersistentData().m_128461_("challengeMob").equals("Minh slime challenge")) {
                    mob.m_146870_();
                }
            });
            ChallengeEventHandler.getPlayerCapability(player).ifPresent(capability -> {
                if (capability.getChallengeType() == null) {
                    return;
                }
                capability.getChallengeType().setCountDone(waves);
            });
            this.completeChallenge(state, level, pos, player, false, true);
        }));
    }

    public static int getRandomInRange(int min, int max) {
        return (int)(Math.random() * (double)(max - min + 1)) + min;
    }

    public void destroyShrine(BlockState state, Level level, BlockPos pos, Player player) {
        ShrineBlockEntity shrineBlockEntity = (ShrineBlockEntity)level.m_7702_(pos);
        if (shrineBlockEntity == null) {
            return;
        }
        shrineBlockEntity.getPersistentData().m_128359_("challenge", "destroy_shrine");
        shrineBlockEntity.getPersistentData().m_128359_("player", player.m_20148_().toString());
        shrineBlockEntity.getPersistentData().m_128356_("blockPos", pos.m_121878_());
        ShrineEntity shrineEntity = new ShrineEntity((EntityType<? extends ShrineEntity>)((EntityType)BeyondEntities.BRONZE_SHRINE.get()), level, DungeonShrineTier.BRONZE);
        switch (this.tier) {
            case STELLAR: {
                shrineEntity = new ShrineEntity((EntityType<? extends ShrineEntity>)((EntityType)BeyondEntities.STELLAR_SHRINE.get()), level, DungeonShrineTier.STELLAR);
                break;
            }
            case GOLD: {
                shrineEntity = new ShrineEntity((EntityType<? extends ShrineEntity>)((EntityType)BeyondEntities.GOLD_SHRINE.get()), level, DungeonShrineTier.GOLD);
                break;
            }
            case SILVER: {
                shrineEntity = new ShrineEntity((EntityType<? extends ShrineEntity>)((EntityType)BeyondEntities.SILVER_SHRINE.get()), level, DungeonShrineTier.SILVER);
                break;
            }
        }
        shrineEntity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        shrineEntity.m_146922_(((Direction)state.m_61143_((Property)FACING)).m_122435_());
        level.m_7967_((Entity)shrineEntity);
        shrineEntity.getPersistentData().m_128359_("challengeMob", "Destroy the Shrine");
        shrineEntity.getPersistentData().m_128359_("player", player.m_20148_().toString());
        shrineEntity.getPersistentData().m_128356_("blockPos", pos.m_121878_());
        TaskScheduler.ScheduledTask task = new TaskScheduler.ScheduledTask(1200, () -> {
            AABB shrineArea;
            boolean shrineAlive;
            if (shrineBlockEntity.getPersistentData().m_128441_("challengeState") && (shrineAlive = level.m_6443_(LivingEntity.class, shrineArea = new AABB(pos).m_82400_(45.0), entity -> entity.getPersistentData().m_128441_("challengeMob") && entity.getPersistentData().m_128461_("challengeMob").equals("Destroy the Shrine")).stream().anyMatch(entity -> !entity.m_21224_())) && shrineBlockEntity.getPersistentData().m_128461_("challengeState").equals("active")) {
                this.failChallenge(level, pos, player);
            }
        });
        TaskScheduler.scheduleTask(task);
    }

    public void defeatBoss(BlockState state, Level level, BlockPos pos, Player player) {
        EntityType bossType;
        ShrineBlockEntity shrineBlockEntity = (ShrineBlockEntity)level.m_7702_(pos);
        if (shrineBlockEntity == null) {
            return;
        }
        shrineBlockEntity.getPersistentData().m_128359_("challenge", "defeat_boss");
        shrineBlockEntity.getPersistentData().m_128359_("player", player.m_20148_().toString());
        shrineBlockEntity.getPersistentData().m_128356_("blockPos", pos.m_121878_());
        if (this.tier == DungeonShrineTier.STELLAR) {
            List<EntityType> stellarBosses = List.of((EntityType)TensuraEntityTypes.SUPERMASSIVE_SLIME.get(), (EntityType)BeyondEntities.SLIME_DOLL_BOSS.get(), (EntityType)BeyondEntities.STELLAR_MIMIC_BOSS.get());
            bossType = stellarBosses.get(level.m_213780_().m_188503_(stellarBosses.size()));
        } else {
            bossType = (EntityType)TensuraEntityTypes.SUPERMASSIVE_SLIME.get();
        }
        LivingEntity bossMob = (LivingEntity)bossType.m_20615_(level);
        bossMob.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        bossMob.m_146922_(((Direction)state.m_61143_((Property)FACING)).m_122435_());
        bossMob.getPersistentData().m_128359_("challengeMob", "Defeat the Boss");
        bossMob.getPersistentData().m_128356_("blockPos", pos.m_121878_());
        bossMob.getPersistentData().m_128359_("player", player.m_20148_().toString());
        bossMob.getPersistentData().m_128379_("challengeElite", true);
        level.m_7967_((Entity)bossMob);
        if (this.tier == DungeonShrineTier.STELLAR) {
            player.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.ANTI_SKILL.get(), 3600, 0, false, false));
            player.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.SILENCE.get(), 3600, 0, false, false));
            player.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.MAGIC_INTERFERENCE.get(), 3600, 0, false, false));
        }
        TaskScheduler.ScheduledTask task = new TaskScheduler.ScheduledTask(1200, () -> {
            if (shrineBlockEntity.getPersistentData().m_128441_("challengeState")) {
                String challengeState = shrineBlockEntity.getPersistentData().m_128461_("challengeState");
                if (challengeState.equals("failed") || challengeState.equals("completed")) {
                    return;
                }
                AABB bossArea = new AABB(pos).m_82400_(45.0);
                boolean bossAlive = level.m_6443_(LivingEntity.class, bossArea, entity -> entity.getPersistentData().m_128441_("challengeMob") && entity.getPersistentData().m_128461_("challengeMob").equals("Defeat the Boss")).stream().anyMatch(entity -> !entity.m_21224_());
                if (!bossAlive && shrineBlockEntity.getPersistentData().m_128461_("challengeState").equals("active")) {
                    this.completeChallenge(state, level, pos, player, true, true);
                } else {
                    this.failChallenge(level, pos, player);
                    shrineBlockEntity.getPersistentData().m_128359_("challengeState", "failed");
                }
            }
        });
        TaskScheduler.scheduleTask(task);
    }

    public void playerWaves(BlockState state, Level level, BlockPos pos, Player player) {
        ShrineBlockEntity shrineBlockEntity = (ShrineBlockEntity)level.m_7702_(pos);
        if (shrineBlockEntity == null) {
            return;
        }
        shrineBlockEntity.getPersistentData().m_128359_("challenge", "player_waves");
        shrineBlockEntity.getPersistentData().m_128359_("player", player.m_20148_().toString());
        shrineBlockEntity.getPersistentData().m_128356_("blockPos", pos.m_121878_());
        this.finalWave = switch (this.tier) {
            case DungeonShrineTier.SILVER -> 3;
            case DungeonShrineTier.GOLD, DungeonShrineTier.STELLAR -> 5;
            default -> 1;
        };
        this.timer = level.m_46467_() - 20L;
        ChallengeType shrine_challenge = new ChallengeType("player_waves", "shrine", pos.toString(), this.finalWave, false, "minecraft:air", 0, this.finalWave * 60 + 1, false, 60);
        ChallengeEventHandler.giveChallengeType(player, shrine_challenge, true);
        this.playerWavesHelperSpawn(state, level, pos, player);
    }

    private void playerWavesHelperSpawn(BlockState state, Level level, BlockPos pos, Player player) {
        this.timer += 1200L;
        boolean failedClear = false;
        List nearbyEntities = level.m_45933_(null, new AABB(pos).m_82400_(20.0));
        for (Entity entity : nearbyEntities) {
            if (!entity.getPersistentData().m_128461_("challengeMob").equals("Survive the Waves")) continue;
            entity.m_146870_();
            failedClear = true;
        }
        if (failedClear) {
            this.failChallenge(level, pos, player);
            return;
        }
        if (this.currentWave < this.finalWave) {
            int mobCount;
            record EffectInfo(MobEffect effect, int amplification) {
            }
            WeightedRandomList randomEffects = WeightedRandomList.m_146330_((WeightedEntry[])new WeightedEntry.Wrapper[]{WeightedEntry.m_146290_((Object)new EffectInfo(MobEffects.f_19605_, this.tier.ordinal()), (int)5), WeightedEntry.m_146290_((Object)new EffectInfo(MobEffects.f_19606_, this.tier.ordinal()), (int)5), WeightedEntry.m_146290_((Object)new EffectInfo(MobEffects.f_19596_, this.tier.ordinal()), (int)5), WeightedEntry.m_146290_((Object)new EffectInfo(MobEffects.f_19600_, this.tier.ordinal()), (int)5), WeightedEntry.m_146290_((Object)new EffectInfo((MobEffect)TensuraMobEffects.BEAST_TRANSFORMATION.get(), 0), (int)1)});
            WeightedRandomList randomPenalties = WeightedRandomList.m_146330_((WeightedEntry[])new WeightedEntry.Wrapper[]{WeightedEntry.m_146290_((Object)new EffectInfo((MobEffect)TensuraMobEffects.FRAGILITY.get(), 0), (int)1), WeightedEntry.m_146290_((Object)new EffectInfo((MobEffect)TensuraMobEffects.CORROSION.get(), 0), (int)1), WeightedEntry.m_146290_((Object)new EffectInfo(MobEffects.f_19613_, 2), (int)1), WeightedEntry.m_146290_((Object)new EffectInfo(MobEffects.f_19597_, 2), (int)1), WeightedEntry.m_146290_((Object)new EffectInfo(MobEffects.f_19614_, 2), (int)1)});
            ChallengeEventHandler.getPlayerCapability(player).ifPresent(capability -> {
                if (capability.getChallengeType() == null) {
                    return;
                }
                capability.getChallengeType().setCountDone(this.currentWave);
            });
            this.mobsLeft = mobCount = ShrineBlock.getRandomInRange(4, 6) + this.tier.ordinal() * 2;
            WeightedRandomList waveTheme = (WeightedRandomList)((WeightedEntry.Wrapper)WaveThemeProvider.themesProvider(this.tier).m_216829_(level.m_213780_()).get()).m_146310_();
            for (int k = 0; k < mobCount; ++k) {
                Mob challengeMob = (Mob)((EntityType)((WeightedEntry.Wrapper)waveTheme.m_216829_(level.f_46441_).get()).m_146310_()).m_20615_(level);
                int xOffset = ShrineBlock.getRandomInRange(-5, 5);
                int zOffset = ShrineBlock.getRandomInRange(-5, 5);
                BlockPos mobPos = pos.m_7918_(xOffset, 0, zOffset);
                challengeMob.m_6034_((double)mobPos.m_123341_() + 0.5, (double)mobPos.m_123342_(), (double)mobPos.m_123343_() + 0.5);
                challengeMob.m_146922_(((Direction)state.m_61143_((Property)FACING)).m_122435_());
                int challengeCount = player.getPersistentData().m_128451_("challenges_completed");
                if (DungeonCapability.getFrom((LivingEntity)player).isPresent()) {
                    IDungeonCapability cap = (IDungeonCapability)DungeonCapability.getFrom((LivingEntity)player).resolve().get();
                    challengeCount = cap.getChallengeCompletionCount(this.tier);
                }
                if (level.m_213780_().m_188500_() < ShrineBlock.getEliteChance(challengeCount)) {
                    challengeMob.getPersistentData().m_128379_("challengeElite", true);
                }
                challengeMob.getPersistentData().m_128359_("challengeMob", "Survive the Waves");
                challengeMob.getPersistentData().m_128356_("shrinePos", pos.m_121878_());
                if (challengeMob instanceof HumanoidNPCEntity) {
                    HumanoidNPCEntity humanoidMob = (HumanoidNPCEntity)challengeMob;
                    switch (this.tier) {
                        case BRONZE: {
                            break;
                        }
                        case SILVER: {
                            if (humanoidMob.m_6844_(EquipmentSlot.MAINHAND).m_41720_() instanceof SwordItem) {
                                humanoidMob.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42388_));
                            } else if (humanoidMob.m_6844_(EquipmentSlot.MAINHAND).m_41720_() instanceof BowItem) {
                                EnchantmentHelper.m_220292_((RandomSource)level.m_213780_(), (ItemStack)humanoidMob.m_6844_(EquipmentSlot.MAINHAND), (int)10, (boolean)true);
                            }
                            humanoidMob.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)TensuraArmorItems.MONSTER_LEATHER_C_HELMET.get()));
                            humanoidMob.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)TensuraArmorItems.MONSTER_LEATHER_C_CHESTPLATE.get()));
                            humanoidMob.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)TensuraArmorItems.MONSTER_LEATHER_C_LEGGINGS.get()));
                            humanoidMob.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)TensuraArmorItems.MONSTER_LEATHER_C_BOOTS.get()));
                            break;
                        }
                        case GOLD: {
                            if (humanoidMob.m_6844_(EquipmentSlot.MAINHAND).m_41720_() instanceof SwordItem) {
                                humanoidMob.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TensuraToolItems.HIGH_MAGISTEEL_SWORD.get()));
                            } else if (humanoidMob.m_6844_(EquipmentSlot.MAINHAND).m_41720_() instanceof BowItem) {
                                humanoidMob.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TensuraToolItems.SPIDER_BOW.get()));
                            }
                            humanoidMob.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)TensuraArmorItems.HIGH_MAGISTEEL_HELMET.get()));
                            humanoidMob.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)TensuraArmorItems.HIGH_MAGISTEEL_CHESTPLATE.get()));
                            humanoidMob.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)TensuraArmorItems.HIGH_MAGISTEEL_LEGGINGS.get()));
                            humanoidMob.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)TensuraArmorItems.HIGH_MAGISTEEL_BOOTS.get()));
                            break;
                        }
                        case STELLAR: {
                            if (humanoidMob.m_6844_(EquipmentSlot.MAINHAND).m_41720_() instanceof SwordItem) {
                                humanoidMob.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TensuraToolItems.ADAMANTITE_SWORD.get()));
                            } else if (humanoidMob.m_6844_(EquipmentSlot.MAINHAND).m_41720_() instanceof BowItem) {
                                humanoidMob.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TensuraToolItems.SPIDER_BOW.get()));
                                EnchantmentHelper.m_220292_((RandomSource)level.m_213780_(), (ItemStack)humanoidMob.m_6844_(EquipmentSlot.MAINHAND), (int)30, (boolean)true);
                            }
                            humanoidMob.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)TensuraArmorItems.MITHRIL_HELMET.get()));
                            humanoidMob.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)TensuraArmorItems.MITHRIL_CHESTPLATE.get()));
                            humanoidMob.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)TensuraArmorItems.MITHRIL_LEGGINGS.get()));
                            humanoidMob.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)TensuraArmorItems.MITHRIL_BOOTS.get()));
                        }
                    }
                }
                level.m_7967_((Entity)challengeMob);
                challengeMob.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 100, 0, false, false));
                challengeMob.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get(), 1200, 9, false, false));
                if (this.tier == DungeonShrineTier.GOLD || this.tier == DungeonShrineTier.STELLAR) {
                    EffectInfo randomEffect = (EffectInfo)((WeightedEntry.Wrapper)randomEffects.m_216829_(level.m_213780_()).get()).m_146310_();
                    challengeMob.m_7292_(new MobEffectInstance(randomEffect.effect, 1200, randomEffect.amplification));
                    int absorptionAmp = this.tier == DungeonShrineTier.STELLAR ? 4 : 14;
                    challengeMob.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 1200, absorptionAmp));
                }
                challengeMob.m_6710_((LivingEntity)player);
            }
            if (this.tier == DungeonShrineTier.STELLAR) {
                EffectInfo randomPenalty = (EffectInfo)((WeightedEntry.Wrapper)randomPenalties.m_216829_(level.m_213780_()).get()).m_146310_();
                player.m_7292_(new MobEffectInstance(randomPenalty.effect, 300, randomPenalty.amplification));
            }
            ++this.currentWave;
        } else {
            if (player.m_9236_() != level) {
                this.failChallenge(level, pos, player);
                return;
            }
            if (player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) > Math.pow(15.0, 2.0)) {
                this.failChallenge(level, pos, player);
                return;
            }
            this.completeChallenge(state, level, pos, player, true, true);
        }
    }

    public void mobKilled() {
        --this.mobsLeft;
    }

    private static double getEliteChance(int challengeCount) {
        double eliteChance = 0.0;
        if (challengeCount >= 20) {
            eliteChance = 0.95;
        } else if (challengeCount >= 10) {
            eliteChance = 0.5;
        } else if (challengeCount >= 6) {
            eliteChance = 0.25;
        } else if (challengeCount >= 5) {
            eliteChance = 0.15;
        } else if (challengeCount >= 3) {
            eliteChance = 0.1;
        } else if (challengeCount >= 2) {
            eliteChance = 0.05;
        }
        return eliteChance;
    }

    public void waveSurvival(BlockState state, Level level, BlockPos pos, Player player) {
        ShrineBlockEntity shrineBlockEntity = (ShrineBlockEntity)level.m_7702_(pos);
        if (shrineBlockEntity == null) {
            return;
        }
        shrineBlockEntity.getPersistentData().m_128359_("challenge", "waves");
        shrineBlockEntity.getPersistentData().m_128359_("player", player.m_20148_().toString());
        shrineBlockEntity.getPersistentData().m_128356_("blockPos", pos.m_121878_());
        ShrineEntity shrineEntity = new ShrineEntity((EntityType<? extends ShrineEntity>)((EntityType)BeyondEntities.BRONZE_SHRINE.get()), level, DungeonShrineTier.BRONZE);
        switch (this.tier) {
            case STELLAR: {
                shrineEntity = new ShrineEntity((EntityType<? extends ShrineEntity>)((EntityType)BeyondEntities.STELLAR_SHRINE.get()), level, DungeonShrineTier.STELLAR);
                break;
            }
            case GOLD: {
                shrineEntity = new ShrineEntity((EntityType<? extends ShrineEntity>)((EntityType)BeyondEntities.GOLD_SHRINE.get()), level, DungeonShrineTier.GOLD);
                break;
            }
            case SILVER: {
                shrineEntity = new ShrineEntity((EntityType<? extends ShrineEntity>)((EntityType)BeyondEntities.SILVER_SHRINE.get()), level, DungeonShrineTier.SILVER);
                break;
            }
        }
        shrineEntity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        shrineEntity.m_146922_(((Direction)state.m_61143_((Property)FACING)).m_122435_());
        level.m_7967_((Entity)shrineEntity);
        shrineEntity.getPersistentData().m_128359_("challenge", "Protect the Shrine");
        shrineEntity.getPersistentData().m_128359_("challengeMob", "Protect the Shrine");
        shrineEntity.getPersistentData().m_128359_("player", player.m_20148_().toString());
        shrineEntity.getPersistentData().m_128356_("blockPos", pos.m_121878_());
        int spawnTime = 200;
        if (this.tier == DungeonShrineTier.BRONZE) {
            spawnTime = 400;
        } else if (this.tier == DungeonShrineTier.SILVER) {
            spawnTime = 300;
        } else if (this.tier == DungeonShrineTier.STELLAR) {
            spawnTime = 100;
        }
        int waves = 3600 / spawnTime;
        ChallengeType shrine_challenge = new ChallengeType("waves", "shrine", pos.toString(), waves, false, "minecraft:air", 0, 180, false, spawnTime / 20);
        ChallengeEventHandler.giveChallengeType(player, shrine_challenge, true);
        for (int j = 1; j < waves + 1; ++j) {
            int waveCount = j;
            TaskScheduler.ScheduledTask task = new TaskScheduler.ScheduledTask(spawnTime * j, () -> {
                double dz;
                double dy;
                String challengeState;
                if (shrineBlockEntity.getPersistentData().m_128441_("challengeState") && ((challengeState = shrineBlockEntity.getPersistentData().m_128461_("challengeState")).equals("failed") || challengeState.equals("completed"))) {
                    return;
                }
                double dx = (double)pos.m_123341_() + 0.5 - player.m_20185_();
                double distance = Math.sqrt(dx * dx + (dy = (double)pos.m_123342_() + 0.5 - player.m_20186_()) * dy + (dz = (double)pos.m_123343_() + 0.5 - player.m_20189_()) * dz);
                if (distance > 25.0) {
                    this.failChallenge(level, pos, player);
                    return;
                }
                shrineBlockEntity.getPersistentData().m_128405_("wave", waveCount);
                ChallengeEventHandler.getPlayerCapability(player).ifPresent(capability -> {
                    if (capability.getChallengeType() == null) {
                        return;
                    }
                    capability.getChallengeType().setCountDone(waveCount);
                    if (waveCount < waves) {
                        int mobCount = 1;
                        if (this.tier == DungeonShrineTier.BRONZE) {
                            mobCount = ShrineBlock.getRandomInRange(1, 3);
                        } else if (this.tier == DungeonShrineTier.SILVER) {
                            mobCount = ShrineBlock.getRandomInRange(3, 4);
                        } else if (this.tier == DungeonShrineTier.GOLD) {
                            mobCount = ShrineBlock.getRandomInRange(4, 5);
                        } else if (this.tier == DungeonShrineTier.STELLAR) {
                            mobCount = ShrineBlock.getRandomInRange(5, 6);
                        }
                        for (int i = 0; i < mobCount; ++i) {
                            LivingEntity challengeMobTarget;
                            LeechLizardEntity challengeMob = switch (ShrineBlock.getRandomInRange(0, 6) + (this.tier == DungeonShrineTier.STELLAR ? ShrineBlock.getRandomInRange(1, 4) : 0)) {
                                case 0, 1, 2 -> new LeechLizardEntity((EntityType)TensuraEntityTypes.LEECH_LIZARD.get(), level);
                                case 3, 4 -> new HoundDogEntity((EntityType)TensuraEntityTypes.HOUND_DOG.get(), level);
                                case 5, 6 -> new BarghestEntity((EntityType)TensuraEntityTypes.BARGHEST.get(), level);
                                case 7, 8 -> new DirewolfEntity((EntityType)TensuraEntityTypes.DIREWOLF.get(), level);
                                case 9 -> new GiantAntEntity((EntityType)TensuraEntityTypes.GIANT_ANT.get(), level);
                                default -> new GiantBatEntity((EntityType)TensuraEntityTypes.GIANT_BAT.get(), level);
                            };
                            int xOffset = ShrineBlock.getRandomInRange(-6, 6);
                            int zOffset = ShrineBlock.getRandomInRange(-6, 6);
                            BlockPos mobPos = pos.m_7918_(xOffset, 0, zOffset);
                            challengeMob.m_6034_((double)mobPos.m_123341_() + 0.5, (double)mobPos.m_123342_(), (double)mobPos.m_123343_() + 0.5);
                            challengeMob.m_146922_(((Direction)state.m_61143_((Property)FACING)).m_122435_());
                            challengeMob.getPersistentData().m_128359_("challengeMob", "Protect the Shrine");
                            int challengeCount = 0;
                            if (DungeonCapability.getFrom((LivingEntity)player).isPresent()) {
                                IDungeonCapability cap = (IDungeonCapability)DungeonCapability.getFrom((LivingEntity)player).resolve().get();
                                challengeCount = cap.getChallengeCompletionCount(this.tier);
                            }
                            if (level.m_213780_().m_188500_() < ShrineBlock.getEliteChance(challengeCount)) {
                                challengeMob.getPersistentData().m_128379_("challengeElite", true);
                            }
                            level.m_7967_((Entity)challengeMob);
                            if (this.tier == DungeonShrineTier.GOLD) {
                                if (Math.random() < 0.05) {
                                    challengeMob.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 6000, ShrineBlock.getRandomInRange(1, 2), false, false));
                                }
                                if (Math.random() < 0.1) {
                                    challengeMob.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 6000, 0, false, false));
                                    challengeMob.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PRESENCE_CONCEALMENT.get(), 6000, 3));
                                }
                                if (Math.random() < 0.25) {
                                    challengeMob.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 6000, ShrineBlock.getRandomInRange(1, 3), false, false));
                                }
                            } else if (this.tier == DungeonShrineTier.STELLAR) {
                                if (Math.random() < 0.1) {
                                    challengeMob.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 6000, ShrineBlock.getRandomInRange(1, 3), false, false));
                                }
                                if (Math.random() < 0.2) {
                                    challengeMob.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 6000, 0, false, false));
                                    challengeMob.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PRESENCE_CONCEALMENT.get(), 6000, 3, false, false));
                                }
                                if (Math.random() < 0.5) {
                                    challengeMob.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 6000, ShrineBlock.getRandomInRange(1, 4), false, false));
                                }
                            }
                            if ((challengeMobTarget = level.m_45982_(level.m_45976_(ShrineEntity.class, new AABB(mobPos).m_82400_(10.0)), TargetingConditions.m_148352_(), (LivingEntity)challengeMob, (double)mobPos.m_123341_() + 0.5, (double)mobPos.m_123342_(), (double)mobPos.m_123343_() + 0.5)) == null) continue;
                            level.m_45976_(Mob.class, new AABB(pos).m_82400_(10.0)).forEach(mob -> {
                                if (mob.getPersistentData().m_128441_("challengeMob") && mob.getPersistentData().m_128461_("challengeMob").equals("Protect the Shrine")) {
                                    mob.m_6710_(challengeMobTarget);
                                }
                            });
                        }
                    } else {
                        String challengeState;
                        if (shrineBlockEntity.getPersistentData().m_128441_("challengeState") && (challengeState = shrineBlockEntity.getPersistentData().m_128461_("challengeState")).equals("failed")) {
                            return;
                        }
                        this.completeChallenge(state, level, pos, player, true, true);
                    }
                });
            });
            TaskScheduler.scheduleTask(task);
        }
    }

    public long getPackedTime() {
        long time = System.currentTimeMillis() / 1000L;
        return time / 60L;
    }

    public void setCooldown(Level level, BlockPos pos, UUID player) {
        if (!this.challengeCausesCooldown) {
            this.challengeCausesCooldown = true;
            return;
        }
        DungeonSaveData.getOverworld(level).setShrineCooldown(player, pos, this.getPackedTime());
    }

    public void failChallenge(Level level, BlockPos pos, Player player) {
        boolean cooldownRun;
        ShrineBlockEntity shrineBlockEntity = (ShrineBlockEntity)level.m_7702_(pos);
        if (shrineBlockEntity == null) {
            return;
        }
        boolean bl = cooldownRun = !DungeonSaveData.getOverworld(level).canUseShrine(player, pos, this.getPackedTime(), level);
        if (!cooldownRun) {
            this.setCooldown(level, pos, player.m_20148_());
        }
        shrineBlockEntity.getPersistentData().m_128359_("challengeState", "failed");
        player.getPersistentData().m_128473_("shrineTier");
        level.m_45976_(Mob.class, new AABB(pos).m_82400_(32.0)).forEach(mob -> {
            if (mob.getPersistentData().m_128441_("challengeMob")) {
                mob.m_146870_();
            }
        });
        player.m_213846_((Component)Component.m_237115_((String)"trbeyond.message.shrine.challenge_failed"));
        ChallengeEventHandler.getPlayerCapability(player).ifPresent(capability -> {
            if (capability.getChallengeType() == null) {
                return;
            }
            player.getPersistentData().m_128405_("challenge_time", capability.getChallengeType().getTimeLimit());
        });
        if (this.dontDecrementNextFailure || cooldownRun) {
            this.dontDecrementNextFailure = false;
            return;
        }
        DungeonCapability.getFrom((LivingEntity)player).ifPresent(cap -> {
            int penalty = (Integer)ServerConfig.INSTANCE.dungeonConfig.shrineFailPenalty.get();
            cap.setChallengeCompletionCount(this.tier, Math.max(cap.getChallengeCompletionCount(this.tier) - penalty, 0));
        });
    }

    public void completeChallenge(BlockState state, Level level, BlockPos pos, Player player, boolean incrementCompletions, boolean spawnChests) {
        boolean cooldownRun;
        ShrineBlockEntity shrineBlockEntity = (ShrineBlockEntity)level.m_7702_(pos);
        this.dontDecrementNextFailure = false;
        boolean bl = cooldownRun = !DungeonSaveData.getOverworld(level).canUseShrine(player, pos, this.getPackedTime(), level);
        if (shrineBlockEntity != null) {
            shrineBlockEntity.getPersistentData().m_128359_("challengeState", "completed");
            player.getPersistentData().m_128473_("shrineTier");
            level.m_45976_(Mob.class, new AABB(pos).m_82400_(32.0)).forEach(mob -> {
                if (mob.getPersistentData().m_128441_("challengeMob")) {
                    mob.m_146870_();
                }
            });
            ChallengeEventHandler.getPlayerCapability(player).ifPresent(capability -> {
                if (capability.getChallengeType() != null) {
                    capability.getChallengeType().setCountDone(capability.getChallengeType().getCount());
                }
            });
            int completedChallenges = 0;
            if (DungeonCapability.getFrom((LivingEntity)player).isPresent()) {
                IDungeonCapability cap = (IDungeonCapability)DungeonCapability.getFrom((LivingEntity)player).resolve().get();
                completedChallenges = cap.getChallengeCompletionCount(this.tier);
                if (incrementCompletions && !cooldownRun) {
                    cap.setChallengeCompletionCount(this.tier, completedChallenges + 1);
                }
            }
            List<BlockPos> chestPositions = List.of(pos.m_5484_((Direction)state.m_61143_((Property)FACING), 2), pos.m_5484_((Direction)state.m_61143_((Property)FACING), 2).m_5484_(((Direction)state.m_61143_((Property)FACING)).m_122427_(), 3), pos.m_5484_((Direction)state.m_61143_((Property)FACING), 2).m_5484_(((Direction)state.m_61143_((Property)FACING)).m_122428_(), 3));
            player.m_213846_((Component)Component.m_237115_((String)"trbeyond.message.shrine.challenge_completed"));
            if (spawnChests && !cooldownRun) {
                Block chestBlock;
                this.setCooldown(level, pos, player.m_20148_());
                player.m_213846_((Component)Component.m_237115_((String)"trbeyond.message.shrine.challenge_completed.chests"));
                switch (this.tier) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case BRONZE: {
                        Block block = (Block)BeyondBlocks.BRONZE_CHEST.get();
                        break;
                    }
                    case SILVER: {
                        Block block = (Block)BeyondBlocks.SILVER_CHEST.get();
                        break;
                    }
                    case GOLD: {
                        Block block = (Block)BeyondBlocks.GOLD_CHEST.get();
                        break;
                    }
                    case STELLAR: {
                        Block block = chestBlock = (Block)BeyondBlocks.STELLAR_CHEST.get();
                    }
                }
                int chestCount = completedChallenges >= 20 ? 3 : (completedChallenges >= 10 ? 2 : 1);
                float coinDoubleChance = switch (completedChallenges) {
                    case 0 -> 0.0f;
                    case 1 -> 0.05f;
                    case 2 -> 0.1f;
                    default -> 0.15f;
                };
                for (int i = 0; i < chestCount; ++i) {
                    BlockPos chestPos = chestPositions.get(i);
                    level.m_7731_(chestPos, chestBlock.m_49966_(), 3);
                    DungeonChestBlock dun = (DungeonChestBlock)level.m_8055_(chestPos).m_60734_();
                    BlockPos chestPos2 = chestPos.m_121945_(DungeonChestBlock.getConnectedDirection(level.m_8055_(chestPos)));
                    level.m_7731_(chestPos2, (BlockState)dun.m_49966_().m_61124_(DungeonChestBlock.TYPE, (Comparable)((ChestType)level.m_8055_(chestPos).m_61143_(DungeonChestBlock.TYPE)).m_61486_()), 3);
                    level.m_8055_(chestPos).m_60701_((LevelAccessor)level, chestPos, 3);
                    BlockEntity blockEntity = level.m_7702_(chestPos);
                    if (blockEntity instanceof DungeonChestBlockEntity) {
                        DungeonChestBlockEntity chest = (DungeonChestBlockEntity)blockEntity;
                        chest.getPersistentData().m_128379_("noLock", true);
                        chest.getPersistentData().m_128356_("placedTime", level.m_46467_());
                    }
                    DungeonSaveData.getOverworld(level).addBossChest(chestPos);
                    for (int p = 1; p < 2; ++p) {
                        BlockEntity blockEntity2 = level.m_7702_(chestPos2);
                        if (!(blockEntity2 instanceof DungeonChestBlockEntity)) continue;
                        DungeonChestBlockEntity chest = (DungeonChestBlockEntity)blockEntity2;
                        String lootTable = switch (this.tier) {
                            default -> throw new IncompatibleClassChangeError();
                            case DungeonShrineTier.BRONZE -> "shrines/shrine_bronze_1";
                            case DungeonShrineTier.SILVER -> "shrines/shrine_silver_1";
                            case DungeonShrineTier.GOLD -> "shrines/shrine_gold_1";
                            case DungeonShrineTier.STELLAR -> "shrines/shrine_stellar_1";
                        };
                        chest.m_59626_(new ResourceLocation("trbeyond", lootTable), level.m_213780_().m_188505_());
                        chest.m_59640_(player);
                        chest.m_6596_();
                        if (p != 1) continue;
                        chest.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
                            for (int j = 0; j < h.getSlots(); ++j) {
                                ItemStack stack = h.getStackInSlot(j);
                                if (!stack.m_41619_() && (stack.m_41720_() instanceof TensuraSword || stack.m_41720_() instanceof GeoArmorItem || stack.m_41720_() instanceof SimpleArmorItem || stack.m_41720_() instanceof SimpleSwordItem || stack.m_41720_() instanceof SimpleBowItem) && Math.random() < 0.5) {
                                    stack = h.extractItem(j, 1, false);
                                    EngravingEnchantment.randomEngraving((LivingEntity)player, (ItemStack)stack, (double)((Integer)TensuraConfig.INSTANCE.enchantmentsConfig.unique.get()).intValue());
                                    h.insertItem(j, stack, false);
                                }
                                if (!(Math.random() < (double)coinDoubleChance) || !stack.m_150930_((Item)TensuraMaterialItems.BRONZE_COIN.get()) && !stack.m_150930_((Item)TensuraMaterialItems.SILVER_COIN.get()) && !stack.m_150930_((Item)TensuraMaterialItems.GOLD_COIN.get()) && !stack.m_150930_((Item)TensuraMaterialItems.STELLAR_GOLD_COIN.get())) continue;
                                stack.m_41764_(Math.min(64, stack.m_41613_() * 2));
                            }
                        });
                    }
                }
            }
        }
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction direction = pContext.m_8125_().m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockBlockStateBuilder) {
        blockBlockStateBuilder.m_61104_(new Property[]{FACING});
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation direction) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState blockState, LevelAccessor level, BlockPos pos, Mirror mirror) {
        return blockState.rotate(level, pos, mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING)));
    }

    @NotNull
    public RenderShape getRenderShape() {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new ShrineBlockEntity(pPos, pState);
    }

    public DungeonShrineTier getTier() {
        return this.tier;
    }

    public static enum DungeonShrineTier {
        BRONZE,
        SILVER,
        GOLD,
        STELLAR;

    }

    public static class WaveThemeProvider {
        public static final WeightedRandomList<WeightedEntry.Wrapper<WeightedRandomList<WeightedEntry.Wrapper<EntityType<? extends Mob>>>>> bronzeWaveList;
        public static final WeightedRandomList<WeightedEntry.Wrapper<WeightedRandomList<WeightedEntry.Wrapper<EntityType<? extends Mob>>>>> silverWaveList;
        public static final WeightedRandomList<WeightedEntry.Wrapper<WeightedRandomList<WeightedEntry.Wrapper<EntityType<? extends Mob>>>>> goldWaveList;
        public static final WeightedRandomList<WeightedEntry.Wrapper<WeightedRandomList<WeightedEntry.Wrapper<EntityType<? extends Mob>>>>> stellarWaveList;

        public static WeightedRandomList<WeightedEntry.Wrapper<WeightedRandomList<WeightedEntry.Wrapper<EntityType<? extends Mob>>>>> themesProvider(DungeonShrineTier tier) {
            return switch (tier) {
                case DungeonShrineTier.BRONZE -> bronzeWaveList;
                case DungeonShrineTier.SILVER -> silverWaveList;
                case DungeonShrineTier.GOLD -> goldWaveList;
                case DungeonShrineTier.STELLAR -> stellarWaveList;
                default -> null;
            };
        }

        static {
            WeightedRandomList allianceTheme = WeightedRandomList.m_146330_((WeightedEntry[])new WeightedEntry.Wrapper[]{WeightedEntry.m_146290_((Object)((EntityType)TensuraEntityTypes.GOBLIN.get()), (int)1), WeightedEntry.m_146290_((Object)((EntityType)TensuraEntityTypes.ORC.get()), (int)1), WeightedEntry.m_146290_((Object)((EntityType)TensuraEntityTypes.LIZARDMAN.get()), (int)1), WeightedEntry.m_146290_((Object)((EntityType)TensuraEntityTypes.DIREWOLF.get()), (int)1)});
            WeightedRandomList bearTheme = WeightedRandomList.m_146330_((WeightedEntry[])new WeightedEntry.Wrapper[]{WeightedEntry.m_146290_((Object)((EntityType)TensuraEntityTypes.GIANT_BEAR.get()), (int)1), WeightedEntry.m_146290_((Object)((EntityType)TensuraEntityTypes.HORNED_BEAR.get()), (int)1)});
            WeightedRandomList reptileTheme = WeightedRandomList.m_146330_((WeightedEntry[])new WeightedEntry.Wrapper[]{WeightedEntry.m_146290_((Object)((EntityType)TensuraEntityTypes.HOVER_LIZARD.get()), (int)3), WeightedEntry.m_146290_((Object)((EntityType)TensuraEntityTypes.ARMOURSAURUS.get()), (int)1), WeightedEntry.m_146290_((Object)((EntityType)TensuraEntityTypes.LEECH_LIZARD.get()), (int)3)});
            WeightedRandomList slimeTheme = WeightedRandomList.m_146330_((WeightedEntry[])new WeightedEntry.Wrapper[]{WeightedEntry.m_146290_((Object)((EntityType)TensuraEntityTypes.SLIME.get()), (int)10), WeightedEntry.m_146290_((Object)((EntityType)TensuraEntityTypes.METAL_SLIME.get()), (int)1), WeightedEntry.m_146290_((Object)((EntityType)BeyondEntities.BLUE_SLIME_DOLL.get()), (int)1), WeightedEntry.m_146290_((Object)((EntityType)BeyondEntities.GREEN_SLIME_DOLL.get()), (int)1), WeightedEntry.m_146290_((Object)((EntityType)BeyondEntities.RED_SLIME_DOLL.get()), (int)1), WeightedEntry.m_146290_((Object)((EntityType)BeyondEntities.YELLOW_SLIME_DOLL.get()), (int)1)});
            WeightedRandomList basicSlimeTheme = WeightedRandomList.m_146330_((WeightedEntry[])new WeightedEntry.Wrapper[]{WeightedEntry.m_146290_((Object)((EntityType)TensuraEntityTypes.SLIME.get()), (int)1)});
            WeightedRandomList spiritTheme = WeightedRandomList.m_146330_((WeightedEntry[])new WeightedEntry.Wrapper[]{WeightedEntry.m_146290_((Object)((EntityType)TensuraEntityTypes.AQUA_FROG.get()), (int)1), WeightedEntry.m_146290_((Object)((EntityType)TensuraEntityTypes.BEAST_GNOME.get()), (int)1), WeightedEntry.m_146290_((Object)((EntityType)TensuraEntityTypes.FEATHERED_SERPENT.get()), (int)1), WeightedEntry.m_146290_((Object)((EntityType)TensuraEntityTypes.SALAMANDER.get()), (int)1), WeightedEntry.m_146290_((Object)((EntityType)TensuraEntityTypes.WINGED_CAT.get()), (int)1)});
            WeightedRandomList wolfTheme = WeightedRandomList.m_146330_((WeightedEntry[])new WeightedEntry.Wrapper[]{WeightedEntry.m_146290_((Object)((EntityType)TensuraEntityTypes.BARGHEST.get()), (int)1), WeightedEntry.m_146290_((Object)((EntityType)TensuraEntityTypes.DIREWOLF.get()), (int)1), WeightedEntry.m_146290_((Object)((EntityType)TensuraEntityTypes.HOUND_DOG.get()), (int)1)});
            WeightedRandomList vanillaTheme = WeightedRandomList.m_146330_((WeightedEntry[])new WeightedEntry.Wrapper[]{WeightedEntry.m_146290_((Object)EntityType.f_20501_, (int)1), WeightedEntry.m_146290_((Object)EntityType.f_20524_, (int)1), WeightedEntry.m_146290_((Object)EntityType.f_20458_, (int)1), WeightedEntry.m_146290_((Object)EntityType.f_20481_, (int)1), WeightedEntry.m_146290_((Object)EntityType.f_20479_, (int)1), WeightedEntry.m_146290_((Object)EntityType.f_20554_, (int)1)});
            WeightedRandomList pillagerTheme = WeightedRandomList.m_146330_((WeightedEntry[])new WeightedEntry.Wrapper[]{WeightedEntry.m_146290_((Object)EntityType.f_20513_, (int)10), WeightedEntry.m_146290_((Object)EntityType.f_20493_, (int)5), WeightedEntry.m_146290_((Object)EntityType.f_20495_, (int)3), WeightedEntry.m_146290_((Object)EntityType.f_20491_, (int)3), WeightedEntry.m_146290_((Object)EntityType.f_20518_, (int)1), WeightedEntry.m_146290_((Object)EntityType.f_20459_, (int)1), WeightedEntry.m_146290_((Object)EntityType.f_20568_, (int)1)});
            WeightedRandomList netherTheme = WeightedRandomList.m_146330_((WeightedEntry[])new WeightedEntry.Wrapper[]{WeightedEntry.m_146290_((Object)EntityType.f_20497_, (int)1), WeightedEntry.m_146290_((Object)EntityType.f_20551_, (int)1), WeightedEntry.m_146290_((Object)EntityType.f_20468_, (int)1)});
            WeightedRandomList endTheme = WeightedRandomList.m_146330_((WeightedEntry[])new WeightedEntry.Wrapper[]{WeightedEntry.m_146290_((Object)EntityType.f_20566_, (int)5), WeightedEntry.m_146290_((Object)EntityType.f_20521_, (int)1)});
            WeightedRandomList golemTheme = WeightedRandomList.m_146330_((WeightedEntry[])new WeightedEntry.Wrapper[]{WeightedEntry.m_146290_((Object)EntityType.f_20460_, (int)1)});
            bronzeWaveList = WeightedRandomList.m_146330_((WeightedEntry[])new WeightedEntry.Wrapper[]{WeightedEntry.m_146290_((Object)allianceTheme, (int)1), WeightedEntry.m_146290_((Object)vanillaTheme, (int)1), WeightedEntry.m_146290_((Object)netherTheme, (int)1), WeightedEntry.m_146290_((Object)reptileTheme, (int)1), WeightedEntry.m_146290_((Object)basicSlimeTheme, (int)1), WeightedEntry.m_146290_((Object)wolfTheme, (int)1)});
            silverWaveList = WeightedRandomList.m_146330_((WeightedEntry[])new WeightedEntry.Wrapper[]{WeightedEntry.m_146290_((Object)allianceTheme, (int)1), WeightedEntry.m_146290_((Object)golemTheme, (int)1), WeightedEntry.m_146290_((Object)pillagerTheme, (int)1), WeightedEntry.m_146290_((Object)endTheme, (int)1), WeightedEntry.m_146290_((Object)reptileTheme, (int)1), WeightedEntry.m_146290_((Object)wolfTheme, (int)1)});
            goldWaveList = WeightedRandomList.m_146330_((WeightedEntry[])new WeightedEntry.Wrapper[]{WeightedEntry.m_146290_((Object)allianceTheme, (int)1), WeightedEntry.m_146290_((Object)reptileTheme, (int)1), WeightedEntry.m_146290_((Object)slimeTheme, (int)1), WeightedEntry.m_146290_((Object)wolfTheme, (int)1), WeightedEntry.m_146290_((Object)bearTheme, (int)1)});
            stellarWaveList = WeightedRandomList.m_146330_((WeightedEntry[])new WeightedEntry.Wrapper[]{WeightedEntry.m_146290_((Object)allianceTheme, (int)3), WeightedEntry.m_146290_((Object)reptileTheme, (int)3), WeightedEntry.m_146290_((Object)slimeTheme, (int)3), WeightedEntry.m_146290_((Object)wolfTheme, (int)3), WeightedEntry.m_146290_((Object)bearTheme, (int)3), WeightedEntry.m_146290_((Object)spiritTheme, (int)1)});
        }
    }
}

