/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.block.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import io.github.Memoires.trbeyond.block.DungeonChestBlock;
import io.github.Memoires.trbeyond.block.entity.DungeonChestBlockEntity;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public abstract class DungeonChestRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private final ResourceLocation BLANK = new ResourceLocation("tensura", "textures/blank_texture.png");
    protected ModelPart lid;
    protected ModelPart bottom;
    protected ModelPart lock;

    public boolean m_5932_(T pBlockEntity) {
        return true;
    }

    public void m_6922_(T tileEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLightIn, int combinedOverlayIn) {
        DungeonChestBlockEntity tileEntity = (DungeonChestBlockEntity)((Object)tileEntityIn);
        Level level = tileEntity.m_58904_();
        BlockState blockState = tileEntity.m_58900_();
        Block block = blockState.m_60734_();
        if (block instanceof DungeonChestBlock) {
            DungeonChestBlock abstractChestBlock = (DungeonChestBlock)block;
            poseStack.m_85836_();
            Direction direction = (Direction)blockState.m_61143_((Property)DungeonChestBlock.FACING);
            float f = direction.m_122435_();
            switch (direction) {
                case NORTH: {
                    poseStack.m_85837_(0.5 - this.getTranslateOffset(blockState), 0.0, 0.5);
                    break;
                }
                case SOUTH: {
                    poseStack.m_85837_(-0.5 + this.getTranslateOffset(blockState), 0.0, -0.5);
                    break;
                }
                case WEST: {
                    poseStack.m_85837_(0.5, 0.0, -0.5 + this.getTranslateOffset(blockState));
                    break;
                }
                case EAST: {
                    poseStack.m_85837_(-0.5, 0.0, 0.5 - this.getTranslateOffset(blockState));
                }
            }
            poseStack.m_85837_(0.5, -0.5, 0.5);
            poseStack.m_85845_(Vector3f.f_122224_.m_122240_(f));
            poseStack.m_85845_(Vector3f.f_122226_.m_122240_(180.0f));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            poseStack.m_85837_(-0.5, -0.5, -0.5);
            DoubleBlockCombiner.NeighborCombineResult<? extends DungeonChestBlockEntity> neighborCombineResult = abstractChestBlock.combine(blockState, level, tileEntityIn.m_58899_(), true);
            float openness = ((Float2FloatFunction)neighborCombineResult.m_5649_(DungeonChestBlock.opennessCombiner(tileEntity))).get(partialTicks);
            openness = 1.0f - openness;
            openness = 1.0f - openness * openness * openness;
            int brightness = ((Int2IntFunction)neighborCombineResult.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(combinedLightIn);
            ResourceLocation location = blockState.m_61143_(DungeonChestBlock.TYPE) != ChestType.LEFT ? this.BLANK : this.getTexture();
            RenderType cameo = RenderType.m_110452_((ResourceLocation)location);
            this.render(poseStack, bufferSource.m_6299_(cameo), this.lid, this.lock, this.bottom, openness, brightness, combinedOverlayIn);
            poseStack.m_85849_();
        }
    }

    private double getTranslateOffset(BlockState blockState) {
        return blockState.m_61143_(DungeonChestBlock.TYPE) != ChestType.LEFT ? 1.0 : 0.0;
    }

    protected abstract ResourceLocation getTexture();

    private void render(PoseStack poseStack, VertexConsumer vertexConsumer, ModelPart lid, ModelPart lock, ModelPart bottom, float openness, int brightness, int combinedOverlayIn) {
        lock.f_104203_ = lid.f_104203_ = -(openness * 1.5707964f);
        lid.m_104301_(poseStack, vertexConsumer, brightness, combinedOverlayIn);
        lock.m_104301_(poseStack, vertexConsumer, brightness, combinedOverlayIn);
        bottom.m_104301_(poseStack, vertexConsumer, brightness, combinedOverlayIn);
    }

    public boolean m_142756_(T tileEntity, Vec3 pCameraPos) {
        if (super.m_142756_(tileEntity, pCameraPos)) {
            return true;
        }
        BlockPos pos = tileEntity.m_58899_().m_121945_(DungeonChestBlock.getConnectedDirection(tileEntity.m_58900_()));
        return Vec3.m_82512_((Vec3i)pos).m_82509_((Position)pCameraPos, (double)this.m_142163_());
    }
}

