/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.block.client;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.Memoires.trbeyond.block.ThreadBlock;
import io.github.Memoires.trbeyond.block.entity.IllusionaryBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class IllusionaryBlockRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    protected final BlockRenderDispatcher blockRenderer;
    private static final Class<? extends Block> STEEL_THREADS_BLOCK = ThreadBlock.class;

    public IllusionaryBlockRenderer(BlockEntityRendererProvider.Context context) {
        this.blockRenderer = context.m_173584_();
    }

    public void m_6922_(T blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLightIn, int combinedOverlayIn) {
        Level level = blockEntity.m_58904_();
        if (level == null) {
            return;
        }
        BlockPos blockPos = blockEntity.m_58899_();
        BlockPos copyPos = this.findCopyPos(level, blockPos, Direction.DOWN);
        if (copyPos == null) {
            copyPos = this.findCopyPos(level, blockPos, Direction.UP);
        }
        if (copyPos == null) {
            for (Direction direction : Direction.values()) {
                if (direction.m_122434_() != Direction.Axis.Y && (copyPos = this.findCopyPos(level, blockPos, direction)) != null) break;
            }
        }
        if (copyPos == null) {
            return;
        }
        BlockState copyState = level.m_8055_(copyPos);
        if (copyState.m_60734_().getClass() == STEEL_THREADS_BLOCK) {
            return;
        }
        poseStack.m_85836_();
        this.blockRenderer.m_234355_(copyState, blockPos, (BlockAndTintGetter)level, poseStack, bufferSource.m_6299_(RenderType.m_110466_()), false, level.m_213780_());
        poseStack.m_85849_();
    }

    private BlockPos findCopyPos(Level level, BlockPos pos, Direction direction) {
        BlockPos illusionaryPos = pos.m_121945_(direction);
        if (level.m_8055_(illusionaryPos).m_60795_()) {
            return null;
        }
        while (level.m_7702_(illusionaryPos) instanceof IllusionaryBlockEntity) {
            illusionaryPos = illusionaryPos.m_121945_(direction);
        }
        BlockState targetState = level.m_8055_(illusionaryPos);
        if (targetState.m_60795_() || targetState.m_60734_().getClass() == STEEL_THREADS_BLOCK) {
            return null;
        }
        return illusionaryPos;
    }
}

