/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.block.entity;

import io.github.Memoires.trbeyond.block.DungeonChestBlock;
import io.github.Memoires.trbeyond.config.ServerConfig;
import io.github.Memoires.trbeyond.network.worldgen.DungeonSaveData;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class DungeonChestBlockEntity
extends RandomizableContainerBlockEntity
implements LidBlockEntity {
    public NonNullList<ItemStack> items;
    private final ContainerOpenersCounter openersCounter;
    private final ChestLidController chestLidController;
    private long placedTime = -1L;
    public final Set<UUID> playersWithGeneratedLoot = new HashSet<UUID>();
    private ResourceLocation lootTable;

    public DungeonChestBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
        this.items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
        this.openersCounter = this.createOpenersCounter();
        this.chestLidController = new ChestLidController();
    }

    private ContainerOpenersCounter createOpenersCounter() {
        return new ContainerOpenersCounter(){

            protected void m_142292_(Level level, BlockPos pos, BlockState blockState) {
                DungeonChestBlockEntity.playSound(level, pos, blockState, SoundEvents.f_11749_);
            }

            protected void m_142289_(Level level, BlockPos pos, BlockState blockState) {
                DungeonChestBlockEntity.playSound(level, pos, blockState, SoundEvents.f_11747_);
            }

            protected void m_142148_(Level level, BlockPos pos, BlockState blockState, int previousCount, int newCount) {
                DungeonChestBlockEntity.this.signalOpenCount(level, pos, blockState, previousCount, newCount);
            }

            protected boolean m_142718_(Player player) {
                CompoundContainer cc;
                if (!(player.f_36096_ instanceof ChestMenu)) {
                    return false;
                }
                Container container = ((ChestMenu)player.f_36096_).m_39261_();
                return container == DungeonChestBlockEntity.this || container instanceof CompoundContainer && (cc = (CompoundContainer)container).m_18927_((Container)DungeonChestBlockEntity.this);
            }
        };
    }

    public void m_142466_(CompoundTag tag) {
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(tag)) {
            ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        }
        if (tag.m_128425_("PlayersWithLoot", 9)) {
            ListTag playerList = tag.m_128437_("PlayersWithLoot", 11);
            for (Tag playerTag : playerList) {
                this.playersWithGeneratedLoot.add(NbtUtils.m_129233_((Tag)playerTag));
            }
        }
        if (tag.m_128441_("placedTime")) {
            this.placedTime = tag.m_128454_("placedTime");
        }
        super.m_142466_(tag);
    }

    protected void m_183515_(CompoundTag tag) {
        if (!this.m_59634_(tag)) {
            ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        }
        ListTag playerList = new ListTag();
        for (UUID playerId : this.playersWithGeneratedLoot) {
            playerList.add((Object)NbtUtils.m_129226_((UUID)playerId));
        }
        tag.m_128365_("PlayersWithLoot", (Tag)playerList);
        tag.m_128356_("placedTime", this.placedTime);
        super.m_183515_(tag);
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
            if (((Boolean)ServerConfig.INSTANCE.dungeonConfig.perPlayerLoot.get()).booleanValue() && !this.f_58857_.f_46443_ && !this.playersWithGeneratedLoot.contains(player.m_20148_())) {
                this.generateLoot(player);
                this.playersWithGeneratedLoot.add(player.m_20148_());
                this.m_6596_();
            }
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    private void generateLoot(Player player) {
        if (this.lootTable == null) {
            return;
        }
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        LootContext.Builder builder = new LootContext.Builder((ServerLevel)this.f_58857_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_)).m_78972_(LootContextParams.f_81455_, (Object)player).m_78963_(player.m_36336_());
        this.f_58857_.m_7654_().m_129898_().m_79217_(this.lootTable).m_79123_((Container)this, builder.m_78975_(LootContextParamSets.f_81411_));
    }

    public void setLootTable(ResourceLocation lootTable) {
        this.lootTable = lootTable;
        this.m_6596_();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, DungeonChestBlockEntity blockEntity) {
        blockEntity.chestLidController.m_155374_();
        if (level.m_46467_() % 600L != 0L) {
            return;
        }
        if (!level.f_46443_ && DungeonSaveData.getOverworld(level).getBossChests().contains(pos)) {
            if (blockEntity.placedTime < 0L) {
                blockEntity.placedTime = level.m_46467_();
            } else if (level.m_46467_() >= blockEntity.placedTime + 6000L) {
                DungeonChestBlock chestBlock = (DungeonChestBlock)state.m_60734_();
                level.m_7471_(pos.m_121945_(DungeonChestBlock.getConnectedDirection(state)), false);
                level.m_7471_(pos, false);
                DungeonSaveData.getOverworld(level).removeBossChest(pos);
            }
        }
    }

    public float m_6683_(float partialTicks) {
        return this.chestLidController.m_155375_(partialTicks);
    }

    public int m_6643_() {
        return 27;
    }

    public void wasPlaced(@Nullable LivingEntity livingEntity, ItemStack stack) {
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.chest");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return ChestMenu.m_39237_((int)id, (Inventory)player, (Container)this);
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    static void playSound(Level level, BlockPos pos, BlockState state, SoundEvent sound) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.5;
        double z = (double)pos.m_123343_() + 0.5;
        level.m_6263_(null, x, y, z, sound, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    protected void signalOpenCount(Level level, BlockPos pos, BlockState state, int prevOpenCount, int openCount) {
        Block block = state.m_60734_();
        level.m_7696_(pos, block, 1, openCount);
    }

    public boolean m_7531_(int id, int param) {
        if (id == 1) {
            this.chestLidController.m_155377_(param > 0);
            return true;
        }
        return super.m_7531_(id, param);
    }
}

