/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.block.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import io.github.Memoires.trbeyond.Database;
import io.github.Memoires.trbeyond.block.DungeonUnlockerBlock;
import io.github.Memoires.trbeyond.block.client.DungeonDoorModel0;
import io.github.Memoires.trbeyond.block.client.DungeonDoorModel1;
import io.github.Memoires.trbeyond.block.client.DungeonDoorModelBase;
import io.github.Memoires.trbeyond.block.entity.AnimateDoorBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class DungeonDoorRenderer
implements BlockEntityRenderer<AnimateDoorBlockEntity> {
    private static final ResourceLocation TEXTURE0 = Database.rl("textures/models/dungeon_doors.png");
    private static final ResourceLocation TEXTURE1 = Database.rl("textures/models/forest_dungeon_doors.png");
    private final DungeonDoorModel0 model0;
    private final DungeonDoorModel1 model1;

    public DungeonDoorRenderer(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BlockEntityRendererProvider.Context ctx) {
        this.model0 = new DungeonDoorModel0(ctx.m_173582_(DungeonDoorModel0.LAYER));
        this.model1 = new DungeonDoorModel1(ctx.m_173582_(DungeonDoorModel1.LAYER));
    }

    public void render(AnimateDoorBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        if (blockEntity == null) {
            return;
        }
        BlockState state = blockEntity.m_58900_();
        Direction dir = (Direction)state.m_61143_((Property)DungeonUnlockerBlock.FACING);
        int floor = (Integer)state.m_61143_((Property)DungeonUnlockerBlock.FLOOR);
        if (((Boolean)state.m_61143_((Property)DungeonUnlockerBlock.CAN_GENERATE)).booleanValue()) {
            poseStack.m_85836_();
            ResourceLocation texture = this.getTexture(floor);
            DungeonDoorModelBase model = this.getModel(floor);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(dir.m_122435_()));
            poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
            poseStack.m_85837_((double)(-0.5f * (float)(dir.m_122434_() == Direction.Axis.Z ? dir.m_122431_() : dir.m_122429_())), -0.5, (double)(0.5f * (float)dir.m_122431_()));
            int fullLight = 0xF000F0;
            VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)texture));
            model.setupAnim(state);
            model.m_7695_(poseStack, vertexConsumer, fullLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
    }

    private ResourceLocation getTexture(int floor) {
        if (floor == 0) {
            return TEXTURE0;
        }
        return TEXTURE1;
    }

    private DungeonDoorModelBase getModel(int floor) {
        if (floor == 0) {
            return this.model0;
        }
        return this.model1;
    }
}

