/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.block.entity;

import io.github.Memoires.trbeyond.config.ServerConfig;
import io.github.Memoires.trbeyond.entity.custom.GozulEntity;
import io.github.Memoires.trbeyond.entity.custom.MezulEntity;
import io.github.Memoires.trbeyond.registry.blocks.BeyondBlockEntities;
import io.github.Memoires.trbeyond.registry.entities.BeyondEntities;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;

public class RespawnBossBlockEntity
extends BlockEntity {
    private static final double RADIUS = 40.0;
    private static final int CHECK_INTERVAL = (Integer)ServerConfig.INSTANCE.spawnConfig.bossRespawnTime.get();
    private int tickCounter = 0;
    private EntityType<? extends LivingEntity> selectedBoss;

    public RespawnBossBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BeyondBlockEntities.BOSS_SPAWNER.get(), pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        String bossIdString;
        ResourceLocation id;
        EntityType rawType;
        super.m_142466_(tag);
        if (tag.m_128425_("BossType", 8) && (rawType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(id = new ResourceLocation(bossIdString = tag.m_128461_("BossType")))) != null) {
            EntityType livingType;
            this.selectedBoss = livingType = rawType;
        }
        if (this.selectedBoss == null) {
            this.selectedBoss = (EntityType)BeyondEntities.MEZUL.get();
        }
    }

    protected void m_183515_(CompoundTag tag) {
        ResourceLocation id;
        super.m_183515_(tag);
        if (this.selectedBoss != null && (id = ForgeRegistries.ENTITY_TYPES.getKey(this.selectedBoss)) != null) {
            tag.m_128359_("BossType", id.toString());
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RespawnBossBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        ++blockEntity.tickCounter;
        if (blockEntity.tickCounter >= CHECK_INTERVAL * 60 * 20) {
            blockEntity.tickCounter = 0;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                blockEntity.checkAndSpawnBoss(serverLevel, pos);
            }
        }
    }

    public void setBoss(EntityType<? extends LivingEntity> newBoss) {
        this.selectedBoss = newBoss;
        this.m_6596_();
    }

    private void checkAndSpawnBoss(ServerLevel world, BlockPos pos) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.5;
        double z = (double)pos.m_123343_() + 0.5;
        AABB scanArea = new AABB(x - 40.0, y - 40.0, z - 40.0, x + 40.0, y + 40.0, z + 40.0);
        boolean bossFound = false;
        if (this.selectedBoss != null) {
            bossFound = this.selectedBoss == BeyondEntities.MEZUL.get() || this.selectedBoss == BeyondEntities.GOZUL.get() ? world.m_45976_(LivingEntity.class, scanArea).stream().anyMatch(entity -> entity instanceof GozulEntity || entity instanceof MezulEntity) : world.m_45976_(LivingEntity.class, scanArea).stream().anyMatch(entity -> entity.m_6095_() == this.selectedBoss);
        }
        if (!bossFound) {
            this.spawnBoss(world, x, y + 2.0, z);
        }
    }

    private void spawnBoss(ServerLevel world, double x, double y, double z) {
        LivingEntity boss;
        if (this.selectedBoss != null && (boss = (LivingEntity)this.selectedBoss.m_20615_((Level)world)) != null) {
            boss.m_7678_(x, y, z, world.f_46441_.m_188501_() * 360.0f, 0.0f);
            if (boss instanceof GozulEntity || boss instanceof MezulEntity) {
                Random random = new Random();
                int roll = random.nextInt(2);
                if (roll == 0) {
                    GozulEntity gozul = new GozulEntity((EntityType<GozulEntity>)((EntityType)BeyondEntities.GOZUL.get()), (Level)world);
                    gozul.m_7678_(x, y, z, world.f_46441_.m_188501_() * 360.0f, 0.0f);
                    if (gozul instanceof Mob) {
                        Mob mob = (Mob)gozul;
                        mob.m_6518_((ServerLevelAccessor)world, world.m_6436_(mob.m_20183_()), MobSpawnType.EVENT, null, null);
                    }
                    world.m_7967_((Entity)gozul);
                    return;
                }
                MezulEntity mezul = new MezulEntity((EntityType<MezulEntity>)((EntityType)BeyondEntities.MEZUL.get()), (Level)world);
                mezul.m_7678_(x, y, z, world.f_46441_.m_188501_() * 360.0f, 0.0f);
                if (mezul instanceof Mob) {
                    Mob mob = (Mob)mezul;
                    mob.m_6518_((ServerLevelAccessor)world, world.m_6436_(mob.m_20183_()), MobSpawnType.EVENT, null, null);
                }
                world.m_7967_((Entity)mezul);
                return;
            }
            if (boss instanceof Mob) {
                Mob mob = (Mob)boss;
                mob.m_6518_((ServerLevelAccessor)world, world.m_6436_(mob.m_20183_()), MobSpawnType.EVENT, null, null);
            }
            world.m_7967_((Entity)boss);
        }
    }
}

