/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.block.entity;

import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import io.github.Memoires.trbeyond.block.SlimeCeilingBlock;
import io.github.Memoires.trbeyond.items.armor.SerpentArmorItem;
import io.github.Memoires.trbeyond.registry.blocks.BeyondBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class SlimeCeilingBlockEntity
extends BlockEntity
implements IAnimatable {
    public int animationTick;
    public int tickCount;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public SlimeCeilingBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BeyondBlockEntities.SLIME_CEILING.get(), pos, state);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("animationTick", this.animationTick);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.animationTick = pTag.m_128451_("animationTick");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SlimeCeilingBlockEntity pEntity) {
        ++pEntity.tickCount;
        if (level.m_5776_()) {
            return;
        }
        if ((Integer)state.m_61143_((Property)SlimeCeilingBlock.STAGE) == 0) {
            AABB aabb;
            ++pEntity.animationTick;
            if (pEntity.animationTick % 20 == 0 && !level.m_6443_(LivingEntity.class, aabb = new AABB(pos).m_82377_(0.5, 0.0, 0.5).m_82363_(0.0, -6.0, 0.0), entity -> {
                Player player;
                return (!(entity instanceof Player) || !(player = (Player)entity).m_7500_()) && !entity.m_5833_();
            }).isEmpty()) {
                pEntity.setAnimationTick(0);
                SlimeCeilingBlock.activate(state, level, pos);
            }
        } else if ((Integer)state.m_61143_((Property)SlimeCeilingBlock.STAGE) == 1) {
            ++pEntity.animationTick;
            if (pEntity.getAnimationTick() >= 29) {
                pEntity.setAnimationTick(0);
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)SlimeCeilingBlock.STAGE, (Comparable)Integer.valueOf(2)));
            }
        } else if ((Integer)state.m_61143_((Property)SlimeCeilingBlock.STAGE) == 2) {
            ++pEntity.animationTick;
            if (pEntity.animationTick % 20 == 0) {
                AABB aabb = new AABB(pos).m_82377_(0.5, 0.0, 0.5).m_82363_(0.0, -7.0, 0.0);
                for (LivingEntity entity2 : level.m_45976_(LivingEntity.class, aabb)) {
                    entity2.m_6469_(TensuraDamageSources.CORROSION, 25.0f);
                    for (EquipmentSlot slot : EquipmentSlot.values()) {
                        ItemStack slotStack = entity2.m_6844_(slot);
                        if (slotStack.m_41720_() instanceof SerpentArmorItem) continue;
                        slotStack.m_41622_(5, entity2, player -> player.m_21166_(slot));
                    }
                    level.m_5594_(null, entity2.m_20183_(), SoundEvents.f_12031_, SoundSource.BLOCKS, 0.3f, 0.6f + level.f_46441_.m_188501_() * 0.4f);
                }
            }
            if (pEntity.getAnimationTick() >= 1200) {
                pEntity.setAnimationTick(0);
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)SlimeCeilingBlock.STAGE, (Comparable)Integer.valueOf(3)));
            }
        } else if ((Integer)state.m_61143_((Property)SlimeCeilingBlock.STAGE) == 3) {
            ++pEntity.animationTick;
            if (pEntity.getAnimationTick() >= 59) {
                pEntity.setAnimationTick(0);
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)SlimeCeilingBlock.STAGE, (Comparable)Integer.valueOf(0)));
            }
        }
    }

    private <E extends BlockEntity> PlayState predicate(AnimationEvent<E> event) {
        AnimationController controller = event.getController();
        controller.transitionLengthTicks = 0.0;
        if ((Integer)((BlockEntity)event.getAnimatable()).m_58900_().m_61143_((Property)SlimeCeilingBlock.STAGE) == 1) {
            String start = "animation.slime_ceiling.start_" + String.valueOf(this.m_58900_().m_61143_((Property)SlimeCeilingBlock.TYPE));
            controller.setAnimation(new AnimationBuilder().addAnimation(start, (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            controller.setAnimationSpeed(2.0);
        } else if ((Integer)((BlockEntity)event.getAnimatable()).m_58900_().m_61143_((Property)SlimeCeilingBlock.STAGE) == 2) {
            String loop = "animation.slime_ceiling.loop_" + String.valueOf(this.m_58900_().m_61143_((Property)SlimeCeilingBlock.TYPE));
            controller.setAnimation(new AnimationBuilder().addAnimation(loop, (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if ((Integer)((BlockEntity)event.getAnimatable()).m_58900_().m_61143_((Property)SlimeCeilingBlock.STAGE) == 3) {
            String end = "animation.slime_ceiling.end_" + String.valueOf(this.m_58900_().m_61143_((Property)SlimeCeilingBlock.TYPE));
            controller.setAnimation(new AnimationBuilder().addAnimation(end, (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            controller.setAnimationSpeed(1.0);
        } else {
            controller.setAnimation(new AnimationBuilder().addAnimation("animation.slime_ceiling.hidden", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            controller.setAnimationSpeed(1.0);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public void setAnimationTick(int animationTick) {
        this.animationTick = animationTick;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

