/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.capability.dungeon;

import io.github.Memoires.trbeyond.block.ShrineBlock;
import io.github.Memoires.trbeyond.capability.dungeon.DungeonCapabilityProvider;
import io.github.Memoires.trbeyond.capability.dungeon.IDungeonCapability;
import io.github.Memoires.trbeyond.handlers.CapabilityHandler;
import io.github.Memoires.trbeyond.network.BeyondNetwork;
import io.github.Memoires.trbeyond.network.SyncDungeonCapabilityPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="trbeyond", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DungeonCapability
implements IDungeonCapability {
    private static final Logger log = LogManager.getLogger(DungeonCapability.class);
    public static final Capability<IDungeonCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IDungeonCapability>(){});
    private static final ResourceLocation IDENTIFIER = new ResourceLocation("trbeyond", "dungeon");
    private boolean revivalBracelet = false;
    private boolean takenVoucher = false;
    private double epLimit = 0.0;
    private BlockPos overworldCoords = new BlockPos(0, 0, 0);
    public int bronzeChallengeCompletionCount = 0;
    public int silverChallengeCompletionCount = 0;
    public int goldChallengeCompletionCount = 0;
    public int stellarChallengeCompletionCount = 0;

    @SubscribeEvent
    public static void attach(AttachCapabilitiesEvent<Entity> e) {
        e.addCapability(IDENTIFIER, (ICapabilityProvider)new DungeonCapabilityProvider());
    }

    public static LazyOptional<IDungeonCapability> getFrom(LivingEntity entity) {
        return entity.getCapability(CAPABILITY);
    }

    public static void sync(LivingEntity entity) {
        if (entity.f_19853_.m_5776_()) {
            return;
        }
        DungeonCapability.getFrom(entity).ifPresent(data -> BeyondNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new SyncDungeonCapabilityPacket((IDungeonCapability)data, entity.m_19879_())));
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("revivalBracelet", this.revivalBracelet);
        tag.m_128379_("takenVoucher", this.takenVoucher);
        tag.m_128347_("epLimit", this.epLimit);
        tag.m_128356_("overworldPos", this.overworldCoords.m_121878_());
        tag.m_128405_("bronze_challenges_completed", this.bronzeChallengeCompletionCount);
        tag.m_128405_("silver_challenges_completed", this.silverChallengeCompletionCount);
        tag.m_128405_("gold_challenges_completed", this.goldChallengeCompletionCount);
        tag.m_128405_("stellar_challenges_completed", this.stellarChallengeCompletionCount);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.revivalBracelet = tag.m_128471_("revivalBracelet");
        this.takenVoucher = tag.m_128471_("takenVoucher");
        this.epLimit = tag.m_128459_("epLimit");
        this.overworldCoords = BlockPos.m_122022_((long)tag.m_128454_("overworldPos"));
        this.bronzeChallengeCompletionCount = tag.m_128451_("bronze_challenges_completed");
        this.silverChallengeCompletionCount = tag.m_128451_("silver_challenges_completed");
        this.goldChallengeCompletionCount = tag.m_128451_("gold_challenges_completed");
        this.stellarChallengeCompletionCount = tag.m_128451_("stellar_challenges_completed");
    }

    public static boolean hasRevivalBracelet(LivingEntity entity) {
        IDungeonCapability capability = CapabilityHandler.getCapability((Entity)entity, CAPABILITY);
        if (capability == null) {
            return false;
        }
        return capability.isRevivalBracelet();
    }

    public static void setRevivalBracelet(LivingEntity pLivingEntity, boolean value) {
        DungeonCapability.getFrom(pLivingEntity).ifPresent(cap -> cap.setRevivalBracelet(value));
        DungeonCapability.sync(pLivingEntity);
    }

    public static boolean hasTakenVoucher(LivingEntity entity) {
        IDungeonCapability capability = CapabilityHandler.getCapability((Entity)entity, CAPABILITY);
        if (capability == null) {
            return false;
        }
        return capability.isTakenVoucher();
    }

    public static void setTakenVoucher(LivingEntity pLivingEntity, boolean value) {
        DungeonCapability.getFrom(pLivingEntity).ifPresent(cap -> cap.setTakenVoucher(value));
        DungeonCapability.sync(pLivingEntity);
    }

    public static double getEpLimit(LivingEntity entity) {
        IDungeonCapability capability = CapabilityHandler.getCapability((Entity)entity, CAPABILITY);
        if (capability == null) {
            return 0.0;
        }
        return capability.getEpLimit();
    }

    public static void setEpLimit(LivingEntity pLivingEntity, double value) {
        DungeonCapability.getFrom(pLivingEntity).ifPresent(cap -> cap.setEpLimit(value));
        DungeonCapability.sync(pLivingEntity);
    }

    public static BlockPos getOverworldCoords(LivingEntity entity) {
        IDungeonCapability capability = CapabilityHandler.getCapability((Entity)entity, CAPABILITY);
        if (capability == null) {
            return new BlockPos(0, 0, 0);
        }
        return capability.getOverworldCoords();
    }

    public static void setOverworldCoords(LivingEntity pLivingEntity, BlockPos coords) {
        DungeonCapability.getFrom(pLivingEntity).ifPresent(cap -> cap.setOverworldCoords(coords));
        DungeonCapability.sync(pLivingEntity);
    }

    @Override
    public int getChallengeCompletionCount(ShrineBlock.DungeonShrineTier tier) {
        return switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case ShrineBlock.DungeonShrineTier.BRONZE -> this.bronzeChallengeCompletionCount;
            case ShrineBlock.DungeonShrineTier.SILVER -> this.silverChallengeCompletionCount;
            case ShrineBlock.DungeonShrineTier.GOLD -> this.goldChallengeCompletionCount;
            case ShrineBlock.DungeonShrineTier.STELLAR -> this.stellarChallengeCompletionCount;
        };
    }

    @Override
    public int getTotalChallengeCompletionCount() {
        return this.bronzeChallengeCompletionCount + this.silverChallengeCompletionCount + this.goldChallengeCompletionCount + this.stellarChallengeCompletionCount;
    }

    @Override
    public void setChallengeCompletionCount(ShrineBlock.DungeonShrineTier tier, Integer count) {
        switch (tier) {
            case BRONZE: {
                this.bronzeChallengeCompletionCount = count;
                break;
            }
            case SILVER: {
                this.silverChallengeCompletionCount = count;
                break;
            }
            case GOLD: {
                this.goldChallengeCompletionCount = count;
                break;
            }
            case STELLAR: {
                this.stellarChallengeCompletionCount = count;
            }
        }
    }

    @Override
    public boolean isRevivalBracelet() {
        return this.revivalBracelet;
    }

    @Override
    public boolean isTakenVoucher() {
        return this.takenVoucher;
    }

    @Override
    public void setRevivalBracelet(boolean revivalBracelet) {
        this.revivalBracelet = revivalBracelet;
    }

    @Override
    public void setTakenVoucher(boolean takenVoucher) {
        this.takenVoucher = takenVoucher;
    }

    @Override
    public double getEpLimit() {
        return this.epLimit;
    }

    @Override
    public void setEpLimit(double epLimit) {
        this.epLimit = epLimit;
    }

    @Override
    public BlockPos getOverworldCoords() {
        return this.overworldCoords;
    }

    @Override
    public void setOverworldCoords(BlockPos overworldCoords) {
        this.overworldCoords = overworldCoords;
    }
}

