/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.capability.player;

import io.github.Memoires.trbeyond.capability.player.BeyondPlayerCapabilityProvider;
import io.github.Memoires.trbeyond.capability.player.IBeyondPlayerCapability;
import io.github.Memoires.trbeyond.network.BeyondNetwork;
import io.github.Memoires.trbeyond.network.SyncPlayerCapabilityPacket;
import io.github.Memoires.trbeyond.util.ChallengeType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="trbeyond", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BeyondPlayerCapability
implements IBeyondPlayerCapability {
    public static final Capability<IBeyondPlayerCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IBeyondPlayerCapability>(){});
    private static final ResourceLocation ID = new ResourceLocation("trbeyond", "player_cap");
    public boolean isAction = false;
    public boolean usedTicket = false;
    public boolean usedCrystal = false;
    public boolean isReturned = true;
    public ChallengeType challengeType = null;
    public BlockPos overworldCoords;

    @SubscribeEvent
    public static void attach(AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof Player) {
            e.addCapability(ID, (ICapabilityProvider)new BeyondPlayerCapabilityProvider(){});
        }
    }

    public static LazyOptional<IBeyondPlayerCapability> getFrom(Player player) {
        @NotNull LazyOptional lazyCap = player.getCapability(CAPABILITY);
        return lazyCap;
    }

    public static void sync(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BeyondPlayerCapability.getFrom((Player)serverPlayer).ifPresent(data -> BeyondNetwork.sendToAllTrackingAndSelf(new SyncPlayerCapabilityPacket((IBeyondPlayerCapability)data, serverPlayer.m_19879_()), (LivingEntity)serverPlayer));
        }
    }

    @Override
    public boolean getAction() {
        return this.isAction;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("isAction", this.isAction);
        tag.m_128379_("usedTicket", this.usedTicket);
        if (this.challengeType != null) {
            CompoundTag challengeTag = new CompoundTag();
            challengeTag.m_128359_("name", this.challengeType.getName());
            challengeTag.m_128359_("category", this.challengeType.getCategory());
            challengeTag.m_128359_("objective", this.challengeType.getObjective());
            challengeTag.m_128405_("count", this.challengeType.getCount());
            challengeTag.m_128379_("onSpawn", this.challengeType.isOnSpawn());
            challengeTag.m_128359_("reward", this.challengeType.getReward());
            challengeTag.m_128405_("rewardAmount", this.challengeType.getRewardAmount());
            challengeTag.m_128405_("countDone", this.challengeType.getCountDone());
            challengeTag.m_128405_("timeLimit", this.challengeType.getTimeLimit());
            challengeTag.m_128379_("random", this.challengeType.isRandom());
            challengeTag.m_128405_("time", this.challengeType.getTime());
            challengeTag.m_128405_("waveDelay", this.challengeType.getWaveDelay());
            tag.m_128365_("challengeType", (Tag)challengeTag);
        }
        if (this.overworldCoords != null) {
            tag.m_128356_("overworldCoords", this.overworldCoords.m_121878_());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.isAction = nbt.m_128471_("isAction");
        this.usedTicket = nbt.m_128471_("usedTicket");
        this.challengeType = null;
        if (nbt.m_128441_("challengeType")) {
            CompoundTag challengeTag = nbt.m_128469_("challengeType");
            this.challengeType = new ChallengeType(challengeTag.m_128461_("name"), challengeTag.m_128461_("category"), challengeTag.m_128461_("objective"), challengeTag.m_128451_("count"), challengeTag.m_128471_("onSpawn"), challengeTag.m_128461_("reward"), challengeTag.m_128451_("rewardAmount"), challengeTag.m_128451_("timeLimit"), challengeTag.m_128471_("random"), challengeTag.m_128451_("waveDelay"));
            this.challengeType.setCountDone(challengeTag.m_128451_("countDone"));
            this.challengeType.setTime(challengeTag.m_128451_("time"));
        }
        this.overworldCoords = nbt.m_128441_("overworldCoords") ? BlockPos.m_122022_((long)nbt.m_128454_("overworldCoords")) : new BlockPos(0, 60, 0);
    }

    @Override
    public boolean isAction() {
        return this.isAction;
    }

    @Override
    public void setAction(boolean action) {
        this.isAction = action;
    }

    @Override
    public boolean isUsedTicket() {
        return this.usedTicket;
    }

    @Override
    public void setUsedTicket(boolean used) {
        this.usedTicket = used;
    }

    @Override
    public boolean isReturned() {
        return this.isReturned;
    }

    @Override
    public void setReturned(boolean returned) {
        this.isReturned = returned;
    }

    @Override
    public void setOverworldCoords(BlockPos overworldCoords) {
        this.overworldCoords = overworldCoords;
    }

    @Override
    public BlockPos getOverworldCoords() {
        return this.overworldCoords != null ? this.overworldCoords : new BlockPos(0, 60, 0);
    }

    @Override
    public boolean isUsedCrystal() {
        return this.usedCrystal;
    }

    @Override
    public void setUsedCrystal(boolean used) {
        this.usedCrystal = used;
    }

    @Override
    public ChallengeType getChallengeType() {
        return this.challengeType;
    }

    @Override
    public void setChallengeType(ChallengeType challengeType) {
        this.challengeType = challengeType;
    }
}

