/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.client.collision;

import com.mojang.math.Matrix3f;
import com.mojang.math.Vector3f;
import java.util.Arrays;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class OBB {
    public Vec3 center;
    public Vec3 extent;
    public Vec3 axisX;
    public Vec3 axisY;
    public Vec3 axisZ;
    public Vec3 scaledAxisX;
    public Vec3 scaledAxisY;
    public Vec3 scaledAxisZ;
    public Matrix3f rotation = new Matrix3f();
    public Vec3 vertex1;
    public Vec3 vertex2;
    public Vec3 vertex3;
    public Vec3 vertex4;
    public Vec3 vertex5;
    public Vec3 vertex6;
    public Vec3 vertex7;
    public Vec3 vertex8;
    public Vec3[] vertices;

    public OBB(Vec3 center, double width, double height, double depth, float yaw, float pitch) {
        this.center = center;
        this.extent = new Vec3(width / 2.0, height / 2.0, depth / 2.0);
        this.axisZ = Vec3.m_82498_((float)yaw, (float)pitch).m_82541_();
        this.axisY = Vec3.m_82498_((float)(yaw + 90.0f), (float)pitch).m_82548_().m_82541_();
        this.axisX = this.axisZ.m_82537_(this.axisY);
    }

    public OBB(Vec3 center, Vec3 size, float yaw, float pitch) {
        this(center, size.f_82479_, size.f_82480_, size.f_82481_, yaw, pitch);
    }

    public OBB(AABB box) {
        this.center = new Vec3((box.f_82291_ + box.f_82288_) / 2.0, (box.f_82292_ + box.f_82289_) / 2.0, (box.f_82293_ + box.f_82290_) / 2.0);
        this.extent = new Vec3(Math.abs(box.f_82291_ - box.f_82288_) / 2.0, Math.abs(box.f_82292_ - box.f_82289_) / 2.0, Math.abs(box.f_82293_ - box.f_82290_) / 2.0);
        this.axisX = new Vec3(1.0, 0.0, 0.0);
        this.axisY = new Vec3(0.0, 1.0, 0.0);
        this.axisZ = new Vec3(0.0, 0.0, 1.0);
    }

    public OBB(OBB obb) {
        this.center = obb.center;
        this.extent = obb.extent;
        this.axisX = obb.axisX;
        this.axisY = obb.axisY;
        this.axisZ = obb.axisZ;
    }

    public OBB copy() {
        return new OBB(this);
    }

    public OBB offsetAlongAxisX(double offset) {
        this.center = this.center.m_82549_(this.axisX.m_82490_(offset));
        return this;
    }

    public OBB offsetAlongAxisY(double offset) {
        this.center = this.center.m_82549_(this.axisY.m_82490_(offset));
        return this;
    }

    public OBB offsetAlongAxisZ(double offset) {
        this.center = this.center.m_82549_(this.axisZ.m_82490_(offset));
        return this;
    }

    public OBB OffsetAlongAxisZ(double offset) {
        this.center = this.center.m_82546_(this.axisZ.m_82490_(offset));
        return this;
    }

    public OBB offset(Vec3 offset) {
        this.center = this.center.m_82549_(offset);
        return this;
    }

    public OBB scale(double scale) {
        this.extent = this.extent.m_82490_(scale);
        return this;
    }

    public OBB updateVertex() {
        this.rotation.m_8165_(0, 0, (float)this.axisX.f_82479_);
        this.rotation.m_8165_(0, 1, (float)this.axisX.f_82480_);
        this.rotation.m_8165_(0, 2, (float)this.axisX.f_82481_);
        this.rotation.m_8165_(1, 0, (float)this.axisY.f_82479_);
        this.rotation.m_8165_(1, 1, (float)this.axisY.f_82480_);
        this.rotation.m_8165_(1, 2, (float)this.axisY.f_82481_);
        this.rotation.m_8165_(2, 0, (float)this.axisZ.f_82479_);
        this.rotation.m_8165_(2, 1, (float)this.axisZ.f_82480_);
        this.rotation.m_8165_(2, 2, (float)this.axisZ.f_82481_);
        this.scaledAxisX = this.axisX.m_82490_(this.extent.f_82479_);
        this.scaledAxisY = this.axisY.m_82490_(this.extent.f_82480_);
        this.scaledAxisZ = this.axisZ.m_82490_(this.extent.f_82481_);
        this.vertex1 = this.center.m_82546_(this.scaledAxisZ).m_82546_(this.scaledAxisX).m_82546_(this.scaledAxisY);
        this.vertex2 = this.center.m_82546_(this.scaledAxisZ).m_82549_(this.scaledAxisX).m_82546_(this.scaledAxisY);
        this.vertex3 = this.center.m_82546_(this.scaledAxisZ).m_82549_(this.scaledAxisX).m_82549_(this.scaledAxisY);
        this.vertex4 = this.center.m_82546_(this.scaledAxisZ).m_82546_(this.scaledAxisX).m_82549_(this.scaledAxisY);
        this.vertex5 = this.center.m_82549_(this.scaledAxisZ).m_82546_(this.scaledAxisX).m_82546_(this.scaledAxisY);
        this.vertex6 = this.center.m_82549_(this.scaledAxisZ).m_82549_(this.scaledAxisX).m_82546_(this.scaledAxisY);
        this.vertex7 = this.center.m_82549_(this.scaledAxisZ).m_82549_(this.scaledAxisX).m_82549_(this.scaledAxisY);
        this.vertex8 = this.center.m_82549_(this.scaledAxisZ).m_82546_(this.scaledAxisX).m_82549_(this.scaledAxisY);
        this.vertices = new Vec3[]{this.vertex1, this.vertex2, this.vertex3, this.vertex4, this.vertex5, this.vertex6, this.vertex7, this.vertex8};
        return this;
    }

    public boolean contains(Vec3 point) {
        Vector3f distance = new Vector3f(point.m_82546_(this.center));
        distance.m_122249_(this.rotation);
        return (double)Math.abs(distance.m_122239_()) < this.extent.f_82479_ && (double)Math.abs(distance.m_122260_()) < this.extent.f_82480_ && (double)Math.abs(distance.m_122269_()) < this.extent.f_82481_;
    }

    public boolean intersects(AABB boundingBox) {
        OBB otherOBB = new OBB(boundingBox).updateVertex();
        return OBB.Intersects(this, otherOBB);
    }

    public boolean intersects(OBB otherOBB) {
        return OBB.Intersects(this, otherOBB);
    }

    public static boolean Intersects(OBB a, OBB b) {
        if (OBB.Separated(a.vertices, b.vertices, a.scaledAxisX)) {
            return false;
        }
        if (OBB.Separated(a.vertices, b.vertices, a.scaledAxisY)) {
            return false;
        }
        if (OBB.Separated(a.vertices, b.vertices, a.scaledAxisZ)) {
            return false;
        }
        if (OBB.Separated(a.vertices, b.vertices, b.scaledAxisX)) {
            return false;
        }
        if (OBB.Separated(a.vertices, b.vertices, b.scaledAxisY)) {
            return false;
        }
        if (OBB.Separated(a.vertices, b.vertices, b.scaledAxisZ)) {
            return false;
        }
        if (OBB.Separated(a.vertices, b.vertices, a.scaledAxisX.m_82537_(b.scaledAxisX))) {
            return false;
        }
        if (OBB.Separated(a.vertices, b.vertices, a.scaledAxisX.m_82537_(b.scaledAxisY))) {
            return false;
        }
        if (OBB.Separated(a.vertices, b.vertices, a.scaledAxisX.m_82537_(b.scaledAxisZ))) {
            return false;
        }
        if (OBB.Separated(a.vertices, b.vertices, a.scaledAxisY.m_82537_(b.scaledAxisX))) {
            return false;
        }
        if (OBB.Separated(a.vertices, b.vertices, a.scaledAxisY.m_82537_(b.scaledAxisY))) {
            return false;
        }
        if (OBB.Separated(a.vertices, b.vertices, a.scaledAxisY.m_82537_(b.scaledAxisZ))) {
            return false;
        }
        if (OBB.Separated(a.vertices, b.vertices, a.scaledAxisZ.m_82537_(b.scaledAxisX))) {
            return false;
        }
        if (OBB.Separated(a.vertices, b.vertices, a.scaledAxisZ.m_82537_(b.scaledAxisY))) {
            return false;
        }
        return !OBB.Separated(a.vertices, b.vertices, a.scaledAxisZ.m_82537_(b.scaledAxisZ));
    }

    private static boolean Separated(Vec3[] vertsA, Vec3[] vertsB, Vec3 axis) {
        double sumSpan;
        if (axis.equals((Object)Vec3.f_82478_)) {
            return false;
        }
        double aMin = Double.POSITIVE_INFINITY;
        double aMax = Double.NEGATIVE_INFINITY;
        double bMin = Double.POSITIVE_INFINITY;
        double bMax = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < 8; ++i) {
            double aDist = vertsA[i].m_82526_(axis);
            aMin = aDist < aMin ? aDist : aMin;
            aMax = aDist > aMax ? aDist : aMax;
            double bDist = vertsB[i].m_82526_(axis);
            bMin = bDist < bMin ? bDist : bMin;
            bMax = bDist > bMax ? bDist : bMax;
        }
        double longSpan = Math.max(aMax, bMax) - Math.min(aMin, bMin);
        return longSpan >= (sumSpan = aMax - aMin + bMax - bMin);
    }

    public String toString() {
        return "OBB{\ncenter=" + String.valueOf(this.center) + ", \nextent=" + String.valueOf(this.extent) + ", \naxisX=" + String.valueOf(this.axisX) + ", \naxisY=" + String.valueOf(this.axisY) + ", \naxisZ=" + String.valueOf(this.axisZ) + ", \nscaledAxisX=" + String.valueOf(this.scaledAxisX) + ", \nscaledAxisY=" + String.valueOf(this.scaledAxisY) + ", \nscaledAxisZ=" + String.valueOf(this.scaledAxisZ) + ", \nrotation=" + String.valueOf(this.rotation) + ", \nvertex1=" + String.valueOf(this.vertex1) + ", \nvertex2=" + String.valueOf(this.vertex2) + ", \nvertex3=" + String.valueOf(this.vertex3) + ", \nvertex4=" + String.valueOf(this.vertex4) + ", \nvertex5=" + String.valueOf(this.vertex5) + ", \nvertex6=" + String.valueOf(this.vertex6) + ", \nvertex7=" + String.valueOf(this.vertex7) + ", \nvertex8=" + String.valueOf(this.vertex8) + ", \nvertices=" + Arrays.toString(this.vertices) + "\n}";
    }
}

