/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.client.collision;

import io.github.Memoires.trbeyond.client.collision.CollisionHelper;
import io.github.Memoires.trbeyond.client.collision.OBB;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TargetFinder {
    public static TargetResult findAttackTargetResult(Player player, double attackRange) {
        Vec3 origin = TargetFinder.getInitialTracingPoint(player);
        List<Entity> entities = TargetFinder.getInitialTargets(player, attackRange);
        Vec3 size = new Vec3(attackRange / 6.0, attackRange / 6.0, attackRange * 1.0);
        OBB obb = new OBB(origin, size, 0.0f, player.m_146908_());
        obb.updateVertex();
        CollisionFilter collisionFilter = new CollisionFilter(obb);
        entities = collisionFilter.filter(entities);
        RadialFilter radialFilter = new RadialFilter(origin, obb.axisZ, attackRange, player.m_146908_());
        entities = radialFilter.filter(entities);
        return new TargetResult(entities, obb);
    }

    public static List<Entity> findAttackTargets(Player player, double attackRange) {
        return TargetFinder.findAttackTargetResult((Player)player, (double)attackRange).entities;
    }

    public static Vec3 getInitialTracingPoint(Player player) {
        double shoulderHeight = (double)player.m_20206_() * 0.15 * (double)player.m_6134_();
        return player.m_146892_().m_82492_(0.0, shoulderHeight, 0.0);
    }

    public static List<Entity> getInitialTargets(Player player, double attackRange) {
        AABB box = player.m_20191_().m_82400_(attackRange + 1.0);
        List<Entity> entities = player.f_19853_.m_6249_((Entity)player, box, entity -> !entity.m_5833_() && entity.m_6087_()).stream().filter(entity -> {
            boolean result = entity != player && entity.m_6097_();
            return result;
        }).collect(Collectors.toList());
        return entities;
    }

    public static class CollisionFilter
    implements Filter {
        private OBB obb;

        public CollisionFilter(OBB obb) {
            this.obb = obb;
        }

        @Override
        public List<Entity> filter(List<Entity> entities) {
            return entities.stream().filter((? super T entity) -> this.obb.intersects(entity.m_20191_().m_82400_((double)entity.m_6143_())) || this.obb.contains(entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0))).collect(Collectors.toList());
        }
    }

    public static class RadialFilter
    implements Filter {
        private final Vec3 origin;
        private final Vec3 orientation;
        private final double attackRange;
        private final double attackAngle;

        public RadialFilter(Vec3 origin, Vec3 orientation, double attackRange, double attackAngle) {
            this.origin = origin;
            this.orientation = orientation;
            this.attackRange = attackRange;
            this.attackAngle = Math.max(Math.min(attackAngle, 360.0), 0.0);
        }

        @Override
        public List<Entity> filter(List<Entity> entities) {
            return entities.stream().filter((? super T entity) -> {
                double maxAngleDif = this.attackAngle / 2.0;
                Vec3 distanceVector = CollisionHelper.distanceVector(this.origin, entity.m_20191_());
                Vec3 positionVector = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0).m_82546_(this.origin);
                return distanceVector.m_82553_() <= this.attackRange && (this.attackAngle == 0.0 || CollisionHelper.angleBetween(positionVector, this.orientation) <= maxAngleDif || CollisionHelper.angleBetween(distanceVector, this.orientation) <= maxAngleDif);
            }).collect(Collectors.toList());
        }
    }

    public static class TargetResult {
        public List<Entity> entities;
        public OBB obb;

        public TargetResult(List<Entity> entities, OBB obb) {
            this.entities = entities;
            this.obb = obb;
        }
    }

    public static interface Filter {
        public List<Entity> filter(List<Entity> var1);
    }
}

