/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.client.gui;

import io.github.Memoires.trbeyond.handlers.ChallengeEventHandler;
import io.github.Memoires.trbeyond.network.worldgen.dimension.BeyondDungeon;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class ChallengeOverlay {
    public static final IGuiOverlay CHALLENGE_OVERLAY = (gui, poseStack, partialTick, width, height) -> {
        LocalPlayer player = gui.getMinecraft().f_91074_;
        if (player == null || !player.m_9236_().m_46472_().equals(BeyondDungeon.DUNGEON_LEVEL_KEY)) {
            return;
        }
        ChallengeEventHandler.getPlayerCapability((Player)player).ifPresent(capability -> {
            if (capability.getChallengeType() != null) {
                int y = 10;
                int timeLimit = capability.getChallengeType().getTimeLimit();
                int timeLeft = 0;
                if (timeLimit > 0 && (timeLeft = timeLimit - capability.getChallengeType().getTime()) < 0) {
                    timeLeft = 0;
                }
                String challengeName = capability.getChallengeType().getName().contains("elite") ? Component.m_237115_((String)"trbeyond.challenge.kill_elite").getString() : Component.m_237115_((String)("trbeyond.challenge." + capability.getChallengeType().getName())).getString();
                String countText = String.format("Count: %d/%d", capability.getChallengeType().getCountDone(), capability.getChallengeType().getCount());
                String timeText = "Time left: %d seconds";
                if (capability.getChallengeType().getWaveDelay() != -1) {
                    int waveDelay = capability.getChallengeType().getWaveDelay();
                    countText = String.format("Wave: %d/%d", capability.getChallengeType().getCountDone(), capability.getChallengeType().getCount());
                    if (capability.getChallengeType().getName().contains("wave")) {
                        timeText = "Next wave in: %d seconds";
                        timeLeft = ((timeLeft - timeLimit) % waveDelay + waveDelay) % waveDelay;
                    }
                }
                String itemKey = capability.getChallengeType().getReward().replace(":", ".");
                String rewardText = String.format("Reward: %s x%d", Component.m_237115_((String)("item." + itemKey)).getString(), capability.getChallengeType().getRewardAmount());
                if (capability.getChallengeType().getCategory().contains("shrine")) {
                    rewardText = "";
                }
                if (capability.getChallengeType().getName().equals("kill_elite")) {
                    countText = Component.m_237110_((String)"trbeyond.challenge.target_entity", (Object[])new Object[]{Component.m_237115_((String)String.format("entity.%s.%s", capability.getChallengeType().getObjective().substring(0, capability.getChallengeType().getObjective().indexOf(":")), capability.getChallengeType().getObjective().substring(capability.getChallengeType().getObjective().indexOf(":") + 1)))}).getString();
                }
                int x = width - gui.m_93082_().m_92895_(challengeName) - 10;
                x = Math.min(x, width - gui.m_93082_().m_92895_(countText) - 10);
                x = Math.min(x, width - gui.m_93082_().m_92895_(rewardText) - 10);
                if (capability.getChallengeType().getTimeLimit() > 0) {
                    x = Math.min(x, width - gui.m_93082_().m_92895_(String.format(timeText, capability.getChallengeType().getTimeLimit())) - 10);
                }
                gui.m_93082_().m_92883_(poseStack, challengeName, (float)x, (float)y, 4031942);
                gui.m_93082_().m_92883_(poseStack, countText, (float)x, (float)(y + 10), 4031942);
                if (rewardText != null && !rewardText.isEmpty()) {
                    gui.m_93082_().m_92883_(poseStack, rewardText, (float)x, (float)(y + 20), 4031942);
                } else {
                    y -= 10;
                }
                if (timeLimit > 0) {
                    gui.m_93082_().m_92883_(poseStack, String.format(timeText, timeLeft), (float)x, (float)(y + 30), 4031942);
                }
            }
        });
    };
}

