/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FontRenderer {
    private static String textToRender = null;
    private static Vec3 targetPosition = null;
    private static int renderDuration = 0;
    private static int ticksRemaining = 0;

    public static void renderText(String textToRender, Vec3 targetPosition, int renderDuration) {
        FontRenderer.textToRender = textToRender;
        FontRenderer.targetPosition = targetPosition;
        FontRenderer.renderDuration = renderDuration;
        ticksRemaining = renderDuration;
    }

    @SubscribeEvent
    public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() != VanillaGuiOverlay.HOTBAR.type()) {
            return;
        }
        if (textToRender == null || targetPosition == null || ticksRemaining <= 0) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        EntityRenderDispatcher renderDispatcher = mc.m_91290_();
        Vec3 cameraPos = renderDispatcher.f_114358_.m_90583_();
        Vec3 relativePos = targetPosition.m_82546_(cameraPos);
        Vec3 cameraSpacePos = FontRenderer.transformToCameraSpace(relativePos, mc.f_91063_);
        float[] screenCoords = FontRenderer.projectToScreen(cameraSpacePos, poseStack);
        float screenX = screenCoords[0];
        float screenY = screenCoords[1];
        if (cameraSpacePos.f_82481_ <= 0.0) {
            --ticksRemaining;
            return;
        }
        Font font = mc.f_91062_;
        font.m_92883_(poseStack, textToRender, screenX, screenY, 0xFFFFFF);
        if (--ticksRemaining <= 0) {
            textToRender = null;
            targetPosition = null;
        }
    }

    private static Vec3 transformToCameraSpace(Vec3 relativePos, GameRenderer camera) {
        Quaternion rotation = camera.m_109153_().m_90591_();
        Matrix4f rotationMatrix = new Matrix4f(rotation);
        Vector4f vec = new Vector4f((float)relativePos.f_82479_, (float)relativePos.f_82480_, (float)relativePos.f_82481_, 1.0f);
        vec.m_123607_(rotationMatrix);
        return new Vec3((double)vec.m_123601_(), (double)vec.m_123615_(), (double)vec.m_123616_());
    }

    private static float[] projectToScreen(Vec3 cameraSpacePos, PoseStack poseStack) {
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        float fov = ((Integer)mc.f_91066_.m_231837_().m_231551_()).floatValue();
        float fovRad = (float)Math.toRadians(fov);
        float tanHalfFov = (float)Math.tan(fovRad / 2.0f);
        float aspectRatio = (float)mc.m_91268_().m_85441_() / (float)mc.m_91268_().m_85442_();
        float ndcX = (float)(cameraSpacePos.f_82479_ / (cameraSpacePos.f_82481_ * (double)tanHalfFov * (double)aspectRatio));
        float ndcY = (float)(cameraSpacePos.f_82480_ / (cameraSpacePos.f_82481_ * (double)tanHalfFov));
        float screenX = (ndcX + 1.0f) * 0.5f * (float)screenWidth;
        float screenY = (1.0f - ndcY) * 0.5f * (float)screenHeight;
        return new float[]{screenX, screenY};
    }
}

