/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.client.screen;

import com.github.manasmods.manascore.api.client.gui.widget.ImagePredicateButton;
import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.tensura.ability.skill.unique.ResearcherSkill;
import com.github.manasmods.tensura.client.TensuraGUIHelper;
import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2server.skill.RequestResearcherEnchantmentPacket;
import com.github.manasmods.tensura.util.ITensuraScrollbar;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.Memoires.trbeyond.client.screen.ResearcherEnchantmentShopMenu;
import io.github.Memoires.trbeyond.network.BeyondNetwork;
import io.github.Memoires.trbeyond.network.ClientConfigData;
import io.github.Memoires.trbeyond.network.RequestResearcherPaymentPacket;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;

public class CustomResearcherEnchantmentScreen
extends AbstractContainerScreen<ResearcherEnchantmentShopMenu>
implements ITensuraScrollbar {
    private final ResourceLocation BACKGROUND = new ResourceLocation("trbeyond", "textures/screen/researcher/researcher_enchant.png");
    private final ResourceLocation NAME_BAR = new ResourceLocation("tensura", "textures/gui/researcher/enchantment_name.png");
    private final ResourceLocation ENCHANT_BUTTON = new ResourceLocation("tensura", "textures/gui/researcher/enchant_button.png");
    private final ResourceLocation LEVEL_BOX = new ResourceLocation("tensura", "textures/gui/researcher/enchantment_level.png");
    private final ResourceLocation CHECKBOX = new ResourceLocation("tensura", "textures/gui/checkbox.png");
    private float scrollOffs;
    private int startIndex;
    private int offscreenRows;
    private static final Set<String> ENCHANT_S = new HashSet<String>(Arrays.asList("mending", "unbreaking", "protection", "feather_falling", "efficiency", "fortune", "looting", "sharpness", "power"));
    private static final Set<String> ENCHANT_A = new HashSet<String>(Arrays.asList("smite", "silk_touch", "respiration", "depth_strider", "infinity", "sweeping_edge", "quick_charge", "piercing"));
    private static final Set<String> ENCHANT_B = new HashSet<String>(Arrays.asList("fire_aspect", "knockback", "flame", "multishot", "impaling", "riptide", "luck_of_the_sea", "lure", "thorns"));
    private static final Set<String> ENCHANT_C_TO_F = new HashSet<String>(Arrays.asList("blast_protection", "projectile_protection", "channeling", "frost_walker", "bane_of_arthropods", "curse_of_binding", "curse_of_vanishing"));
    private static final Set<String> ENGRAVE_S = new HashSet<String>(Arrays.asList("elemental_boost", "elemental_resistance", "soul_eater", "severance", "energy_steal", "battle_infusion", "darkness_infusion", "earth_infusion", "fire_infusion", "flame_infusion", "land_infusion", "light_infusion", "spatial_infusion", "water_infusion", "wind_infusion", "holy_coat"));
    private static final Set<String> ENGRAVE_A = new HashSet<String>(Arrays.asList("slotting", "barrier_piercing", "magic_interference", "magic_weapon", "holy_weapon"));
    private static final Set<String> ENGRAVE_B = new HashSet<String>(Arrays.asList("swift", "sturdy", "crushing"));
    private static final Set<String> ENGRAVE_F = new HashSet<String>(Arrays.asList("breathing_support"));
    private static final Map<String, Integer> TIER_RANK = new HashMap<String, Integer>();

    private int getEnchantSPriceGold() {
        return ClientConfigData.ENCHANT_S_PRICE_GOLD;
    }

    private int getEnchantAPriceSilver() {
        return ClientConfigData.ENCHANT_A_PRICE_SILVER;
    }

    private int getEnchantBPriceSilver() {
        return ClientConfigData.ENCHANT_B_PRICE_SILVER;
    }

    private int getEnchantCtoFPriceSilver() {
        return ClientConfigData.ENCHANT_C_TO_F_PRICE_SILVER;
    }

    private int getEngraveSPriceStellar() {
        return ClientConfigData.ENGRAVE_S_PRICE_STELLAR;
    }

    private int getEngraveAPriceGold() {
        return ClientConfigData.ENGRAVE_A_PRICE_GOLD;
    }

    private int getEngraveBPriceGold() {
        return ClientConfigData.ENGRAVE_B_PRICE_GOLD;
    }

    private int getEngraveFPriceGold() {
        return ClientConfigData.ENGRAVE_F_PRICE_GOLD;
    }

    public CustomResearcherEnchantmentScreen(ResearcherEnchantmentShopMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 176;
        this.f_97727_ = 227;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.scrollOffs = 0.0f;
        this.startIndex = 0;
        this.offscreenRows = ResearcherSkill.getAllEnchantments((LivingEntity)((ResearcherEnchantmentShopMenu)this.f_97732_).getPlayer(), (ManasSkill)((ResearcherEnchantmentShopMenu)this.m_6262_()).getSkill()).size() - 5;
        this.initScrollbar(this.f_97735_ + 126, this.f_97736_ + 67, 65, this.scrollOffs, false, false);
        int bx = this.f_97735_ + 145;
        int by = this.f_97736_ + 44;
        ResourceLocation tex = this.ENCHANT_BUTTON;
        Button.OnPress onPress = button -> {
            if (!((ResearcherEnchantmentShopMenu)this.f_97732_).getItemInput().m_7983_() && (long)((ResearcherEnchantmentShopMenu)this.f_97732_).getExperienceCost() <= ResearcherEnchantmentShopMenu.getTotalXp((Player)((ResearcherEnchantmentShopMenu)this.f_97732_).getPlayer())) {
                Map selectedEnchants = ResearcherSkill.getSelectedEnchantments((LivingEntity)((ResearcherEnchantmentShopMenu)this.f_97732_).getPlayer(), (ManasSkill)((ResearcherEnchantmentShopMenu)this.m_6262_()).getSkill());
                CostResult costResult = this.calculateCosts(selectedEnchants);
                BeyondNetwork.INSTANCE.sendToServer((Object)new RequestResearcherPaymentPacket(costResult.stellar, costResult.gold, costResult.silver));
            }
        };
        Button.OnTooltip onTooltip = (button, poseStack, x, y) -> this.m_96602_(poseStack, (Component)Component.m_237115_((String)"container.enchant"), x, y);
        ResearcherEnchantmentShopMenu checkMenu = (ResearcherEnchantmentShopMenu)this.f_97732_;
        Objects.requireNonNull(checkMenu);
        ImagePredicateButton enchantButton = new ImagePredicateButton(bx, by, 20, 18, tex, onPress, onTooltip, () -> ((ResearcherEnchantmentShopMenu)checkMenu).check());
        this.m_142416_((GuiEventListener)enchantButton);
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_7333_(pPoseStack);
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.m_7025_(pPoseStack, pMouseX, pMouseY);
        this.renderTabIcons();
    }

    private void renderTabIcons() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91291_().m_115203_(new ItemStack((ItemLike)Items.f_42100_), this.getGuiLeft() + 8, this.getGuiTop() + 6);
        }
    }

    public void m_7027_(PoseStack pPoseStack, int pMouseX, int pMouseY) {
        TensuraGUIHelper.renderScaledCenteredXText((Font)this.f_96547_, (PoseStack)pPoseStack, (Component)Component.m_237115_((String)"tensura.researcher_menu.enchantment_tab"), (int)2, (int)31, (int)145, (int)9, (Color)Color.WHITE, (boolean)false);
    }

    protected void m_7286_(PoseStack poseStack, float partialTick, int mX, int mY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.BACKGROUND);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.renderScrollbar(poseStack);
        SCROLLBAR_DATA.setActive(this.offscreenRows >= 1);
        this.renderEnchantments(poseStack, mX, mY);
    }

    protected void m_7025_(PoseStack pPoseStack, int pX, int pY) {
        if (TensuraGUIHelper.mouseOver((int)pX, (int)pY, (int)(this.f_97735_ + 3), (int)(this.f_97735_ + 28), (int)(this.f_97736_ + 1), (int)(this.f_97736_ + 23))) {
            this.m_96602_(pPoseStack, (Component)Component.m_237115_((String)"tensura.researcher_menu.enchantment_tab"), pX, pY);
        } else if (TensuraGUIHelper.mouseOver((int)pX, (int)pY, (int)(this.f_97735_ + 149), (int)(this.f_97735_ + 160), (int)(this.f_97736_ + 91), (int)(this.f_97736_ + 106))) {
            int costXp = ((ResearcherEnchantmentShopMenu)this.f_97732_).getExperienceCost();
            ChatFormatting formatting = ResearcherEnchantmentShopMenu.getTotalXp((Player)((ResearcherEnchantmentShopMenu)this.f_97732_).getPlayer()) >= (long)costXp ? ChatFormatting.GREEN : ChatFormatting.RED;
            Map selectedEnchants = ResearcherSkill.getSelectedEnchantments((LivingEntity)((ResearcherEnchantmentShopMenu)this.f_97732_).getPlayer(), (ManasSkill)((ResearcherEnchantmentShopMenu)this.m_6262_()).getSkill());
            CostResult costResult = this.calculateCosts(selectedEnchants);
            ArrayList<MutableComponent> tooltipLines = new ArrayList<MutableComponent>();
            tooltipLines.add(Component.m_237110_((String)"tensura.researcher_menu.enchantment_tab.xp_cost", (Object[])new Object[]{costXp}).m_130940_(formatting));
            if (costResult.isStellarOnly()) {
                tooltipLines.add(Component.m_237113_((String)("Coins Cost: " + costResult.stellar + " Stellar Coin" + (costResult.stellar != 1 ? "s" : ""))));
            } else if (costResult.gold > 0 || costResult.silver > 0) {
                String s = String.format("%d Gold, %d Silver", costResult.gold, costResult.silver);
                tooltipLines.add(Component.m_237113_((String)("Coins Cost: " + s)));
            } else {
                tooltipLines.add(Component.m_237113_((String)"Coins Cost: Free"));
            }
            this.m_169388_(pPoseStack, tooltipLines, Optional.empty(), pX, pY);
        } else {
            int slotClicked = this.getSlotUnderMouse(pX, pY);
            if (slotClicked >= 0 && pX <= this.f_97735_ + 106) {
                int id = slotClicked + this.startIndex;
                Map map = ResearcherSkill.getAllEnchantments((LivingEntity)((ResearcherEnchantmentShopMenu)this.f_97732_).getPlayer(), (ManasSkill)((ResearcherEnchantmentShopMenu)this.m_6262_()).getSkill());
                if (!map.isEmpty() && id < map.entrySet().size()) {
                    Enchantment enchantment = (Enchantment)map.keySet().stream().toList().get(id);
                    UnitInfo unit = this.getUnitInfo(enchantment);
                    MutableComponent base = Component.m_237115_((String)enchantment.m_44704_()).m_130940_(this.getColor(enchantment));
                    MutableComponent costComp = "STELLAR".equals(unit.currency) ? Component.m_237113_((String)("  Cost: " + unit.unitPrice + " Stellar Coin" + (unit.unitPrice != 1 ? "s" : ""))).m_130940_(ChatFormatting.GOLD) : ("GOLD".equals(unit.currency) ? Component.m_237113_((String)("  Cost: " + unit.unitPrice + " Gold")).m_130940_(ChatFormatting.GOLD) : Component.m_237113_((String)("  Cost: " + unit.unitPrice + " Silver")).m_130940_(ChatFormatting.GOLD));
                    this.m_96602_(pPoseStack, (Component)base.m_7220_((Component)costComp), pX, pY);
                    return;
                }
            }
            super.m_7025_(pPoseStack, pX, pY);
        }
    }

    private ChatFormatting getColor(Enchantment enchantment) {
        ChatFormatting color;
        if (enchantment.m_6589_()) {
            color = ChatFormatting.RED;
        } else if (enchantment instanceof EngravingEnchantment) {
            color = ChatFormatting.GOLD;
        } else {
            color = switch (enchantment.m_44699_()) {
                case Enchantment.Rarity.COMMON -> ChatFormatting.YELLOW;
                case Enchantment.Rarity.UNCOMMON -> ChatFormatting.GREEN;
                case Enchantment.Rarity.RARE -> ChatFormatting.AQUA;
                case Enchantment.Rarity.VERY_RARE -> ChatFormatting.LIGHT_PURPLE;
                default -> throw new IncompatibleClassChangeError();
            };
        }
        return color;
    }

    private void renderEnchantments(PoseStack poseStack, int mX, int mY) {
        ArrayList enchantments = new ArrayList();
        ArrayList levels = new ArrayList();
        this.getAllEnchantments().forEach((key, value) -> {
            enchantments.add(key);
            levels.add(value);
        });
        int pos = 0;
        int endIndex = this.startIndex + 5;
        for (int i = this.startIndex; i < endIndex && i < enchantments.size(); ++i) {
            Enchantment enchantment = (Enchantment)enchantments.get(i);
            int level = (Integer)levels.get(i);
            MutableComponent name = Component.m_237115_((String)enchantment.m_44704_());
            ChatFormatting color = this.getColor(enchantment);
            Map map = ResearcherSkill.getSelectedEnchantments((LivingEntity)((ResearcherEnchantmentShopMenu)this.f_97732_).getPlayer(), (ManasSkill)((ResearcherEnchantmentShopMenu)this.m_6262_()).getSkill());
            boolean flag = TensuraGUIHelper.mouseOver((int)mX, (int)mY, (int)(this.f_97735_ + 21), (int)(this.f_97735_ + 107), (int)(this.f_97736_ + 66 + pos * 13), (int)(this.f_97736_ + 80 + pos * 13));
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.NAME_BAR);
            CustomResearcherEnchantmentScreen.m_93133_((PoseStack)poseStack, (int)(this.f_97735_ + 22), (int)(this.f_97736_ + 67 + pos * 13), (float)0.0f, (float)(flag ? 13.0f : 0.0f), (int)86, (int)13, (int)85, (int)26);
            CustomResearcherEnchantmentScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)TensuraGUIHelper.shortenTextComponent((Component)name.m_6881_().m_130940_(color), (int)14), (int)(this.f_97735_ + 27), (int)(this.f_97736_ + 70 + pos * 13), (int)(color.m_126665_() == null ? 0 : color.m_126665_()));
            int offsetX = 0;
            boolean hovering = TensuraGUIHelper.mouseOver((int)mX, (int)mY, (int)(this.f_97735_ + 8), (int)(this.f_97735_ + 22), (int)(this.f_97736_ + 67 + pos * 13), (int)(this.f_97736_ + 81 + pos * 13));
            if (hovering) {
                offsetX = 13;
            }
            int offsetY = map.containsKey(enchantment) ? 13 : 0;
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.CHECKBOX);
            CustomResearcherEnchantmentScreen.m_93133_((PoseStack)poseStack, (int)(this.f_97735_ + 8), (int)(this.f_97736_ + 67 + pos * 13), (float)offsetX, (float)offsetY, (int)13, (int)13, (int)26, (int)26);
            hovering = TensuraGUIHelper.mouseOver((int)mX, (int)mY, (int)(this.f_97735_ + 107), (int)(this.f_97735_ + 123), (int)(this.f_97736_ + 67 + pos * 13), (int)(this.f_97736_ + 81 + pos * 13));
            offsetY = hovering ? 13 : 0;
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.LEVEL_BOX);
            CustomResearcherEnchantmentScreen.m_93133_((PoseStack)poseStack, (int)(this.f_97735_ + 107), (int)(this.f_97736_ + 67 + pos * 13), (float)0.0f, (float)offsetY, (int)15, (int)13, (int)15, (int)26);
            int selectedLevel = map.getOrDefault(enchantment, level);
            MutableComponent levelComponent = selectedLevel <= 10 ? Component.m_237115_((String)("enchantment.level." + selectedLevel)) : Component.m_237113_((String)String.valueOf(selectedLevel));
            TensuraGUIHelper.renderCenteredXText((Font)this.f_96547_, (PoseStack)poseStack, (Component)levelComponent, (int)(this.f_97735_ + 108), (int)(this.f_97736_ + 70 + pos * 13), (int)15, (Color)Color.LIGHT_GRAY, (boolean)false);
            ++pos;
        }
    }

    private int getSlotUnderMouse(double pX, double pY) {
        for (int i = 0; i < 5; ++i) {
            if (!TensuraGUIHelper.mouseOver((double)pX, (double)pY, (int)(this.f_97735_ + 8), (int)(this.f_97735_ + 123), (int)(this.f_97736_ + 66 + i * 13), (int)(this.f_97736_ + 80 + i * 13))) continue;
            return i;
        }
        if (TensuraGUIHelper.mouseOver((double)pX, (double)pY, (int)(this.f_97735_ + 145), (int)(this.f_97735_ + 163), (int)(this.f_97736_ + 44), (int)(this.f_97736_ + 62))) {
            return -2;
        }
        return -1;
    }

    private Map<Enchantment, Integer> getAllEnchantments() {
        Map enchantments = ResearcherSkill.getAllEnchantments((LivingEntity)((ResearcherEnchantmentShopMenu)this.f_97732_).getPlayer(), (ManasSkill)((ResearcherEnchantmentShopMenu)this.m_6262_()).getSkill());
        this.offscreenRows = enchantments.size() - 5;
        if (this.startIndex > enchantments.size()) {
            this.startIndex = 0;
        }
        return enchantments;
    }

    public boolean m_6375_(double pX, double pY, int pButton) {
        this.handleScrollbarMouseClicked(pX, pY);
        int slotClicked = this.getSlotUnderMouse(pX, pY);
        if (!((ResearcherEnchantmentShopMenu)this.f_97732_).getItemInput().m_7983_() && slotClicked >= 0) {
            int id = slotClicked + this.startIndex;
            Map mapAll = ResearcherSkill.getAllEnchantments((LivingEntity)((ResearcherEnchantmentShopMenu)this.f_97732_).getPlayer(), (ManasSkill)((ResearcherEnchantmentShopMenu)this.m_6262_()).getSkill());
            if (!mapAll.isEmpty() && id < mapAll.entrySet().size()) {
                Enchantment enchantment = (Enchantment)mapAll.keySet().stream().toList().get(id);
                if (pX > (double)(this.f_97735_ + 106)) {
                    Map map = ResearcherSkill.getSelectedEnchantments((LivingEntity)((ResearcherEnchantmentShopMenu)this.f_97732_).getPlayer(), (ManasSkill)((ResearcherEnchantmentShopMenu)this.m_6262_()).getSkill());
                    if (enchantment != null && map.containsKey(enchantment)) {
                        int level = (Integer)map.get(enchantment) + 1;
                        if (level > ((ResearcherEnchantmentShopMenu)this.f_97732_).getMaxStoredLevel(enchantment)) {
                            level = 1;
                        }
                        TensuraNetwork.INSTANCE.sendToServer((Object)new RequestResearcherEnchantmentPacket(id, level));
                        TensuraGUIHelper.playSound((SoundEvent)SoundEvents.f_12088_, (float)1.0f);
                    }
                    return true;
                }
            }
            TensuraNetwork.INSTANCE.sendToServer((Object)new RequestResearcherEnchantmentPacket(id));
            TensuraGUIHelper.playSound((SoundEvent)SoundEvents.f_12013_, (float)1.0f);
            return true;
        }
        return super.m_6375_(pX, pY, pButton);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        this.handleScrollbarMouseScrolled(pDelta, 1);
        return true;
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        return this.handleScrollbarMouseDragged(pMouseY, 1) ? true : super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getOffscreenRows() {
        return this.offscreenRows;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    private UnitInfo getUnitInfo(Enchantment ench) {
        String key = ench.m_44704_().toLowerCase(Locale.ROOT);
        if (key.contains(".")) {
            String[] parts = key.split("\\.");
            key = parts[parts.length - 1];
        }
        if (key.contains("tsukumogami")) {
            return new UnitInfo("C", "SILVER", 0);
        }
        boolean isEngrave = ench instanceof EngravingEnchantment;
        if (isEngrave) {
            if (ENGRAVE_S.contains(key)) {
                return new UnitInfo("S", "STELLAR", this.getEngraveSPriceStellar());
            }
            if (ENGRAVE_A.contains(key)) {
                return new UnitInfo("A", "GOLD", this.getEngraveAPriceGold());
            }
            if (ENGRAVE_B.contains(key)) {
                return new UnitInfo("B", "GOLD", this.getEngraveBPriceGold());
            }
            if (ENGRAVE_F.contains(key)) {
                return new UnitInfo("F", "GOLD", this.getEngraveFPriceGold());
            }
            return new UnitInfo("B", "GOLD", this.getEngraveBPriceGold());
        }
        if (ENCHANT_S.contains(key)) {
            return new UnitInfo("S", "GOLD", this.getEnchantSPriceGold());
        }
        if (ENCHANT_A.contains(key)) {
            return new UnitInfo("A", "SILVER", this.getEnchantAPriceSilver());
        }
        if (ENCHANT_B.contains(key)) {
            return new UnitInfo("B", "SILVER", this.getEnchantBPriceSilver());
        }
        if (ENCHANT_C_TO_F.contains(key)) {
            return new UnitInfo("C", "SILVER", this.getEnchantCtoFPriceSilver());
        }
        return new UnitInfo("C", "SILVER", this.getEnchantCtoFPriceSilver());
    }

    private CostResult calculateCosts(Map<Enchantment, Integer> selected) {
        CostResult result = new CostResult();
        if (selected == null || selected.isEmpty()) {
            return result;
        }
        ItemStack inputItem = ((ResearcherEnchantmentShopMenu)this.f_97732_).getItemInput().m_8020_(0);
        if (inputItem.m_41619_()) {
            return result;
        }
        Map existing = EnchantmentHelper.m_44831_((ItemStack)inputItem);
        class ItemInfo {
            String currency;
            int price;

            ItemInfo() {
            }
        }
        ArrayList<ItemInfo> items = new ArrayList<ItemInfo>();
        for (Map.Entry<Enchantment, Integer> entry : selected.entrySet()) {
            Enchantment ench = entry.getKey();
            int desiredLevel = entry.getValue();
            int currentLevel = existing.getOrDefault(ench, 0);
            if (currentLevel >= desiredLevel) continue;
            UnitInfo u = this.getUnitInfo(ench);
            ItemInfo info = new ItemInfo();
            info.currency = u.currency;
            info.price = u.unitPrice;
            items.add(info);
        }
        int stellarSum = items.stream().filter(i -> "STELLAR".equals(i.currency)).mapToInt(i -> i.price).sum();
        if (stellarSum > 0) {
            result.stellarOnly = true;
            result.stellar = stellarSum;
            return result;
        }
        int goldSum = items.stream().filter(i -> "GOLD".equals(i.currency)).mapToInt(i -> i.price).sum();
        if (goldSum > 0) {
            result.gold = goldSum;
            return result;
        }
        int silverSum = items.stream().filter(i -> "SILVER".equals(i.currency)).mapToInt(i -> i.price).sum();
        if (silverSum > 0) {
            result.silver = silverSum;
        }
        return result;
    }

    static {
        TIER_RANK.put("S", 6);
        TIER_RANK.put("A", 5);
        TIER_RANK.put("B", 4);
        TIER_RANK.put("C", 3);
        TIER_RANK.put("D", 2);
        TIER_RANK.put("E", 1);
        TIER_RANK.put("F", 0);
    }

    private static class CostResult {
        public int stellar = 0;
        public int gold = 0;
        public int silver = 0;
        public boolean stellarOnly = false;

        private CostResult() {
        }

        public boolean isStellarOnly() {
            return this.stellarOnly;
        }
    }

    private static class UnitInfo {
        public final String tier;
        public final String currency;
        public final int unitPrice;

        public UnitInfo(String tier, String currency, int unitPrice) {
            this.tier = tier;
            this.currency = currency;
            this.unitPrice = unitPrice;
        }
    }
}

