/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.client.screen;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.item.food.HealingPotionItem;
import io.github.Memoires.trbeyond.client.screen.slot.SubordinateSlot;
import io.github.Memoires.trbeyond.client.screen.slot.SubspaceSlot;
import io.github.Memoires.trbeyond.container.SubspacePocketContainer;
import io.github.Memoires.trbeyond.items.custom.SubspacePocketItem;
import io.github.Memoires.trbeyond.registry.menu.BeyondMenus;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;

public class SubspaceContainerMenu
extends AbstractContainerMenu {
    private final SubspacePocketContainer container;
    private final ItemStack storageItem;

    public static SubspaceContainerMenu fromNetwork(int id, Inventory inv, FriendlyByteBuf extraData) {
        return new SubspaceContainerMenu(id, inv, inv.f_35978_, extraData.m_130267_());
    }

    public SubspaceContainerMenu(int pContainerId, Inventory inv, Player player, final ItemStack itemStack) {
        super((MenuType)BeyondMenus.SUBSPACE_CONTAINER_MENU.get(), pContainerId);
        Item item = itemStack.m_41720_();
        if (item instanceof SubspacePocketItem) {
            SubspacePocketItem subspacePocketItem = (SubspacePocketItem)item;
            this.container = new SubspacePocketContainer(subspacePocketItem.storageCapacity, subspacePocketItem.maxStackSize, subspacePocketItem.subordinateCapacity){

                public void m_6596_() {
                    itemStack.m_41784_().m_128365_("SpatialStorage", (Tag)this.m_7927_());
                }
            };
            this.container.m_7797_(itemStack.m_41784_().m_128437_("SpatialStorage", 10));
        } else {
            this.container = new SubspacePocketContainer(9, 64, 9);
        }
        this.storageItem = itemStack;
        SubspaceContainerMenu.m_38869_((Container)this.container, (int)this.container.m_6643_());
        this.container.m_5856_(player);
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.addSubordinateSlots();
        this.addSpatialSlots();
    }

    private void addPlayerInventory(Inventory inventory) {
        Vec2 offset = this.getInventoryOffset();
        for (int row = 0; row < 3; ++row) {
            for (int slot = 0; slot < 9; ++slot) {
                this.m_38897_(new Slot((Container)inventory, slot + row * 9 + 9, slot * 18 + (int)offset.f_82470_, row * 18 + (int)offset.f_82471_));
            }
        }
    }

    private void addPlayerHotbar(Inventory inventory) {
        Vec2 offset = this.getInventoryOffset();
        for (int slot = 0; slot < 9; ++slot) {
            if (slot == inventory.f_35977_ && inventory.m_8020_(slot).m_41720_() instanceof SubspacePocketItem) {
                this.m_38897_(new Slot((Container)inventory, slot, slot * 18 + (int)offset.f_82470_, 59 + (int)offset.f_82471_){

                    public boolean m_150651_(Player pPlayer) {
                        return false;
                    }

                    public boolean m_5857_(ItemStack pStack) {
                        return false;
                    }

                    public boolean m_8010_(Player pPlayer) {
                        return false;
                    }
                });
                continue;
            }
            this.m_38897_(new Slot((Container)inventory, slot, slot * 18 + (int)offset.f_82470_, 59 + (int)offset.f_82471_));
        }
    }

    private void addSubordinateSlots() {
        Vec2 offset = this.getSpatialSlotsOffset();
        for (int slot = 0; slot < this.container.getSubordinateCapacity(); ++slot) {
            this.m_38897_(new SubordinateSlot(this.container, slot, slot * 18 + (int)offset.f_82470_ + 92, (int)offset.f_82471_ + 38));
        }
    }

    private void addSpatialSlots() {
        Vec2 offset = this.getSpatialSlotsOffset();
        for (int row = 0; row < this.getContainerSize() / 9; ++row) {
            for (int slot = 0; slot < 9; ++slot) {
                this.m_38897_(new SubspaceSlot((Container)this.container, slot + row * 9, slot * 18 + (int)offset.f_82470_ + 20, row * 18 + (int)offset.f_82471_ + 74));
            }
        }
    }

    public int getContainerSize() {
        return this.container.m_6643_();
    }

    private Vec2 getInventoryOffset() {
        return switch (this.getContainerSize()) {
            case 9 -> new Vec2(20.0f, 158.0f);
            case 18 -> new Vec2(20.0f, 166.0f);
            case 27 -> new Vec2(20.0f, 170.0f);
            default -> new Vec2(0.0f, 0.0f);
        };
    }

    private Vec2 getSpatialSlotsOffset() {
        return switch (this.getContainerSize()) {
            case 9 -> new Vec2(0.0f, 0.0f);
            case 18 -> new Vec2(0.0f, 9.0f);
            case 27 -> new Vec2(0.0f, 9.0f);
            default -> new Vec2(0.0f, 0.0f);
        };
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (pIndex < 36 ? !this.m_38903_(itemstack1, 36, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    protected boolean m_38903_(ItemStack pStack, int pStartIndex, int pEndIndex, boolean pReverseDirection) {
        boolean flag = false;
        int i = pStartIndex;
        if (pReverseDirection) {
            i = pEndIndex - 1;
        }
        if (pStack.m_41753_() || pStartIndex == 36 && pStack.m_41720_() instanceof HealingPotionItem) {
            while (!pStack.m_41619_() && !(!pReverseDirection ? i >= pEndIndex : i < pStartIndex)) {
                Slot slot = (Slot)this.f_38839_.get(i);
                ItemStack itemstack = slot.m_7993_();
                if (!itemstack.m_41619_() && ItemStack.m_150942_((ItemStack)pStack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.m_41613_() + pStack.m_41613_();
                    if (j <= (maxSize = slot.m_5866_(pStack))) {
                        pStack.m_41764_(0);
                        itemstack.m_41764_(j);
                        slot.m_6654_();
                        flag = true;
                    } else if (itemstack.m_41613_() < maxSize) {
                        pStack.m_41774_(maxSize - itemstack.m_41613_());
                        itemstack.m_41764_(maxSize);
                        slot.m_6654_();
                        flag = true;
                    }
                }
                if (pReverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!pStack.m_41619_()) {
            i = pReverseDirection ? pEndIndex - 1 : pStartIndex;
            while (!(!pReverseDirection ? i >= pEndIndex : i < pStartIndex)) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                ItemStack itemstack1 = slot1.m_7993_();
                if (itemstack1.m_41619_() && slot1.m_5857_(pStack)) {
                    if (pStack.m_41613_() > slot1.m_5866_(pStack)) {
                        slot1.m_5852_(pStack.m_41620_(slot1.m_5866_(pStack)));
                    } else {
                        slot1.m_5852_(pStack.m_41620_(pStack.m_41613_()));
                    }
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                if (pReverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void m_150430_(int pSlotId, int pButton, ClickType pClickType, Player pPlayer) {
        if (pClickType == ClickType.SWAP) {
            Inventory inventory = pPlayer.m_150109_();
            Slot hoveredSlot = (Slot)this.f_38839_.get(pSlotId);
            ItemStack hotbarStack = inventory.m_8020_(pButton);
            ItemStack hoveredStack = hoveredSlot.m_7993_();
            if (!hotbarStack.m_41619_() || !hoveredStack.m_41619_()) {
                if (hotbarStack.m_41619_()) {
                    if (hoveredSlot.m_8010_(pPlayer)) {
                        if (hoveredStack.m_41613_() > hoveredStack.m_41741_()) {
                            inventory.m_6836_(pButton, hoveredStack.m_41620_(hoveredStack.m_41741_()));
                        } else {
                            inventory.m_6836_(pButton, hoveredStack);
                            hoveredSlot.m_5852_(ItemStack.f_41583_);
                        }
                        hoveredSlot.m_142406_(pPlayer, hoveredStack);
                    }
                } else if (hoveredStack.m_41619_()) {
                    if (hoveredSlot.m_5857_(hotbarStack)) {
                        int l1 = hoveredSlot.m_5866_(hotbarStack);
                        if (hotbarStack.m_41613_() > l1) {
                            hoveredSlot.m_5852_(hotbarStack.m_41620_(l1));
                        } else {
                            inventory.m_6836_(pButton, ItemStack.f_41583_);
                            hoveredSlot.m_5852_(hotbarStack);
                        }
                    }
                } else if (hoveredSlot.m_8010_(pPlayer) && hoveredSlot.m_5857_(hotbarStack)) {
                    int hoveredMaxStackSize = hoveredSlot.m_5866_(hotbarStack);
                    if (hotbarStack.m_41613_() > hoveredMaxStackSize) {
                        hoveredSlot.m_5852_(hotbarStack.m_41620_(hoveredMaxStackSize));
                        hoveredSlot.m_142406_(pPlayer, hoveredStack);
                        if (!inventory.m_36054_(hoveredStack)) {
                            pPlayer.m_36176_(hoveredStack, true);
                        }
                    } else {
                        ItemStack extraStack;
                        int hoveredBaseMaxStackSize;
                        int hoveredStackCount = hoveredStack.m_41613_();
                        if (hoveredStackCount > (hoveredBaseMaxStackSize = hoveredStack.m_41741_()) && !inventory.m_36054_(extraStack = hoveredStack.m_41620_(hoveredStackCount - hoveredBaseMaxStackSize))) {
                            pPlayer.m_36176_(hoveredStack, true);
                        }
                        inventory.m_6836_(pButton, hoveredStack);
                        hoveredSlot.m_5852_(hotbarStack);
                        hoveredSlot.m_142406_(pPlayer, hoveredStack);
                    }
                }
            }
        } else {
            super.m_150430_(pSlotId, pButton, pClickType, pPlayer);
        }
    }

    public boolean m_6875_(@NotNull Player pPlayer) {
        return true;
    }

    public void m_6877_(@NotNull Player player) {
        this.storageItem.m_41784_().m_128365_("SpatialStorage", (Tag)this.container.m_7927_());
        ItemStack stack = player.f_36096_.m_142621_();
        if (!stack.m_41619_()) {
            this.m_38903_(stack, 0, 36, false);
            if (stack.m_41613_() > 0) {
                SkillHelper.dropItem((Entity)player, (RandomSource)player.m_217043_(), (ItemStack)stack, (int)10, (float)0.5f);
            }
        }
    }

    public boolean isThisContainerItem(@NotNull ItemStack item) {
        return this.storageItem == item;
    }
}

