/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.Memoires.trbeyond.network.worldgen.DungeonSaveData;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class ClearDungeonCommand {
    public static boolean dungeonCleared = false;
    public static boolean createDungeon = false;
    public static int NUM_STRUCTURES = 10;
    public static double LOOPBACK_PROB = 0.75;
    public static double DEADEND_PROB = 0.6;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"cleardungeon").requires(source -> source.m_6761_(2))).executes(ctx -> ClearDungeonCommand.clearDungeon((CommandSourceStack)ctx.getSource())));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"createdungeon").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"num_structures", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"loopback_prob", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)1.0)).then(Commands.m_82129_((String)"deadend_prob", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)1.0)).executes(ctx -> ClearDungeonCommand.createDungeon((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"num_structures"), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"loopback_prob"), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"deadend_prob")))))));
    }

    private static int createDungeon(CommandSourceStack source, int numStructures, double loopbackProb, double deadendProb) {
        NUM_STRUCTURES = numStructures;
        LOOPBACK_PROB = loopbackProb;
        DEADEND_PROB = deadendProb;
        source.m_81354_((Component)Component.m_237113_((String)"Dungeon parameters set:"), false);
        source.m_81354_((Component)Component.m_237113_((String)(" - NUM_STRUCTURES: " + NUM_STRUCTURES)), false);
        source.m_81354_((Component)Component.m_237113_((String)(" - LOOPBACK_PROB: " + LOOPBACK_PROB)), false);
        source.m_81354_((Component)Component.m_237113_((String)(" - DEADEND_PROB: " + DEADEND_PROB)), false);
        createDungeon = true;
        return 1;
    }

    private static int clearDungeon(CommandSourceStack source) {
        ResourceKey dungeonDim = ResourceKey.m_135785_((ResourceKey)ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("minecraft", "dimension")), (ResourceLocation)new ResourceLocation("trbeyond", "dungeon"));
        ServerLevel dungeon = source.m_81377_().m_129880_(dungeonDim);
        if (dungeon == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Dungeon dimension not found."));
            return 0;
        }
        DungeonSaveData.getOverworld((Level)dungeon).clearAllChestCooldown();
        DungeonSaveData.getOverworld((Level)dungeon).clearAllShrineCooldown();
        DungeonSaveData.getOverworld((Level)dungeon).setLoaded(false);
        for (ServerLevel serverLevel : source.m_81377_().m_129785_()) {
            if (serverLevel.m_46472_() != dungeonDim) continue;
            serverLevel.m_142646_().m_142273_().forEach(entity -> {
                if (!entity.m_213877_()) {
                    entity.m_146870_();
                }
            });
        }
        int minY = dungeon.m_141937_();
        int maxY = dungeon.m_151558_();
        int radius = 1024;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = minY; y < maxY; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    if (dungeon.m_8055_(new BlockPos(x, y, z)).m_60795_()) continue;
                    dungeon.m_46597_(new BlockPos(x, y, z), Blocks.f_50016_.m_49966_());
                }
            }
        }
        source.m_81354_((Component)Component.m_237113_((String)"Dungeon cleared."), true);
        dungeonCleared = true;
        return 1;
    }
}

