/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.Memoires.trbeyond.block.ShrineBlock;
import io.github.Memoires.trbeyond.capability.dungeon.DungeonCapability;
import io.github.Memoires.trbeyond.config.ServerConfig;
import io.github.Memoires.trbeyond.network.worldgen.dimension.BeyondDungeon;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.server.command.EnumArgument;

public class DungeonStatsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dungeonStats").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"labyrinth").requires(source -> source.m_6761_(2))).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            ServerLevel labyrinthLevel = source.m_81377_().m_129880_(BeyondDungeon.DUNGEON_LEVEL_KEY);
            if (labyrinthLevel != null) {
                List players = labyrinthLevel.m_6907_();
                String playerNames = players.stream().map(p -> p.m_7755_().getString()).collect(Collectors.joining(", "));
                MutableComponent playerCountComponent = Component.m_237113_((String)String.valueOf(players.size())).m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)(playerNames.isEmpty() ? "Nobody" : playerNames)))).m_131140_(ChatFormatting.YELLOW));
                source.m_81354_((Component)Component.m_237110_((String)"trbeyond.message.dungeon_player_count", (Object[])new Object[]{playerCountComponent}), false);
            } else {
                source.m_81352_((Component)Component.m_237115_((String)"trbeyond.message.dungeon_not_loaded"));
            }
            return 1;
        }))).then(Commands.m_82127_((String)"playerStats").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"setChallengeCount").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"tier", (ArgumentType)EnumArgument.enumArgument(ShrineBlock.DungeonShrineTier.class)).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            ServerPlayer targetPlayer = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            ShrineBlock.DungeonShrineTier tier = (ShrineBlock.DungeonShrineTier)((Object)((Object)ctx.getArgument("tier", ShrineBlock.DungeonShrineTier.class)));
            Integer completions = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count");
            DungeonCapability.getFrom((LivingEntity)targetPlayer).ifPresent(cap -> {
                cap.setChallengeCompletionCount(tier, completions);
                source.m_81354_((Component)Component.m_237110_((String)"trbeyond.message.player_stats.challenges.set_completions", (Object[])new Object[]{tier.name(), completions}), true);
            });
            return 1;
        }))))).executes(ctx -> {
            ServerPlayer sourcePlayer;
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            ServerPlayer targetPlayer = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            Entity patt5061$temp = source.m_81373_();
            boolean isSelf = patt5061$temp instanceof ServerPlayer && (sourcePlayer = (ServerPlayer)patt5061$temp).m_20148_().equals(targetPlayer.m_20148_());
            boolean isOP = source.m_6761_(2);
            if (isSelf || isOP) {
                long cooldownDuration = (Long)ServerConfig.INSTANCE.dungeonConfig.enterCooldown.get();
                long remainingCooldown = -1L;
                if (targetPlayer.getPersistentData().m_128441_("dungeonEnterCooldown")) {
                    long entryCooldown = targetPlayer.getPersistentData().m_128454_("dungeonEnterCooldown");
                    long currentTime = System.currentTimeMillis() / 1000L;
                    remainingCooldown = entryCooldown + cooldownDuration - currentTime;
                }
                if (remainingCooldown > 0L) {
                    source.m_81354_((Component)Component.m_237110_((String)"trbeyond.message.player_stats", (Object[])new Object[]{targetPlayer.m_7755_(), remainingCooldown}), false);
                } else {
                    source.m_81354_((Component)Component.m_237110_((String)"trbeyond.message.player_stats.no_cooldown", (Object[])new Object[]{targetPlayer.m_7755_()}), false);
                }
                DungeonCapability.getFrom((LivingEntity)targetPlayer).ifPresent(cap -> {
                    source.m_81354_((Component)Component.m_237110_((String)"trbeyond.message.player_stats.challenges.header", (Object[])new Object[]{targetPlayer.m_7755_()}), false);
                    List<ShrineBlock.DungeonShrineTier> tiers = Arrays.stream(ShrineBlock.DungeonShrineTier.values()).toList();
                    for (ShrineBlock.DungeonShrineTier tier : tiers) {
                        source.m_81354_((Component)Component.m_237110_((String)"trbeyond.message.player_stats.challenges.count", (Object[])new Object[]{cap.getChallengeCompletionCount(tier), tier.name()}), false);
                    }
                });
            } else {
                source.m_81352_((Component)Component.m_237115_((String)"trbeyond.message.player_stats.deny"));
            }
            return 1;
        }))));
    }
}

