/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trbeyond.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.github.Memoires.trbeyond.capability.player.BeyondPlayerCapability;
import io.github.Memoires.trbeyond.handlers.ChallengeEventHandler;
import io.github.Memoires.trbeyond.util.ChallengeType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntitySummonArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class SummonEliteCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.summon.failed"));
    private static final SimpleCommandExceptionType ERROR_DUPLICATE_UUID = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.summon.failed.uuid"));
    private static final SimpleCommandExceptionType INVALID_POSITION = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.summon.invalidPosition"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dungeon").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"summonelite").then(Commands.m_82129_((String)"entity", (ArgumentType)EntitySummonArgument.m_93335_()).suggests(SuggestionProviders.f_121645_).executes(ctx -> SummonEliteCommand.summonElite((CommandSourceStack)ctx.getSource(), EntitySummonArgument.m_93338_((CommandContext)ctx, (String)"entity"), ((CommandSourceStack)ctx.getSource()).m_81371_(), new CompoundTag(), true))))).then(Commands.m_82127_((String)"clearChallenge").executes(SummonEliteCommand::clearChallengeCommand)));
    }

    private static int clearChallengeCommand(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = source.m_230896_();
        if (player != null) {
            BeyondPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                ChallengeType challenge = cap.getChallengeType();
                if (challenge == null) {
                    source.m_81352_((Component)Component.m_237113_((String)"Player doesn't have a challenge"));
                } else if (challenge.getCategory() != "shrine") {
                    ChallengeEventHandler.failChallenge((Player)player, challenge);
                    source.m_81354_((Component)Component.m_237113_((String)"Challenge removed."), false);
                } else {
                    source.m_81352_((Component)Component.m_237113_((String)"Not allowed on shrine challenges."));
                }
            });
        }
        return 1;
    }

    private static int summonElite(CommandSourceStack pSource, ResourceLocation pType, Vec3 pPos, CompoundTag pNbt, boolean pRandomizeProperties) throws CommandSyntaxException {
        BlockPos blockpos = new BlockPos(pPos);
        if (!Level.m_46741_((BlockPos)blockpos)) {
            throw INVALID_POSITION.create();
        }
        CompoundTag compoundtag = pNbt.m_6426_();
        compoundtag.m_128359_("id", pType.toString());
        ServerLevel serverlevel = pSource.m_81372_();
        Entity entity = EntityType.m_20645_((CompoundTag)compoundtag, (Level)serverlevel, p_138828_ -> {
            p_138828_.m_7678_(pPos.f_82479_, pPos.f_82480_, pPos.f_82481_, p_138828_.m_146908_(), p_138828_.m_146909_());
            return p_138828_;
        });
        if (entity == null) {
            throw ERROR_FAILED.create();
        }
        if (pRandomizeProperties && entity instanceof Mob) {
            if (!ForgeEventFactory.doSpecialSpawn((Mob)((Mob)entity), (LevelAccessor)pSource.m_81372_(), (float)((float)entity.m_20185_()), (float)((float)entity.m_20186_()), (float)((float)entity.m_20189_()), null, (MobSpawnType)MobSpawnType.COMMAND)) {
                ((Mob)entity).m_6518_((ServerLevelAccessor)pSource.m_81372_(), pSource.m_81372_().m_6436_(entity.m_20183_()), MobSpawnType.COMMAND, (SpawnGroupData)null, (CompoundTag)null);
            }
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.getPersistentData().m_128379_("spawnElite", true);
            }
        }
        if (!serverlevel.m_8860_(entity)) {
            throw ERROR_DUPLICATE_UUID.create();
        }
        pSource.m_81354_((Component)Component.m_237110_((String)"commands.summon.success", (Object[])new Object[]{entity.m_5446_()}), true);
        return 1;
    }
}

